/*
 * Decompiled with CFR 0.152.
 */
package slexom.earthtojava.init;

import dev.architectury.registry.registries.RegistrySupplier;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import slexom.earthtojava.Earth2JavaMod;
import slexom.earthtojava.block.CarvedMelonBlock;
import slexom.earthtojava.block.RainbowBedBlock;
import slexom.earthtojava.utils.Utils;

public final class BlockInit {
    public static final RegistrySupplier<Block> BUTTERCUP;
    public static final RegistrySupplier<Block> CARVED_MELON;
    public static final RegistrySupplier<Block> MELON_GOLEM_HEAD_BLINK;
    public static final RegistrySupplier<Block> MELON_GOLEM_HEAD_SHOOT;
    public static final RegistrySupplier<Block> MELON_LANTERN;
    public static final RegistrySupplier<Block> PINK_DAISY;
    public static final RegistrySupplier<FlowerPotBlock> POTTED_BUTTERCUP;
    public static final RegistrySupplier<FlowerPotBlock> POTTED_PINK_DAISY;
    public static final RegistrySupplier<Block> RAINBOW_BED;
    public static final RegistrySupplier<Block> RAINBOW_CARPET;
    public static final RegistrySupplier<Block> RAINBOW_WOOL;
    private static final BlockBehaviour.Properties FLOWERS_SETTINGS;
    private static final BlockBehaviour.Properties CARVED_MELON_SETTINGS;
    private static final BlockBehaviour.Properties POTTED_FLOWER_SETTINGS;

    private BlockInit() {
        throw new IllegalStateException("Utility class");
    }

    public static void init() {
    }

    public static void onPostInit() {
        BlockInit.registerCompostable();
        BlockInit.registerFlammable();
    }

    public static void registerCompostable() {
        ComposterBlock.f_51914_.put((Object)((Block)BUTTERCUP.get()).m_5456_(), 0.65f);
        ComposterBlock.f_51914_.put((Object)((Block)PINK_DAISY.get()).m_5456_(), 0.65f);
    }

    public static void registerFlammable() {
        BlockInit.flammableBlock((Block)BUTTERCUP.get(), 60, 100);
        BlockInit.flammableBlock((Block)PINK_DAISY.get(), 60, 100);
        BlockInit.flammableBlock((Block)RAINBOW_CARPET.get(), 60, 20);
        BlockInit.flammableBlock((Block)RAINBOW_WOOL.get(), 30, 60);
    }

    private static void flammableBlock(Block block, int encouragement, int flammability) {
        FireBlock fire = (FireBlock)Blocks.f_50083_;
        fire.m_53444_(block, encouragement, flammability);
    }

    static {
        FLOWERS_SETTINGS = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60910_().m_60966_().m_60918_(SoundType.f_56740_).m_222979_(BlockBehaviour.OffsetType.XZ).m_278166_(PushReaction.DESTROY);
        CARVED_MELON_SETTINGS = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283916_).m_60978_(1.0f).m_60918_(SoundType.f_56736_).m_60922_((state, world, pos, type) -> true).m_278166_(PushReaction.DESTROY);
        POTTED_FLOWER_SETTINGS = BlockBehaviour.Properties.m_284310_().m_60966_().m_60955_().m_278166_(PushReaction.DESTROY);
        BUTTERCUP = Earth2JavaMod.BLOCK_REGISTRAR.register(Utils.modIdentifierOf("buttercup"), () -> new FlowerBlock(MobEffects.f_19603_, 5, FLOWERS_SETTINGS));
        PINK_DAISY = Earth2JavaMod.BLOCK_REGISTRAR.register(Utils.modIdentifierOf("pink_daisy"), () -> new FlowerBlock(MobEffects.f_19603_, 5, FLOWERS_SETTINGS));
        CARVED_MELON = Earth2JavaMod.BLOCK_REGISTRAR.register(Utils.modIdentifierOf("carved_melon"), () -> new CarvedMelonBlock(CARVED_MELON_SETTINGS));
        MELON_GOLEM_HEAD_BLINK = Earth2JavaMod.BLOCK_REGISTRAR.register(Utils.modIdentifierOf("melon_golem_blink"), () -> new CarvedMelonBlock(CARVED_MELON_SETTINGS));
        MELON_GOLEM_HEAD_SHOOT = Earth2JavaMod.BLOCK_REGISTRAR.register(Utils.modIdentifierOf("melon_golem_shoot"), () -> new CarvedMelonBlock(CARVED_MELON_SETTINGS));
        MELON_LANTERN = Earth2JavaMod.BLOCK_REGISTRAR.register(Utils.modIdentifierOf("melon_lantern"), () -> new CarvedMelonBlock(CARVED_MELON_SETTINGS.m_60953_(state -> 15)));
        POTTED_BUTTERCUP = Earth2JavaMod.BLOCK_REGISTRAR.register(Utils.modIdentifierOf("potted_buttercup"), () -> new FlowerPotBlock((Block)BUTTERCUP.get(), POTTED_FLOWER_SETTINGS));
        POTTED_PINK_DAISY = Earth2JavaMod.BLOCK_REGISTRAR.register(Utils.modIdentifierOf("potted_pink_daisy"), () -> new FlowerPotBlock((Block)PINK_DAISY.get(), POTTED_FLOWER_SETTINGS));
        RAINBOW_BED = Earth2JavaMod.BLOCK_REGISTRAR.register(Utils.modIdentifierOf("rainbow_bed"), () -> new RainbowBedBlock(DyeColor.WHITE, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283930_).m_60918_(SoundType.f_56736_).m_60978_(0.2f).m_60955_().m_278183_().m_278166_(PushReaction.DESTROY)));
        RAINBOW_CARPET = Earth2JavaMod.BLOCK_REGISTRAR.register(Utils.modIdentifierOf("rainbow_carpet"), () -> new CarpetBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283811_).m_60978_(0.1f).m_60918_(SoundType.f_56745_).m_278183_()));
        RAINBOW_WOOL = Earth2JavaMod.BLOCK_REGISTRAR.register(Utils.modIdentifierOf("rainbow_wool"), () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283811_).m_280658_(NoteBlockInstrument.GUITAR).m_60978_(0.8f).m_60918_(SoundType.f_56745_).m_278183_()));
    }
}

