/*
 * Decompiled with CFR 0.152.
 */
package slexom.earthtojava.init;

import dev.architectury.registry.level.biome.BiomeModifications;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Predicate;
import me.shedaniel.autoconfig.AutoConfig;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.Heightmap;
import slexom.earthtojava.config.ModConfig;
import slexom.earthtojava.init.EntityTypesInit;
import slexom.earthtojava.mixins.SpawnRestrictionAccessor;
import slexom.earthtojava.utils.EntitySpawnConfigHolder;
import slexom.earthtojava.world.biome.SpawnPredicates;

public final class EntitySpawnInit {
    private static final ModConfig config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();

    private EntitySpawnInit() {
        throw new IllegalStateException("Utility class");
    }

    public static void init() {
        EntitySpawnInit.manageAnimalEntities();
        EntitySpawnInit.manageMonsterEntities();
    }

    public static void initSpawnRestriction() {
        EntitySpawnInit.registerCreatureSpawnRestriction(EntityTypesInit.ALBINO_COW_REGISTRY_OBJECT);
        EntitySpawnInit.registerCreatureSpawnRestriction(EntityTypesInit.AMBER_CHICKEN_REGISTRY_OBJECT);
        EntitySpawnInit.registerCreatureSpawnRestriction(EntityTypesInit.ASHEN_COW_REGISTRY_OBJECT);
        EntitySpawnInit.registerCreatureSpawnRestriction(EntityTypesInit.BRONZED_CHICKEN_REGISTRY_OBJECT);
        EntitySpawnInit.registerCreatureSpawnRestriction(EntityTypesInit.BOLD_STRIPED_RABBIT_REGISTRY_OBJECT);
        EntitySpawnInit.registerCreatureSpawnRestriction(EntityTypesInit.COOKIE_COW_REGISTRY_OBJECT);
        EntitySpawnInit.registerCreatureSpawnRestriction(EntityTypesInit.CREAM_COW_REGISTRY_OBJECT);
        EntitySpawnInit.registerCreatureSpawnRestriction(EntityTypesInit.DAIRY_COW_REGISTRY_OBJECT);
        EntitySpawnInit.registerCreatureSpawnRestriction(EntityTypesInit.PINTO_COW_REGISTRY_OBJECT);
        EntitySpawnInit.registerCreatureSpawnRestriction(EntityTypesInit.CLUCKSHROOM_REGISTRY_OBJECT);
        EntitySpawnInit.registerCreatureSpawnRestriction(EntityTypesInit.FANCY_CHICKEN_REGISTRY_OBJECT);
        EntitySpawnInit.registerCreatureSpawnRestriction(EntityTypesInit.FLECKED_SHEEP_REGISTRY_OBJECT);
        EntitySpawnInit.registerCreatureSpawnRestriction(EntityTypesInit.FRECKLED_RABBIT_REGISTRY_OBJECT);
        EntitySpawnInit.registerCreatureSpawnRestriction(EntityTypesInit.FUZZY_SHEEP_REGISTRY_OBJECT);
        EntitySpawnInit.registerCreatureSpawnRestriction(EntityTypesInit.GOLD_CRESTED_CHICKEN_REGISTRY_OBJECT);
        EntitySpawnInit.registerCreatureSpawnRestriction(EntityTypesInit.HARELEQUIN_RABBIT_REGISTRY_OBJECT);
        EntitySpawnInit.registerCreatureSpawnRestriction(EntityTypesInit.HORNED_SHEEP_REGISTRY_OBJECT);
        EntitySpawnInit.registerCreatureSpawnRestriction(EntityTypesInit.INKY_SHEEP_REGISTRY_OBJECT);
        EntitySpawnInit.registerCreatureSpawnRestriction(EntityTypesInit.JOLLY_LLAMA_REGISTRY_OBJECT);
        EntitySpawnInit.registerCreatureSpawnRestriction(EntityTypesInit.JUMBO_RABBIT_REGISTRY_OBJECT);
        EntitySpawnInit.registerCreatureSpawnRestriction(EntityTypesInit.LONG_NOSED_SHEEP_REGISTRY_OBJECT);
        EntitySpawnInit.registerCreatureSpawnRestriction(EntityTypesInit.MIDNIGHT_CHICKEN_REGISTRY_OBJECT);
        EntitySpawnInit.registerCreatureSpawnRestriction(EntityTypesInit.MOOBLOOM_REGISTRY_OBJECT);
        EntitySpawnInit.registerCreatureSpawnRestriction(EntityTypesInit.MOOLIP_REGISTRY_OBJECT);
        EntitySpawnInit.registerCreatureSpawnRestriction(EntityTypesInit.MOTTLED_PIG_REGISTRY_OBJECT);
        EntitySpawnInit.registerCreatureSpawnRestriction(EntityTypesInit.MUDDY_PIG_REGISTRY_OBJECT);
        EntitySpawnInit.registerCreatureSpawnRestriction(EntityTypesInit.MUDDY_FOOT_RABBIT_REGISTRY_OBJECT);
        EntitySpawnInit.registerCreatureSpawnRestriction(EntityTypesInit.PALE_PIG_REGISTRY_OBJECT);
        EntitySpawnInit.registerCreatureSpawnRestriction(EntityTypesInit.PATCHED_SHEEP_REGISTRY_OBJECT);
        EntitySpawnInit.registerCreatureSpawnRestriction(EntityTypesInit.PIEBALD_PIG_REGISTRY_OBJECT);
        EntitySpawnInit.registerCreatureSpawnRestriction(EntityTypesInit.PINK_FOOTED_PIG_REGISTRY_OBJECT);
        EntitySpawnInit.registerCreatureSpawnRestriction(EntityTypesInit.RAINBOW_SHEEP_REGISTRY_OBJECT);
        EntitySpawnInit.registerCreatureSpawnRestriction(EntityTypesInit.ROCKY_SHEEP_REGISTRY_OBJECT);
        EntitySpawnInit.registerCreatureSpawnRestriction(EntityTypesInit.SKEWBALD_CHICKEN_REGISTRY_OBJECT);
        EntitySpawnInit.registerCreatureSpawnRestriction(EntityTypesInit.SOOTY_PIG_REGISTRY_OBJECT);
        EntitySpawnInit.registerCreatureSpawnRestriction(EntityTypesInit.SPOTTED_PIG_REGISTRY_OBJECT);
        EntitySpawnInit.registerCreatureSpawnRestriction(EntityTypesInit.STORMY_CHICKEN_REGISTRY_OBJECT);
        EntitySpawnInit.registerCreatureSpawnRestriction(EntityTypesInit.SUNSET_COW_REGISTRY_OBJECT);
        EntitySpawnInit.registerCreatureSpawnRestriction(EntityTypesInit.UMBRA_COW_REGISTRY_OBJECT);
        EntitySpawnInit.registerCreatureSpawnRestriction(EntityTypesInit.VESTED_RABBIT_REGISTRY_OBJECT);
        EntitySpawnInit.registerCreatureSpawnRestriction(EntityTypesInit.WOOLY_COW_REGISTRY_OBJECT);
        EntitySpawnInit.registerMonsterSpawnRestriction(EntityTypesInit.BONE_SPIDER_REGISTRY_OBJECT);
        EntitySpawnInit.registerMonsterSpawnRestriction(EntityTypesInit.BOULDERING_ZOMBIE_REGISTRY_OBJECT);
        EntitySpawnInit.registerMonsterSpawnRestriction(EntityTypesInit.LOBBER_ZOMBIE_REGISTRY_OBJECT);
        EntitySpawnInit.registerMonsterSpawnRestriction(EntityTypesInit.SKELETON_WOLF_REGISTRY_OBJECT);
        EntitySpawnInit.registerMonsterSpawnRestriction(EntityTypesInit.TROPICAL_SLIME_REGISTRY_OBJECT);
        EntitySpawnInit.registerMonsterSpawnRestriction(EntityTypesInit.VILER_WITCH_REGISTRY_OBJECT);
    }

    private static <T extends Animal> void registerCreatureSpawnRestriction(RegistrySupplier<EntityType<T>> entity) {
        SpawnRestrictionAccessor.callRegister((EntityType)entity.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_218104_);
    }

    private static <T extends Monster> void registerMonsterSpawnRestriction(RegistrySupplier<EntityType<T>> entity) {
        SpawnRestrictionAccessor.callRegister((EntityType)entity.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_);
    }

    private static void manageAnimalEntities() {
        EntitySpawnInit.registerAnimalEntitySpawn(EntityTypesInit.AMBER_CHICKEN_REGISTRY_OBJECT, new EntitySpawnConfigHolder(SpawnPredicates.AMBER_CHICKEN_SPAWN_BIOMES_PREDICATE, EntitySpawnInit.config.amberChicken));
        EntitySpawnInit.registerAnimalEntitySpawn(EntityTypesInit.BRONZED_CHICKEN_REGISTRY_OBJECT, new EntitySpawnConfigHolder(SpawnPredicates.BRONZED_CHICKEN_SPAWN_BIOMES_PREDICATE, EntitySpawnInit.config.bronzedChicken));
        EntitySpawnInit.registerAnimalEntitySpawn(EntityTypesInit.FANCY_CHICKEN_REGISTRY_OBJECT, new EntitySpawnConfigHolder(SpawnPredicates.FANCY_CHICKEN_SPAWN_BIOMES_PREDICATE, EntitySpawnInit.config.fancyChicken));
        EntitySpawnInit.registerAnimalEntitySpawn(EntityTypesInit.GOLD_CRESTED_CHICKEN_REGISTRY_OBJECT, new EntitySpawnConfigHolder(SpawnPredicates.GOLD_CRESTED_CHICKEN_SPAWN_BIOMES_PREDICATE, EntitySpawnInit.config.goldCrestedChicken));
        EntitySpawnInit.registerAnimalEntitySpawn(EntityTypesInit.MIDNIGHT_CHICKEN_REGISTRY_OBJECT, new EntitySpawnConfigHolder(SpawnPredicates.MIDNIGHT_CHICKEN_SPAWN_BIOMES_PREDICATE, EntitySpawnInit.config.midnightChicken));
        EntitySpawnInit.registerAnimalEntitySpawn(EntityTypesInit.SKEWBALD_CHICKEN_REGISTRY_OBJECT, new EntitySpawnConfigHolder(SpawnPredicates.SKEWBALD_CHICKEN_SPAWN_BIOMES_PREDICATE, EntitySpawnInit.config.skewbaldChicken));
        EntitySpawnInit.registerAnimalEntitySpawn(EntityTypesInit.STORMY_CHICKEN_REGISTRY_OBJECT, new EntitySpawnConfigHolder(SpawnPredicates.STORMY_CHICKEN_SPAWN_BIOMES_PREDICATE, EntitySpawnInit.config.stormyChicken));
        EntitySpawnInit.registerAnimalEntitySpawn(EntityTypesInit.ALBINO_COW_REGISTRY_OBJECT, new EntitySpawnConfigHolder(SpawnPredicates.ALBINO_COW_SPAWN_BIOMES_PREDICATE, EntitySpawnInit.config.albinoCow));
        EntitySpawnInit.registerAnimalEntitySpawn(EntityTypesInit.ASHEN_COW_REGISTRY_OBJECT, new EntitySpawnConfigHolder(SpawnPredicates.ASHEN_COW_SPAWN_BIOMES_PREDICATE, EntitySpawnInit.config.ashenCow));
        EntitySpawnInit.registerAnimalEntitySpawn(EntityTypesInit.COOKIE_COW_REGISTRY_OBJECT, new EntitySpawnConfigHolder(SpawnPredicates.COOKIE_COW_SPAWN_BIOMES_PREDICATE, EntitySpawnInit.config.cookieCow));
        EntitySpawnInit.registerAnimalEntitySpawn(EntityTypesInit.CREAM_COW_REGISTRY_OBJECT, new EntitySpawnConfigHolder(SpawnPredicates.CREAM_COW_SPAWN_BIOMES_PREDICATE, EntitySpawnInit.config.creamCow));
        EntitySpawnInit.registerAnimalEntitySpawn(EntityTypesInit.DAIRY_COW_REGISTRY_OBJECT, new EntitySpawnConfigHolder(SpawnPredicates.DAIRY_COW_SPAWN_BIOMES_PREDICATE, EntitySpawnInit.config.dairyCow));
        EntitySpawnInit.registerAnimalEntitySpawn(EntityTypesInit.MOOBLOOM_REGISTRY_OBJECT, new EntitySpawnConfigHolder(SpawnPredicates.MOOBLOOM_SPAWN_BIOMES_PREDICATE, EntitySpawnInit.config.moobloom));
        EntitySpawnInit.registerAnimalEntitySpawn(EntityTypesInit.MOOLIP_REGISTRY_OBJECT, new EntitySpawnConfigHolder(SpawnPredicates.MOOLIP_SPAWN_BIOMES_PREDICATE, EntitySpawnInit.config.moolip));
        EntitySpawnInit.registerAnimalEntitySpawn(EntityTypesInit.PINTO_COW_REGISTRY_OBJECT, new EntitySpawnConfigHolder(SpawnPredicates.PINTO_COW_SPAWN_BIOMES_PREDICATE, EntitySpawnInit.config.pintoCow));
        EntitySpawnInit.registerAnimalEntitySpawn(EntityTypesInit.SUNSET_COW_REGISTRY_OBJECT, new EntitySpawnConfigHolder(SpawnPredicates.SUNSET_COW_SPAWN_BIOMES_PREDICATE, EntitySpawnInit.config.sunsetCow));
        EntitySpawnInit.registerAnimalEntitySpawn(EntityTypesInit.UMBRA_COW_REGISTRY_OBJECT, new EntitySpawnConfigHolder(SpawnPredicates.UMBRA_COW_SPAWN_BIOMES_PREDICATE, EntitySpawnInit.config.umbraCow));
        EntitySpawnInit.registerAnimalEntitySpawn(EntityTypesInit.WOOLY_COW_REGISTRY_OBJECT, new EntitySpawnConfigHolder(SpawnPredicates.WOOLY_COW_SPAWN_BIOMES_PREDICATE, EntitySpawnInit.config.woolyCow));
        EntitySpawnInit.registerAnimalEntitySpawn(EntityTypesInit.CLUCKSHROOM_REGISTRY_OBJECT, new EntitySpawnConfigHolder(SpawnPredicates.CLUCKSHROOM_SPAWN_BIOMES_PREDICATE, EntitySpawnInit.config.cluckshroom));
        EntitySpawnInit.registerAnimalEntitySpawn(EntityTypesInit.MOTTLED_PIG_REGISTRY_OBJECT, new EntitySpawnConfigHolder(SpawnPredicates.MOTTLED_PIG_SPAWN_BIOMES_PREDICATE, EntitySpawnInit.config.mottledPig));
        EntitySpawnInit.registerAnimalEntitySpawn(EntityTypesInit.MUDDY_PIG_REGISTRY_OBJECT, new EntitySpawnConfigHolder(SpawnPredicates.MUDDY_PIG_SPAWN_BIOMES_PREDICATE, EntitySpawnInit.config.muddyPig));
        EntitySpawnInit.registerAnimalEntitySpawn(EntityTypesInit.PALE_PIG_REGISTRY_OBJECT, new EntitySpawnConfigHolder(SpawnPredicates.PALE_PIG_SPAWN_BIOMES_PREDICATE, EntitySpawnInit.config.palePig));
        EntitySpawnInit.registerAnimalEntitySpawn(EntityTypesInit.PIEBALD_PIG_REGISTRY_OBJECT, new EntitySpawnConfigHolder(SpawnPredicates.PIEBALD_PIG_SPAWN_BIOMES_PREDICATE, EntitySpawnInit.config.piebaldPig));
        EntitySpawnInit.registerAnimalEntitySpawn(EntityTypesInit.PINK_FOOTED_PIG_REGISTRY_OBJECT, new EntitySpawnConfigHolder(SpawnPredicates.PINK_FOOTED_PIG_SPAWN_BIOMES_PREDICATE, EntitySpawnInit.config.pinkFootedPig));
        EntitySpawnInit.registerAnimalEntitySpawn(EntityTypesInit.SOOTY_PIG_REGISTRY_OBJECT, new EntitySpawnConfigHolder(SpawnPredicates.SOOTY_PIG_SPAWN_BIOMES_PREDICATE, EntitySpawnInit.config.sootyPig));
        EntitySpawnInit.registerAnimalEntitySpawn(EntityTypesInit.SPOTTED_PIG_REGISTRY_OBJECT, new EntitySpawnConfigHolder(SpawnPredicates.SPOTTED_PIG_SPAWN_BIOMES_PREDICATE, EntitySpawnInit.config.spottedPig));
        EntitySpawnInit.registerAnimalEntitySpawn(EntityTypesInit.BOLD_STRIPED_RABBIT_REGISTRY_OBJECT, new EntitySpawnConfigHolder(SpawnPredicates.BOLD_STRIPED_RABBIT_SPAWN_BIOMES_PREDICATE, EntitySpawnInit.config.boldStripedRabbit));
        EntitySpawnInit.registerAnimalEntitySpawn(EntityTypesInit.HARELEQUIN_RABBIT_REGISTRY_OBJECT, new EntitySpawnConfigHolder(SpawnPredicates.HARELEQUIN_RABBIT_SPAWN_BIOMES_PREDICATE, EntitySpawnInit.config.harelequinRabbit));
        EntitySpawnInit.registerAnimalEntitySpawn(EntityTypesInit.FRECKLED_RABBIT_REGISTRY_OBJECT, new EntitySpawnConfigHolder(SpawnPredicates.FRECKLED_RABBIT_SPAWN_BIOMES_PREDICATE, EntitySpawnInit.config.freckledRabbit));
        EntitySpawnInit.registerAnimalEntitySpawn(EntityTypesInit.JUMBO_RABBIT_REGISTRY_OBJECT, new EntitySpawnConfigHolder(SpawnPredicates.JUMBO_RABBIT_SPAWN_BIOMES_PREDICATE, EntitySpawnInit.config.jumboRabbit));
        EntitySpawnInit.registerAnimalEntitySpawn(EntityTypesInit.MUDDY_FOOT_RABBIT_REGISTRY_OBJECT, new EntitySpawnConfigHolder(SpawnPredicates.MUDDY_FOOT_RABBIT_SPAWN_BIOMES_PREDICATE, EntitySpawnInit.config.muddyFootRabbit));
        EntitySpawnInit.registerAnimalEntitySpawn(EntityTypesInit.VESTED_RABBIT_REGISTRY_OBJECT, new EntitySpawnConfigHolder(SpawnPredicates.VESTED_RABBIT_SPAWN_BIOMES_PREDICATE, EntitySpawnInit.config.vestedRabbit));
        EntitySpawnInit.registerAnimalEntitySpawn(EntityTypesInit.FLECKED_SHEEP_REGISTRY_OBJECT, new EntitySpawnConfigHolder(SpawnPredicates.FLECKED_SHEEP_SPAWN_BIOMES_PREDICATE, EntitySpawnInit.config.fleckedSheep));
        EntitySpawnInit.registerAnimalEntitySpawn(EntityTypesInit.PATCHED_SHEEP_REGISTRY_OBJECT, new EntitySpawnConfigHolder(SpawnPredicates.PATCHED_SHEEP_SPAWN_BIOMES_PREDICATE, EntitySpawnInit.config.patchedSheep));
        EntitySpawnInit.registerAnimalEntitySpawn(EntityTypesInit.RAINBOW_SHEEP_REGISTRY_OBJECT, new EntitySpawnConfigHolder(SpawnPredicates.RAINBOW_SHEEP_SPAWN_BIOMES_PREDICATE, EntitySpawnInit.config.rainbowSheep));
        EntitySpawnInit.registerAnimalEntitySpawn(EntityTypesInit.ROCKY_SHEEP_REGISTRY_OBJECT, new EntitySpawnConfigHolder(SpawnPredicates.ROCKY_SHEEP_SPAWN_BIOMES_PREDICATE, EntitySpawnInit.config.rockySheep));
        EntitySpawnInit.registerAnimalEntitySpawn(EntityTypesInit.FUZZY_SHEEP_REGISTRY_OBJECT, new EntitySpawnConfigHolder(SpawnPredicates.FUZZY_SHEEP_SPAWN_BIOMES_PREDICATE, EntitySpawnInit.config.fuzzySheep));
        EntitySpawnInit.registerAnimalEntitySpawn(EntityTypesInit.HORNED_SHEEP_REGISTRY_OBJECT, new EntitySpawnConfigHolder(SpawnPredicates.HORNED_SHEEP_SPAWN_BIOMES_PREDICATE, EntitySpawnInit.config.hornedSheep));
        EntitySpawnInit.registerAnimalEntitySpawn(EntityTypesInit.INKY_SHEEP_REGISTRY_OBJECT, new EntitySpawnConfigHolder(SpawnPredicates.INKY_SHEEP_SPAWN_BIOMES_PREDICATE, EntitySpawnInit.config.inkySheep));
        EntitySpawnInit.registerAnimalEntitySpawn(EntityTypesInit.LONG_NOSED_SHEEP_REGISTRY_OBJECT, new EntitySpawnConfigHolder(SpawnPredicates.LONG_NOSED_SHEEP_SPAWN_BIOMES_PREDICATE, EntitySpawnInit.config.longNosedSheep));
        EntitySpawnInit.registerAnimalEntitySpawn(EntityTypesInit.JOLLY_LLAMA_REGISTRY_OBJECT, new EntitySpawnConfigHolder(SpawnPredicates.JOLLY_LLAMA_SPAWN_BIOMES_PREDICATE, EntitySpawnInit.config.jollyLlama));
    }

    private static void manageMonsterEntities() {
        EntitySpawnInit.registerMonsterEntitySpawn(EntityTypesInit.BONE_SPIDER_REGISTRY_OBJECT, new EntitySpawnConfigHolder(SpawnPredicates.BONE_SPIDER_SPAWN_BIOMES_PREDICATE, EntitySpawnInit.config.boneSpider));
        EntitySpawnInit.registerMonsterEntitySpawn(EntityTypesInit.BOULDERING_ZOMBIE_REGISTRY_OBJECT, new EntitySpawnConfigHolder(SpawnPredicates.BOULDERING_ZOMBIE_SPAWN_BIOMES_PREDICATE, EntitySpawnInit.config.boulderingZombie));
        EntitySpawnInit.registerMonsterEntitySpawn(EntityTypesInit.LOBBER_ZOMBIE_REGISTRY_OBJECT, new EntitySpawnConfigHolder(SpawnPredicates.LOBBER_ZOMBIE_SPAWN_BIOMES_PREDICATE, EntitySpawnInit.config.lobberZombie));
        EntitySpawnInit.registerMonsterEntitySpawn(EntityTypesInit.SKELETON_WOLF_REGISTRY_OBJECT, new EntitySpawnConfigHolder(SpawnPredicates.SKELETON_WOLF_SPAWN_BIOMES_PREDICATE, EntitySpawnInit.config.skeletonWolf));
        EntitySpawnInit.registerMonsterEntitySpawn(EntityTypesInit.TROPICAL_SLIME_REGISTRY_OBJECT, new EntitySpawnConfigHolder(SpawnPredicates.TROPICAL_SLIME_SPAWN_BIOMES_PREDICATE, EntitySpawnInit.config.tropicalSlime));
        EntitySpawnInit.registerMonsterEntitySpawn(EntityTypesInit.VILER_WITCH_REGISTRY_OBJECT, new EntitySpawnConfigHolder(SpawnPredicates.VILER_WITCH_SPAWN_BIOMES_PREDICATE, EntitySpawnInit.config.vilerWitch));
    }

    private static <T extends Animal> void registerAnimalEntitySpawn(RegistrySupplier<EntityType<T>> entity, EntitySpawnConfigHolder configHolder) {
        if (configHolder.canSpawn()) {
            EntitySpawnInit.setCreatureSpawnBiomes(entity, configHolder.predicate(), configHolder.weight(), configHolder.groupMin(), configHolder.groupMax());
        }
    }

    private static <T extends Monster> void registerMonsterEntitySpawn(RegistrySupplier<EntityType<T>> entity, EntitySpawnConfigHolder configHolder) {
        if (configHolder.canSpawn()) {
            EntitySpawnInit.setMonsterSpawnBiomes(entity, configHolder.predicate(), configHolder.weight(), configHolder.groupMin(), configHolder.groupMax());
        }
    }

    private static <T extends Entity> void addEntityToBiomes(RegistrySupplier<EntityType<T>> entity, Predicate<BiomeModifications.BiomeContext> predicate, int weight, int minGroupSize, int maxGroupSize, MobCategory classification) {
        BiomeModifications.addProperties(predicate, (biomeContext, mutable) -> {
            MobSpawnSettings.SpawnerData spawnEntry = new MobSpawnSettings.SpawnerData((EntityType)entity.get(), weight, minGroupSize, maxGroupSize);
            mutable.getSpawnProperties().addSpawn(classification, spawnEntry);
        });
    }

    private static <T extends Animal> void setCreatureSpawnBiomes(RegistrySupplier<EntityType<T>> entity, Predicate<BiomeModifications.BiomeContext> predicate, int weight, int minGroupCountIn, int maxGroupCountIn) {
        EntitySpawnInit.addEntityToBiomes(entity, predicate, weight, minGroupCountIn, maxGroupCountIn, MobCategory.CREATURE);
    }

    private static <T extends Monster> void setMonsterSpawnBiomes(RegistrySupplier<EntityType<T>> entity, Predicate<BiomeModifications.BiomeContext> predicate, int weight, int minGroupCountIn, int maxGroupCountIn) {
        EntitySpawnInit.addEntityToBiomes(entity, predicate, weight, minGroupCountIn, maxGroupCountIn, MobCategory.MONSTER);
    }
}

