/*
 * Decompiled with CFR 0.152.
 */
package slexom.earthtojava.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Utils {
    private Utils() {
        throw new IllegalStateException("Utility class");
    }

    public static List<String> breakItemTooltip(String input) {
        String currentLocale;
        List<String> cjkLocales = Arrays.asList("ja_jp", "ko_kr", "zh_cn", "zh_tw");
        if (cjkLocales.contains(currentLocale = Minecraft.m_91087_().m_91102_().m_264236_())) {
            return Utils.breakLine(input, 30);
        }
        return Utils.breakLine(input, 40);
    }

    public static List<String> breakLine(String input, int maxLineLength) {
        ArrayList<String> res = new ArrayList<String>();
        Pattern pattern = Pattern.compile("\\b.{1," + (maxLineLength - 1) + "}\\b\\W?", 256);
        Matcher matcher = pattern.matcher(input);
        while (matcher.find()) {
            res.add(matcher.group());
        }
        return res;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void appendE2JTooltip(String translationKey, List<Component> tooltip) {
        if (!I18n.m_118936_((String)translationKey)) {
            return;
        }
        MutableComponent description = Component.m_237115_((String)translationKey);
        List<String> strings = Utils.breakItemTooltip(description.getString());
        strings.forEach(string -> tooltip.add((Component)Component.m_237115_((String)string).m_130940_(ChatFormatting.GRAY)));
    }

    public static ResourceLocation modIdentifierOf(String registryName) {
        return new ResourceLocation("earthtojavamobs", registryName);
    }
}

