/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.sodiumextra.client.gui;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class SodiumExtraGameOptions {
    public final AnimationSettings animationSettings = new AnimationSettings();
    public final ParticleSettings particleSettings = new ParticleSettings();
    public final DetailSettings detailSettings = new DetailSettings();
    public final RenderSettings renderSettings = new RenderSettings();
    public final ExtraSettings extraSettings = new ExtraSettings();
    private File file;
    private static final Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().excludeFieldsWithModifiers(new int[]{2}).create();

    public static SodiumExtraGameOptions load(File file) {
        SodiumExtraGameOptions config;
        block8: {
            if (file.exists()) {
                try (FileReader reader = new FileReader(file);){
                    config = (SodiumExtraGameOptions)gson.fromJson((Reader)reader, SodiumExtraGameOptions.class);
                    break block8;
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not parse config", e);
                }
            }
            config = new SodiumExtraGameOptions();
        }
        config.file = file;
        config.writeChanges();
        return config;
    }

    public void writeChanges() {
        File dir = this.file.getParentFile();
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                throw new RuntimeException("Could not create parent directories");
            }
        } else if (!dir.isDirectory()) {
            throw new RuntimeException("The parent file is not a directory");
        }
        try (FileWriter writer = new FileWriter(this.file);){
            gson.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not save configuration file", e);
        }
    }

    public static class AnimationSettings {
        public boolean animation = true;
        public boolean animateWater = true;
        public boolean animateLava = true;
        public boolean animateFire = true;
        public boolean animatePortal = true;
        public boolean blockAnimations = true;
    }

    public static class ParticleSettings {
        public boolean particles = true;
        public boolean rainSplash = true;
        public boolean explosion = true;
        public boolean water = true;
        public boolean smoke = true;
        public boolean potion = true;
        public boolean portal = true;
        public boolean redstone = true;
        public boolean drip = true;
        public boolean firework = true;
        public boolean bubble = true;
        public boolean environment = true;
        public boolean villagers = true;
        public boolean composter = true;
    }

    public static class DetailSettings {
        public boolean rainSnow = true;
        public boolean biomeColors = true;
        public boolean skyColors = true;
    }

    public static class RenderSettings {
        public int fogDistance = 0;
        public boolean lightUpdates = true;
        public boolean itemFrame = true;
        public boolean armorStand = true;
        public boolean painting = true;
        public boolean piston = true;
    }

    public static class ExtraSettings {
        public boolean showFps = false;
        public boolean showCoords = false;
        public boolean reduceResolutionOnMac = true;
        public int cloudHeight = 128;
        public boolean toasts = true;
        public boolean instantSneak = false;
        public boolean preventShaders = false;
        public boolean useFastRandom = true;
    }
}

