/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.polymorph.common.capability;

import com.illusivesoulworks.polymorph.api.PolymorphApi;
import com.illusivesoulworks.polymorph.api.common.base.IRecipePair;
import com.illusivesoulworks.polymorph.common.capability.AbstractBlockEntityRecipeData;
import com.mojang.datafixers.util.Pair;
import java.util.SortedSet;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.block.entity.BlockEntity;

public abstract class AbstractHighlightedRecipeData<E extends BlockEntity>
extends AbstractBlockEntityRecipeData<E> {
    public AbstractHighlightedRecipeData(E owner) {
        super(owner);
    }

    @Override
    public void selectRecipe(@Nonnull RecipeHolder<?> recipe) {
        super.selectRecipe(recipe);
        for (ServerPlayer listeningPlayer : this.getListeners()) {
            PolymorphApi.common().getPacketDistributor().sendHighlightRecipeS2C(listeningPlayer, recipe.id());
        }
    }

    @Override
    public Pair<SortedSet<IRecipePair>, ResourceLocation> getPacketData() {
        SortedSet<IRecipePair> recipesList = this.getRecipesList();
        ResourceLocation selected = null;
        if (!recipesList.isEmpty()) {
            selected = this.getSelectedRecipe().map(RecipeHolder::id).orElse(recipesList.first().getResourceLocation());
        }
        return new Pair(recipesList, selected);
    }
}

