/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.polymorph.common.capability;

import com.illusivesoulworks.polymorph.PolymorphConstants;
import com.illusivesoulworks.polymorph.api.PolymorphApi;
import com.illusivesoulworks.polymorph.api.common.base.IRecipePair;
import com.illusivesoulworks.polymorph.api.common.capability.IRecipeData;
import com.illusivesoulworks.polymorph.common.capability.AbstractBlockEntityRecipeData;
import com.illusivesoulworks.polymorph.common.impl.RecipePair;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public abstract class AbstractRecipeData<E>
implements IRecipeData<E> {
    private final SortedSet<IRecipePair> recipesList = new TreeSet<IRecipePair>();
    private final E owner;
    private RecipeHolder<?> lastRecipe;
    private RecipeHolder<?> selectedRecipe;
    private ResourceLocation loadedRecipe;
    private boolean isFailing;
    private NonNullList<Item> input;

    public AbstractRecipeData(E owner) {
        this.owner = owner;
        this.input = NonNullList.create();
    }

    @Override
    public <T extends Recipe<C>, C extends Container> Optional<RecipeHolder<T>> getRecipe(RecipeType<T> type, C inventory, Level level, List<RecipeHolder<T>> recipesList) {
        List recipes;
        boolean isEmpty = this.isEmpty(inventory);
        this.getLoadedRecipe().flatMap(id -> level.getRecipeManager().byKey(id)).ifPresent(selected -> {
            try {
                if (selected.value().getType() == type && (selected.value().matches(inventory, level) || isEmpty)) {
                    this.setSelectedRecipe((RecipeHolder<?>)selected);
                }
            }
            catch (ClassCastException e) {
                PolymorphConstants.LOG.error("Recipe {} does not match inventory {}", (Object)selected.id(), (Object)inventory);
            }
            this.loadedRecipe = null;
        });
        if (isEmpty) {
            this.setFailing(false);
            this.sendRecipesListToListeners(true);
            return Optional.empty();
        }
        AtomicReference<Object> ref = new AtomicReference<Object>(null);
        this.getLastRecipe().ifPresent(recipe -> {
            try {
                if (recipe.value().getType() == type && recipe.value().matches(inventory, level)) {
                    this.getSelectedRecipe().ifPresent(selected -> {
                        try {
                            if (selected.value().getType() == type && selected.value().matches(inventory, level)) {
                                ref.set(selected);
                            }
                        }
                        catch (ClassCastException e) {
                            PolymorphConstants.LOG.error("Recipe {} does not match inventory {}", (Object)selected.id(), (Object)inventory);
                        }
                    });
                }
            }
            catch (ClassCastException e) {
                PolymorphConstants.LOG.error("Recipe {} does not match inventory {}", (Object)recipe.id(), (Object)inventory);
            }
        });
        RecipeHolder result = ref.get();
        if (result != null && !(this instanceof AbstractBlockEntityRecipeData)) {
            boolean inputChanged = false;
            int size = inventory.getContainerSize();
            NonNullList currentInput = NonNullList.withSize((int)size, (Object)Items.AIR);
            if (size != this.input.size()) {
                inputChanged = true;
            }
            for (int i = 0; i < size; ++i) {
                ItemStack stack = inventory.getItem(i);
                Item item = stack.getItem();
                if (!inputChanged && i < this.input.size() && item != this.input.get(i)) {
                    inputChanged = true;
                }
                if (stack.isEmpty()) continue;
                currentInput.set(i, (Object)item);
            }
            this.input = currentInput;
            if (!inputChanged) {
                this.setFailing(false);
                this.sendRecipesListToListeners(false);
                return Optional.of(result);
            }
        }
        TreeSet<IRecipePair> newDataset = new TreeSet<IRecipePair>();
        List list = recipes = recipesList.isEmpty() ? level.getRecipeManager().getRecipesFor(type, inventory, level) : recipesList;
        if (recipes.isEmpty()) {
            this.setFailing(true);
            this.sendRecipesListToListeners(true);
            return Optional.empty();
        }
        ArrayList<RecipeHolder> validRecipes = new ArrayList<RecipeHolder>();
        for (RecipeHolder entry : recipes) {
            ItemStack output;
            ResourceLocation id2 = entry.id();
            if (ref.get() == null && this.getSelectedRecipe().map(recipe -> recipe.id().equals((Object)id2)).orElse(false).booleanValue()) {
                ref.set(entry);
            }
            if ((output = entry.value().getResultItem((HolderLookup.Provider)level.registryAccess())) == null || output.isEmpty() || entry.value() instanceof CustomRecipe) {
                output = entry.value().assemble(inventory, (HolderLookup.Provider)level.registryAccess());
            }
            if (output.isEmpty()) continue;
            newDataset.add(new RecipePair(id2, output));
            validRecipes.add(entry);
        }
        if (validRecipes.isEmpty()) {
            this.setFailing(true);
            this.sendRecipesListToListeners(true);
            return Optional.empty();
        }
        this.setRecipesList(newDataset);
        result = ref.get();
        if (result == null) {
            ResourceLocation rl = ((IRecipePair)newDataset.first()).getResourceLocation();
            for (RecipeHolder recipe2 : validRecipes) {
                if (!recipe2.id().equals((Object)rl)) continue;
                result = recipe2;
                break;
            }
        }
        if (result == null) {
            this.setFailing(true);
            this.sendRecipesListToListeners(true);
            return Optional.empty();
        }
        this.lastRecipe = result;
        this.setSelectedRecipe(result);
        this.setFailing(false);
        this.sendRecipesListToListeners(false);
        return Optional.of(result);
    }

    @Override
    public Optional<RecipeHolder<?>> getSelectedRecipe() {
        return Optional.ofNullable(this.selectedRecipe);
    }

    @Override
    public void setSelectedRecipe(@Nonnull RecipeHolder<?> recipe) {
        this.selectedRecipe = recipe;
    }

    public Optional<RecipeHolder<?>> getLastRecipe() {
        return Optional.ofNullable(this.lastRecipe);
    }

    public Optional<ResourceLocation> getLoadedRecipe() {
        return Optional.ofNullable(this.loadedRecipe);
    }

    @Override
    @Nonnull
    public SortedSet<IRecipePair> getRecipesList() {
        return this.recipesList;
    }

    @Override
    public void setRecipesList(@Nonnull SortedSet<IRecipePair> recipesList) {
        this.recipesList.clear();
        this.recipesList.addAll(recipesList);
    }

    @Override
    public boolean isEmpty(Container inventory) {
        if (inventory != null) {
            for (int i = 0; i < inventory.getContainerSize(); ++i) {
                if (inventory.getItem(i).isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public E getOwner() {
        return this.owner;
    }

    @Override
    public void selectRecipe(@Nonnull RecipeHolder<?> recipe) {
        this.setSelectedRecipe(recipe);
    }

    @Override
    public abstract Set<ServerPlayer> getListeners();

    @Override
    public void sendRecipesListToListeners(boolean isEmpty) {
        Pair packetData = isEmpty ? new Pair(new TreeSet(), null) : this.getPacketData();
        for (ServerPlayer listener : this.getListeners()) {
            PolymorphApi.common().getPacketDistributor().sendRecipesListS2C(listener, (SortedSet)packetData.getFirst(), (ResourceLocation)packetData.getSecond());
        }
    }

    @Override
    public Pair<SortedSet<IRecipePair>, ResourceLocation> getPacketData() {
        return new Pair(this.getRecipesList(), null);
    }

    @Override
    public boolean isFailing() {
        return this.isFailing;
    }

    @Override
    public void setFailing(boolean isFailing) {
        this.isFailing = isFailing;
    }

    @Override
    public void readNBT(HolderLookup.Provider provider, CompoundTag compoundTag) {
        if (compoundTag.contains("SelectedRecipe")) {
            this.loadedRecipe = new ResourceLocation(compoundTag.getString("SelectedRecipe"));
        }
        if (compoundTag.contains("RecipeDataSet")) {
            SortedSet<IRecipePair> dataset = this.getRecipesList();
            dataset.clear();
            ListTag list = compoundTag.getList("RecipeDataSet", 10);
            for (Tag inbt : list) {
                CompoundTag tag = (CompoundTag)inbt;
                ResourceLocation id = ResourceLocation.tryParse((String)tag.getString("Id"));
                ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag.getCompound("ItemStack"));
                dataset.add(new RecipePair(id, stack));
            }
        }
    }

    @Override
    @Nonnull
    public CompoundTag writeNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        this.getSelectedRecipe().ifPresent(selected -> nbt.putString("SelectedRecipe", this.selectedRecipe.id().toString()));
        SortedSet<IRecipePair> dataset = this.getRecipesList();
        if (!dataset.isEmpty()) {
            ListTag list = new ListTag();
            for (IRecipePair data : dataset) {
                CompoundTag tag = new CompoundTag();
                tag.put("ItemStack", data.getOutput().save(provider, (Tag)new CompoundTag()));
                tag.putString("Id", data.getResourceLocation().toString());
                list.add((Object)tag);
            }
            nbt.put("RecipeDataSet", (Tag)list);
        }
        return nbt;
    }
}

