/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.polymorph.common.capability;

import com.illusivesoulworks.polymorph.api.PolymorphApi;
import com.illusivesoulworks.polymorph.api.common.capability.IPlayerRecipeData;
import com.illusivesoulworks.polymorph.client.recipe.RecipesWidget;
import com.illusivesoulworks.polymorph.common.capability.AbstractRecipeData;
import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class PlayerRecipeData
extends AbstractRecipeData<Player>
implements IPlayerRecipeData {
    private AbstractContainerMenu containerMenu;
    private RecipeHolder<?> cachedSelection;
    private int lastAccessTick;

    public PlayerRecipeData(Player owner) {
        super(owner);
    }

    @Override
    public <T extends Recipe<C>, C extends Container> Optional<RecipeHolder<T>> getRecipe(RecipeType<T> type, C inventory, Level level, List<RecipeHolder<T>> recipesList) {
        if (((Player)this.getOwner()).tickCount == this.lastAccessTick) {
            if (this.cachedSelection != null) {
                this.setSelectedRecipe(this.cachedSelection);
            }
        } else {
            this.cachedSelection = null;
        }
        Optional<RecipeHolder<Object>> maybeRecipe = super.getRecipe(type, inventory, level, recipesList);
        if (this.getContainerMenu() == ((Player)this.getOwner()).containerMenu) {
            this.syncPlayerRecipeData();
        }
        this.setContainerMenu(null);
        if (((Player)this.getOwner()).tickCount != this.lastAccessTick) {
            this.lastAccessTick = ((Player)this.getOwner()).tickCount;
            this.cachedSelection = maybeRecipe.orElse(null);
        }
        return maybeRecipe;
    }

    @Override
    public void selectRecipe(@Nonnull RecipeHolder<?> recipe) {
        super.selectRecipe(recipe);
        this.syncPlayerRecipeData();
    }

    private void syncPlayerRecipeData() {
        if (this.getOwner() instanceof ServerPlayer) {
            PolymorphApi.common().getPacketDistributor().sendPlayerSyncS2C((ServerPlayer)this.getOwner(), this.getRecipesList(), this.getSelectedRecipe().map(RecipeHolder::id).orElse(null));
        }
    }

    @Override
    public void sendRecipesListToListeners(boolean isEmpty) {
        if (this.getContainerMenu() == ((Player)this.getOwner()).containerMenu) {
            Pair packetData = isEmpty ? new Pair(new TreeSet(), null) : this.getPacketData();
            Player player = (Player)this.getOwner();
            if (player.level().isClientSide()) {
                RecipesWidget.get().ifPresent(widget -> widget.setRecipesList((Set)packetData.getFirst(), (ResourceLocation)packetData.getSecond()));
            } else if (player instanceof ServerPlayer) {
                PolymorphApi.common().getPacketDistributor().sendRecipesListS2C((ServerPlayer)player, (SortedSet)packetData.getFirst(), (ResourceLocation)packetData.getSecond());
            }
        }
    }

    @Override
    public Set<ServerPlayer> getListeners() {
        Player player = (Player)this.getOwner();
        if (player instanceof ServerPlayer) {
            return Collections.singleton((ServerPlayer)player);
        }
        return new HashSet<ServerPlayer>();
    }

    @Override
    public void setContainerMenu(AbstractContainerMenu containerMenu) {
        this.containerMenu = containerMenu;
    }

    @Override
    public AbstractContainerMenu getContainerMenu() {
        return this.containerMenu;
    }
}

