/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.polymorph.common.network.client;

import com.illusivesoulworks.polymorph.api.PolymorphApi;
import com.illusivesoulworks.polymorph.common.integration.PolymorphIntegrations;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public record CPacketPersistentRecipeSelection(ResourceLocation recipe) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CPacketPersistentRecipeSelection> TYPE = new CustomPacketPayload.Type(new ResourceLocation("polymorph", "persistent_recipe_selection"));
    public static final StreamCodec<FriendlyByteBuf, CPacketPersistentRecipeSelection> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, CPacketPersistentRecipeSelection::recipe, CPacketPersistentRecipeSelection::new);

    public static void handle(CPacketPersistentRecipeSelection packet, ServerPlayer player) {
        Level world = player.getCommandSenderWorld();
        Optional maybeRecipe = world.getRecipeManager().byKey(packet.recipe);
        maybeRecipe.ifPresent(recipe -> {
            AbstractContainerMenu container = player.containerMenu;
            PolymorphApi.common().getRecipeDataFromBlockEntity(container).ifPresent(recipeData -> {
                recipeData.selectRecipe((RecipeHolder<?>)recipe);
                PolymorphIntegrations.selectRecipe((BlockEntity)recipeData.getOwner(), container, recipe);
            });
        });
    }

    @Nonnull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

