/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.polymorph.platform;

import com.illusivesoulworks.polymorph.api.common.base.IPolymorphPacketDistributor;
import com.illusivesoulworks.polymorph.api.common.capability.IBlockEntityRecipeData;
import com.illusivesoulworks.polymorph.api.common.capability.IPlayerRecipeData;
import com.illusivesoulworks.polymorph.common.PolymorphNeoForgeCapabilities;
import com.illusivesoulworks.polymorph.common.network.PolymorphNeoForgePacketDistributor;
import com.illusivesoulworks.polymorph.platform.services.IPlatform;
import java.nio.file.Path;
import java.util.Optional;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.crafting.IShapedRecipe;

public class NeoForgePlatform
implements IPlatform {
    private static final IPolymorphPacketDistributor PACKET_DISTRIBUTOR = new PolymorphNeoForgePacketDistributor();

    @Override
    public Path getGameDir() {
        return FMLPaths.GAMEDIR.get();
    }

    @Override
    public Path getConfigDir() {
        return FMLPaths.CONFIGDIR.get();
    }

    @Override
    public boolean isModLoaded(String id) {
        return ModList.get().isLoaded(id);
    }

    @Override
    public boolean isModFileLoaded(String id) {
        return FMLLoader.getLoadingModList().getModFileById(id) != null;
    }

    @Override
    public boolean isShaped(Recipe<?> recipe) {
        return recipe instanceof IShapedRecipe;
    }

    @Override
    public boolean isSameShape(Recipe<?> recipe1, Recipe<?> recipe2) {
        if (this.isShaped(recipe1) && this.isShaped(recipe2)) {
            IShapedRecipe shaped = (IShapedRecipe)recipe1;
            IShapedRecipe otherShaped = (IShapedRecipe)recipe2;
            return shaped.getHeight() == otherShaped.getHeight() && shaped.getWidth() == otherShaped.getWidth();
        }
        return true;
    }

    @Override
    public Optional<? extends IPlayerRecipeData> getRecipeData(Player player) {
        return Optional.ofNullable((IPlayerRecipeData)((PolymorphNeoForgeCapabilities.RecipeDataAttachment)player.getData(PolymorphNeoForgeCapabilities.RECIPE_DATA.get())).getRecipeData());
    }

    @Override
    public Optional<? extends IBlockEntityRecipeData> getRecipeData(BlockEntity blockEntity) {
        return Optional.ofNullable((IBlockEntityRecipeData)((PolymorphNeoForgeCapabilities.RecipeDataAttachment)blockEntity.getData(PolymorphNeoForgeCapabilities.RECIPE_DATA.get())).getRecipeData());
    }

    @Override
    public IPolymorphPacketDistributor getPacketDistributor() {
        return PACKET_DISTRIBUTOR;
    }
}

