/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.polymorph.server;

import com.illusivesoulworks.polymorph.PolymorphConstants;
import com.illusivesoulworks.polymorph.platform.Services;
import com.illusivesoulworks.polymorph.server.wrapper.CraftingRecipeWrapper;
import com.illusivesoulworks.polymorph.server.wrapper.RecipeWrapper;
import com.illusivesoulworks.polymorph.server.wrapper.SmithingRecipeWrapper;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;

public class PolymorphCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        int opPermissionLevel = 2;
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.literal((String)"polymorph").requires(player -> player.hasPermission(2));
        command.then(Commands.literal((String)"conflicts").executes(context -> PolymorphCommands.findConflicts((CommandSourceStack)context.getSource())));
        dispatcher.register(command);
    }

    private static int findConflicts(CommandSourceStack source) {
        CompletableFuture.runAsync(() -> {
            source.sendSuccess(() -> Component.translatable((String)"commands.polymorph.conflicts.starting"), true);
            ServerLevel world = source.getLevel();
            RecipeManager recipeManager = world.getRecipeManager();
            ArrayList<String> output = new ArrayList<String>();
            int count = 0;
            count += PolymorphCommands.scanRecipes(RecipeType.CRAFTING, output, recipeManager, CraftingRecipeWrapper::new);
            count += PolymorphCommands.scanRecipes(RecipeType.SMELTING, output, recipeManager, RecipeWrapper::new);
            count += PolymorphCommands.scanRecipes(RecipeType.BLASTING, output, recipeManager, RecipeWrapper::new);
            count += PolymorphCommands.scanRecipes(RecipeType.SMOKING, output, recipeManager, RecipeWrapper::new);
            if ((count += PolymorphCommands.scanRecipes(RecipeType.SMITHING, output, recipeManager, SmithingRecipeWrapper::new)) > 0) {
                try {
                    Files.write(Paths.get(String.valueOf(Services.PLATFORM.getGameDir()) + "/logs/conflicts.log", new String[0]), output, StandardCharsets.UTF_8, new OpenOption[0]);
                }
                catch (IOException e) {
                    PolymorphConstants.LOG.error("Whoops! Something went wrong writing down your conflicts :(");
                    e.printStackTrace();
                }
            }
            int finalCount = count;
            source.sendSuccess(() -> Component.translatable((String)"commands.polymorph.conflicts.success", (Object[])new Object[]{finalCount}), true);
        });
        return 1;
    }

    private static <C extends Container, T extends Recipe<C>> int scanRecipes(RecipeType<T> pType, List<String> pOutput, RecipeManager pRecipeManager, Function<RecipeHolder<?>, RecipeWrapper> pFactory) {
        List<RecipeWrapper> recipes = pRecipeManager.getAllRecipesFor(pType).stream().map(pFactory).toList();
        ArrayList conflicts = new ArrayList();
        TreeSet<ResourceLocation> skipped = new TreeSet<ResourceLocation>();
        HashSet<ResourceLocation> processed = new HashSet<ResourceLocation>();
        for (RecipeWrapper recipe : recipes) {
            ResourceLocation resourceLocation = recipe.getId();
            if (processed.contains(resourceLocation)) continue;
            processed.add(resourceLocation);
            if (recipe.getRecipe() instanceof CustomRecipe) {
                skipped.add(resourceLocation);
                continue;
            }
            TreeSet<ResourceLocation> currentGroup = new TreeSet<ResourceLocation>();
            for (RecipeWrapper otherRecipe : recipes) {
                if (processed.contains(otherRecipe.getId()) || !otherRecipe.conflicts(recipe)) continue;
                currentGroup.add(resourceLocation);
                currentGroup.add(otherRecipe.getId());
                processed.add(otherRecipe.getId());
            }
            if (currentGroup.isEmpty()) continue;
            conflicts.add(currentGroup);
        }
        pOutput.add("===================================================================");
        pOutput.add(String.valueOf(BuiltInRegistries.RECIPE_TYPE.getKey(pType)) + " recipe conflicts (" + conflicts.size() + ")");
        pOutput.add("===================================================================");
        pOutput.add("");
        int count = 1;
        for (Set set : conflicts) {
            StringJoiner joiner = new StringJoiner(", ");
            set.stream().map(ResourceLocation::toString).forEach(joiner::add);
            pOutput.add(count + ": " + String.valueOf(joiner));
            pOutput.add("");
            ++count;
        }
        if (!skipped.isEmpty()) {
            pOutput.add("Skipped special recipes: ");
            for (ResourceLocation resourceLocation : skipped) {
                pOutput.add(resourceLocation.toString());
            }
            pOutput.add("");
        }
        return conflicts.size();
    }
}

