/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.api;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1703;
import net.minecraft.class_1714;
import net.minecraft.class_1723;
import top.theillusivec4.polymorph.api.PolyProvider;

public class PolymorphApi {
    private static final Map<Class<? extends class_1703>, Function<? extends class_1703, PolyProvider>> providerFunctions = new HashMap<Class<? extends class_1703>, Function<? extends class_1703, PolyProvider>>();

    public static <T extends class_1703> void addProvider(Class<T> clazz, Function<T, PolyProvider> providerFunction) {
        providerFunctions.put(clazz, providerFunction);
    }

    public static <T extends class_1703> Optional<PolyProvider> getProvider(T screenHandler) {
        Function<? extends class_1703, PolyProvider> providerFunction = providerFunctions.get(screenHandler.getClass());
        if (providerFunction == null) {
            if (screenHandler instanceof class_1714) {
                providerFunction = providerFunctions.get(class_1714.class);
            } else if (screenHandler instanceof class_1723) {
                providerFunction = providerFunctions.get(class_1723.class);
            }
        }
        return providerFunction != null ? Optional.of(providerFunction.apply(screenHandler)) : Optional.empty();
    }
}

