/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.core.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1715;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_299;
import net.minecraft.class_310;
import net.minecraft.class_344;
import net.minecraft.class_3675;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_507;
import net.minecraft.class_518;
import net.minecraft.class_638;
import net.minecraft.class_746;
import top.theillusivec4.polymorph.api.PolyProvider;
import top.theillusivec4.polymorph.core.Polymorph;
import top.theillusivec4.polymorph.core.client.RecipeOutputWrapper;
import top.theillusivec4.polymorph.core.client.gui.RecipeSelectionGui;
import top.theillusivec4.polymorph.core.client.gui.ToggleRecipeButton;

public class RecipeSelectionManager {
    private static final class_2960 TOGGLE = new class_2960("polymorph", "textures/gui/toggle.png");
    private static RecipeSelectionManager instance;
    private static class_1799 preferredStack;
    private RecipeSelectionGui recipeSelectionGui;
    private class_344 toggleButton;
    private class_1715 craftingInventory;
    private class_1860<class_1715> lastPlacedRecipe;
    private List<class_3955> lastRecipesList;
    private class_1860<class_1715> lastSelectedRecipe;
    private boolean needsUpdate;
    private boolean canUpdate = true;
    private boolean needsPositionUpdate;
    private class_465<?> parent;
    private PolyProvider provider;
    private static final int GLFW_LEFT_SHIFT = 340;
    private static final int GLFW_RIGHT_SHIFT = 344;

    public static Optional<RecipeSelectionManager> getInstance() {
        return Optional.ofNullable(instance);
    }

    public static RecipeSelectionManager createInstance(class_465<?> screen, PolyProvider provider) {
        instance = new RecipeSelectionManager(screen, provider);
        return instance;
    }

    public static void clearInstance() {
        instance = null;
    }

    public static class_1799 getPreferredStack() {
        return preferredStack;
    }

    public static void setPreferredStack(class_1799 stack) {
        preferredStack = stack.method_7972();
    }

    public static void updateManager() {
        RecipeSelectionManager.getInstance().ifPresent(manager -> {
            if (manager.canUpdate) {
                manager.markUpdate();
            }
        });
    }

    public RecipeSelectionManager(class_465<?> screen, PolyProvider provider) {
        this.parent = screen;
        this.provider = provider;
        int x = screen.field_22789 / 2 + provider.getXOffset();
        int y = screen.field_22790 / 2 + provider.getYOffset();
        this.craftingInventory = provider.getCraftingInventory();
        this.recipeSelectionGui = new RecipeSelectionGui(x - 4, y - 32, Objects.requireNonNull(this.craftingInventory), this::selectRecipe);
        this.toggleButton = new ToggleRecipeButton(x, y, 16, 16, 0, 0, 17, TOGGLE, clickWidget -> this.recipeSelectionGui.setVisible(!this.recipeSelectionGui.isVisible()));
        this.toggleButton.field_22764 = this.recipeSelectionGui.getButtons().size() > 1;
    }

    public Optional<List<class_3955>> getLastRecipesList() {
        return Optional.ofNullable(this.lastRecipesList);
    }

    public void setLastRecipesList(List<class_3955> recipesList) {
        this.lastRecipesList = recipesList;
    }

    public Optional<class_1860<class_1715>> getLastPlacedRecipe() {
        return Optional.ofNullable(this.lastPlacedRecipe);
    }

    public void setLastPlacedRecipe(class_1860<class_1715> recipe) {
        this.lastPlacedRecipe = recipe;
    }

    public Optional<class_1860<class_1715>> getLastSelectedRecipe() {
        return Optional.ofNullable(this.lastSelectedRecipe);
    }

    public void setLastSelectedRecipe(class_1860<class_1715> recipe) {
        this.lastSelectedRecipe = recipe;
    }

    public void tick() {
        if (this.needsPositionUpdate) {
            this.needsPositionUpdate = false;
            int x = this.parent.field_22789 / 2 + this.provider.getXOffset();
            int y = this.parent.field_22790 / 2 + this.provider.getYOffset();
            if (this.parent instanceof class_518) {
                class_518 recipeShownListener = (class_518)this.parent;
                class_507 recipeBookGui = recipeShownListener.method_2659();
                class_299 recipeBook = Polymorph.getClientLoader().getClientAccessor().getRecipeBook(recipeBookGui);
                if (recipeBook != null && recipeBookGui.method_2605()) {
                    x += 77;
                }
            }
            this.recipeSelectionGui.setPosition(x - 4, y - 32);
            this.toggleButton.method_1893(x, y);
        }
        if (this.needsUpdate) {
            class_638 world = class_310.method_1551().field_1687;
            this.needsUpdate = false;
            if (world != null) {
                List<class_3955> recipesList = this.refreshRecipes((class_1937)world);
                if (!preferredStack.method_7960()) {
                    for (class_3955 craftingRecipe : recipesList) {
                        if (craftingRecipe.method_8116((class_1263)this.craftingInventory).method_7909() != preferredStack.method_7909()) continue;
                        this.setLastSelectedRecipe((class_1860<class_1715>)craftingRecipe);
                        break;
                    }
                    preferredStack = class_1799.field_8037;
                }
                if (recipesList.size() <= 1) {
                    return;
                }
                this.getLastSelectedRecipe().ifPresent(recipe -> {
                    if (recipe.method_8115((class_1263)this.craftingInventory, (class_1937)world)) {
                        class_746 playerEntity = class_310.method_1551().field_1724;
                        this.lockUpdates();
                        if (playerEntity != null) {
                            Polymorph.getLoader().getPacketVendor().sendSetRecipe(recipe.method_8114().toString());
                        }
                    }
                });
            }
        }
    }

    public List<class_3955> refreshRecipes(class_1937 world) {
        List recipesList = this.getLastPlacedRecipe().map(recipe -> {
            if (recipe.method_8115((class_1263)this.craftingInventory, world)) {
                return this.getLastRecipesList().orElse(new ArrayList());
            }
            return null;
        }).orElseGet(() -> this.fetchRecipes(this.craftingInventory, world));
        this.recipeSelectionGui.setRecipes(recipesList);
        this.toggleButton.field_22764 = recipesList.size() > 1;
        return recipesList;
    }

    private List<class_3955> fetchRecipes(class_1715 craftingInventory, class_1937 world) {
        List<Object> recipes = new ArrayList<class_3955>();
        boolean isCraftingEmpty = true;
        for (int i = 0; i < craftingInventory.method_5439(); ++i) {
            if (craftingInventory.method_5438(i).method_7960()) continue;
            isCraftingEmpty = false;
            break;
        }
        if (!isCraftingEmpty) {
            HashSet recipeOutputs = new HashSet();
            try {
                recipes = world.method_8433().method_17877(class_3956.field_17545, (class_1263)craftingInventory, world);
            }
            catch (Exception e) {
                ArrayList<String> stacks = new ArrayList<String>();
                for (int i = 0; i < craftingInventory.method_5439(); ++i) {
                    stacks.add(craftingInventory.method_5438(i).toString());
                }
                Polymorph.LOGGER.error("Attempted to craft using " + Arrays.toString(stacks.toArray()) + " but an error occurred while fetching recipes!", (Throwable)e);
            }
            recipes.removeIf(rec -> !recipeOutputs.add(new RecipeOutputWrapper(rec.method_8116((class_1263)craftingInventory))));
            if (!recipes.isEmpty()) {
                class_3955 defaultRecipe = (class_3955)recipes.get(0);
                this.setLastSelectedRecipe((class_1860<class_1715>)defaultRecipe);
                this.setLastPlacedRecipe((class_1860<class_1715>)defaultRecipe);
                this.setLastRecipesList(recipes);
            }
        }
        return recipes;
    }

    public void render(class_4587 matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.recipeSelectionGui.method_25394(matrixStack, mouseX, mouseY, partialTicks);
        this.toggleButton.method_25394(matrixStack, mouseX, mouseY, partialTicks);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.toggleButton.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (this.recipeSelectionGui.method_25402(mouseX, mouseY, button)) {
            this.recipeSelectionGui.setVisible(false);
            return true;
        }
        if (this.recipeSelectionGui.isVisible()) {
            if (!this.toggleButton.method_25402(mouseX, mouseY, button)) {
                this.recipeSelectionGui.setVisible(false);
            }
            return true;
        }
        class_1735 slot = this.provider.getOutputSlot();
        class_1735 focusedSlot = Polymorph.getClientLoader().getClientAccessor().getFocusedSlot(this.parent);
        if (this.toggleButton.field_22764 && slot == focusedSlot && RecipeSelectionManager.isShiftKeyDown()) {
            return this.getLastSelectedRecipe().map(recipe -> {
                Polymorph.getLoader().getPacketVendor().sendTransferRecipe(recipe.method_8114().toString());
                return true;
            }).orElse(false);
        }
        return false;
    }

    public void selectRecipe(class_1860<class_1715> recipe) {
        this.setLastSelectedRecipe(recipe);
        class_746 playerEntity = class_310.method_1551().field_1724;
        if (playerEntity != null) {
            class_1799 stack = recipe.method_8116((class_1263)this.craftingInventory);
            this.provider.getOutputSlot().method_7673(stack.method_7972());
            Polymorph.getLoader().getPacketVendor().sendSetRecipe(recipe.method_8114().toString());
        }
    }

    public void markPositionChanged() {
        this.needsPositionUpdate = true;
    }

    public void lockUpdates() {
        this.canUpdate = false;
    }

    public void unlockUpdates() {
        this.canUpdate = true;
    }

    public void markUpdate() {
        this.needsUpdate = true;
    }

    private static boolean isShiftKeyDown() {
        long handle = class_310.method_1551().method_22683().method_4490();
        return class_3675.method_15987((long)handle, (int)340) || class_3675.method_15987((long)handle, (int)344);
    }

    static {
        preferredStack = class_1799.field_8037;
    }
}

