/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.core.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1715;
import net.minecraft.class_1860;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_3955;
import net.minecraft.class_4068;
import net.minecraft.class_4587;
import top.theillusivec4.polymorph.core.client.gui.RecipeSelectWidget;

public class RecipeSelectionGui
extends class_332
implements class_4068,
class_364 {
    private final Consumer<class_1860<class_1715>> recipeSelector;
    private final class_1715 craftingInventory;
    private List<RecipeSelectWidget> buttons = new ArrayList<RecipeSelectWidget>();
    private RecipeSelectWidget hoveredButton;
    private boolean visible = false;
    private int x;
    private int y;
    private List<class_3955> recipes = new ArrayList<class_3955>();

    public RecipeSelectionGui(int x, int y, class_1715 craftingInventory, Consumer<class_1860<class_1715>> recipeSelector) {
        this.setPosition(x, y);
        this.recipeSelector = recipeSelector;
        this.craftingInventory = craftingInventory;
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
        this.updateButtonPositions();
    }

    private void updateButtonPositions() {
        int size = this.recipes.size();
        int xOffset = (int)(-25.0 * Math.floor((float)size / 2.0f));
        if (size % 2 == 0) {
            xOffset += 13;
        }
        int[] pos = new int[]{this.x + xOffset, this.y};
        this.buttons.forEach(button -> {
            button.setPosition(pos[0], pos[1]);
            pos[0] = pos[0] + 25;
        });
    }

    public List<RecipeSelectWidget> getButtons() {
        return this.buttons;
    }

    public void setRecipes(List<class_3955> recipes) {
        this.recipes = recipes;
        this.buttons.clear();
        recipes.forEach(recipe -> this.buttons.add(new RecipeSelectWidget(this.craftingInventory, (class_1860<class_1715>)recipe)));
        this.updateButtonPositions();
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void renderTooltip(class_4587 matrixStack, int p_193721_1_, int p_193721_2_) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1755 != null && this.hoveredButton != null) {
            mc.field_1755.method_25417(matrixStack, this.hoveredButton.getTooltipText(mc.field_1755), p_193721_1_, p_193721_2_);
        }
    }

    public void method_25394(class_4587 matrixStack, int p_render_1_, int p_render_2_, float p_render_3_) {
        if (this.isVisible()) {
            this.hoveredButton = null;
            this.buttons.forEach(button -> {
                button.method_25394(matrixStack, p_render_1_, p_render_2_, p_render_3_);
                if (button.field_22764 && button.method_25367()) {
                    this.hoveredButton = button;
                }
            });
            this.renderTooltip(matrixStack, p_render_1_, p_render_2_);
        }
    }

    public boolean method_25402(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        if (this.isVisible()) {
            for (RecipeSelectWidget button : this.buttons) {
                if (!button.method_25402(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_)) continue;
                this.recipeSelector.accept(button.recipe);
                return true;
            }
        }
        return false;
    }
}

