/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.client.divination;

import com.github.klikli_dev.occultism.client.divination.Scanner;
import com.github.klikli_dev.occultism.util.Math3DUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;

public class ScanManager {
    public static final ScanManager instance = new ScanManager();
    public static final int SCAN_DURATION_TICKS = 40;
    public static final int SCAN_RADIUS_BLOCKS = 96;
    List<BlockPos> results = new ArrayList<BlockPos>();
    private Scanner scanner;
    private int scanningTicks = -1;

    public void beginScan(Player player, Block target) {
        this.cancelScan();
        this.scanner = new Scanner(target);
        this.scanner.initialize(player, player.m_20182_(), 96.0f, 40);
    }

    public void updateScan(Player player, boolean forceFinish) {
        int remainingTicks = 40 - this.scanningTicks;
        if (remainingTicks <= 0 || this.scanner == null) {
            return;
        }
        if (!forceFinish) {
            this.scanner.scan(result -> this.results.add((BlockPos)result));
            ++this.scanningTicks;
            return;
        }
        for (int i = 0; i < remainingTicks; ++i) {
            this.scanner.scan(result -> this.results.add((BlockPos)result));
            ++this.scanningTicks;
        }
    }

    public BlockPos finishScan(Player player) {
        this.updateScan(player, true);
        Vec3 scanCenter = player.m_20182_();
        this.results.sort(Comparator.comparing(result -> scanCenter.m_82557_(Math3DUtil.center(result))));
        BlockPos result2 = !this.results.isEmpty() ? this.results.get(0) : null;
        this.cancelScan();
        return result2;
    }

    public void cancelScan() {
        this.scanner = null;
        this.results.clear();
        this.scanningTicks = -1;
    }
}

