/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.client.model.entity;

import com.github.klikli_dev.occultism.common.entity.DevilFamiliarEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class DevilFamiliarModel
extends EntityModel<DevilFamiliarEntity> {
    private static final float PI = (float)Math.PI;
    public ModelPart egg;
    public ModelPart body;
    public ModelPart leftLeg;
    public ModelPart leftArm;
    public ModelPart rightLeg;
    public ModelPart rightArm;
    public ModelPart neck1;
    public ModelPart leftWing;
    public ModelPart rightWing;
    public ModelPart head;
    public ModelPart lowerJaw;
    public ModelPart upperJaw;
    public ModelPart leftEye;
    public ModelPart headScales;
    public ModelPart leftEar;
    public ModelPart leftHorn;
    public ModelPart rightEye;
    public ModelPart rightHorn;
    public ModelPart rightEar;
    public ModelPart leftHornBig1;
    public ModelPart rightHornBig1;
    public ModelPart nose;
    public ModelPart tooth;
    public ModelPart jawHorn1;
    public ModelPart jawHorn2;
    public ModelPart leftHornBig2;
    public ModelPart leftHornBig3;
    public ModelPart rightHornBig2;
    public ModelPart rightHornBig3;
    public ModelPart lollipop;

    public DevilFamiliarModel(ModelPart part) {
        this.egg = part.m_171324_("egg");
        this.body = this.egg.m_171324_("body");
        this.leftLeg = this.egg.m_171324_("leftLeg");
        this.leftArm = this.egg.m_171324_("leftArm");
        this.rightLeg = this.egg.m_171324_("rightLeg");
        this.rightArm = this.egg.m_171324_("rightArm");
        this.neck1 = this.body.m_171324_("neck1");
        this.leftWing = this.body.m_171324_("leftWing");
        this.rightWing = this.body.m_171324_("rightWing");
        this.head = this.neck1.m_171324_("head");
        this.lowerJaw = this.head.m_171324_("lowerJaw");
        this.upperJaw = this.head.m_171324_("upperJaw");
        this.leftEye = this.head.m_171324_("leftEye");
        this.headScales = this.head.m_171324_("headScales");
        this.leftEar = this.head.m_171324_("leftEar");
        this.leftHorn = this.head.m_171324_("leftHorn");
        this.rightEye = this.head.m_171324_("rightEye");
        this.rightHorn = this.head.m_171324_("rightHorn");
        this.rightEar = this.head.m_171324_("rightEar");
        this.leftHornBig1 = this.head.m_171324_("leftHornBig1");
        this.rightHornBig1 = this.head.m_171324_("rightHornBig1");
        this.nose = this.upperJaw.m_171324_("nose");
        this.tooth = this.upperJaw.m_171324_("tooth");
        this.jawHorn1 = this.upperJaw.m_171324_("jawHorn1");
        this.jawHorn2 = this.jawHorn1.m_171324_("jawHorn2");
        this.leftHornBig2 = this.leftHornBig1.m_171324_("leftHornBig2");
        this.leftHornBig3 = this.leftHornBig1.m_171324_("leftHornBig3");
        this.rightHornBig2 = this.rightHornBig1.m_171324_("rightHornBig2");
        this.rightHornBig3 = this.rightHornBig1.m_171324_("rightHornBig3");
        this.lollipop = this.rightArm.m_171324_("lollipop");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition parts = mesh.m_171576_();
        PartDefinition egg = parts.m_171599_("egg", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171506_(-7.0f, -9.0f, -4.5f, 14.0f, 9.0f, 9.0f, false), PartPose.m_171423_((float)0.0f, (float)24.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body = egg.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(12, 40).m_171506_(-3.0f, -6.0f, -3.0f, 6.0f, 12.0f, 6.0f, false), PartPose.m_171423_((float)0.0f, (float)-7.0f, (float)0.0f, (float)-0.08726646f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg = egg.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(0, 30).m_171506_(-1.5f, -1.5f, -7.0f, 3.0f, 3.0f, 7.0f, false), PartPose.m_171423_((float)2.0f, (float)-1.5f, (float)-2.0f, (float)0.0f, (float)-0.19547687f, (float)0.0f));
        PartDefinition leftArm = egg.m_171599_("leftArm", CubeListBuilder.m_171558_().m_171514_(0, 30).m_171506_(-1.5f, -1.5f, -7.0f, 3.0f, 3.0f, 7.0f, false), PartPose.m_171423_((float)2.0f, (float)-11.5f, (float)0.0f, (float)0.35185838f, (float)-0.17453292f, (float)0.0f));
        PartDefinition rightLeg = egg.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(0, 30).m_171506_(-1.5f, -1.5f, -7.0f, 3.0f, 3.0f, 7.0f, true), PartPose.m_171423_((float)-2.0f, (float)-1.5f, (float)-2.0f, (float)0.0f, (float)0.19547687f, (float)0.0f));
        PartDefinition rightArm = egg.m_171599_("rightArm", CubeListBuilder.m_171558_().m_171514_(0, 30).m_171506_(-1.5f, -1.5f, -7.0f, 3.0f, 3.0f, 7.0f, false), PartPose.m_171423_((float)-2.0f, (float)-11.5f, (float)0.0f, (float)0.35185838f, (float)0.19547687f, (float)0.0f));
        PartDefinition neck1 = body.m_171599_("neck1", CubeListBuilder.m_171558_().m_171514_(37, 0).m_171506_(-2.0f, -4.0f, -2.0f, 4.0f, 4.0f, 4.0f, false), PartPose.m_171423_((float)0.0f, (float)-5.5f, (float)0.0f, (float)0.07400195f, (float)0.0f, (float)0.0f));
        PartDefinition leftWing = body.m_171599_("leftWing", CubeListBuilder.m_171558_().m_171514_(0, 40).m_171506_(0.0f, -5.0f, 0.0f, 6.0f, 6.0f, 0.0f, false), PartPose.m_171423_((float)1.5f, (float)-6.0f, (float)3.0f, (float)0.35185838f, (float)-0.50823987f, (float)0.11728612f));
        PartDefinition rightWing = body.m_171599_("rightWing", CubeListBuilder.m_171558_().m_171514_(0, 40).m_171506_(-6.0f, -5.0f, 0.0f, 6.0f, 6.0f, 0.0f, true), PartPose.m_171423_((float)-1.5f, (float)-6.0f, (float)3.0f, (float)0.35185838f, (float)0.50823987f, (float)-0.11728612f));
        PartDefinition head = neck1.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(41, 13).m_171506_(-2.5f, -5.0f, -4.0f, 5.0f, 5.0f, 5.0f, false), PartPose.m_171423_((float)0.0f, (float)-3.5f, (float)1.0f, (float)((float)Math.PI / 90), (float)0.0f, (float)0.0f));
        PartDefinition lowerJaw = head.m_171599_("lowerJaw", CubeListBuilder.m_171558_().m_171514_(24, 18).m_171506_(-2.0f, -1.0f, -5.0f, 4.0f, 2.0f, 5.0f, false), PartPose.m_171423_((float)0.0f, (float)-1.1f, (float)-2.8f, (float)0.33056536f, (float)0.0f, (float)0.0f));
        PartDefinition upperJaw = head.m_171599_("upperJaw", CubeListBuilder.m_171558_().m_171514_(39, 23).m_171506_(-2.0f, -1.5f, -5.0f, 4.0f, 3.0f, 5.0f, false), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftEye = head.m_171599_("leftEye", CubeListBuilder.m_171558_().m_171514_(49, 0).m_171506_(0.0f, -1.0f, -1.0f, 1.0f, 2.0f, 2.0f, false), PartPose.m_171423_((float)2.0f, (float)-3.3f, (float)-2.3f, (float)0.34906584f, (float)0.0f, (float)0.0f));
        PartDefinition headScales = head.m_171599_("headScales", CubeListBuilder.m_171558_().m_171514_(0, 40).m_171506_(0.0f, 0.0f, 0.0f, 0.0f, 8.0f, 6.0f, false), PartPose.m_171423_((float)0.0f, (float)-8.0f, (float)-2.0f, (float)((float)Math.PI / 90), (float)0.0f, (float)0.0f));
        PartDefinition leftEar = head.m_171599_("leftEar", CubeListBuilder.m_171558_().m_171514_(53, 4).m_171506_(-1.0f, -3.0f, -1.0f, 2.0f, 3.0f, 1.0f, false), PartPose.m_171423_((float)1.3f, (float)-4.7f, (float)0.8f, (float)0.2565634f, (float)0.16231562f, (float)0.2925172f));
        PartDefinition leftHorn = head.m_171599_("leftHorn", CubeListBuilder.m_171558_().m_171514_(0, 2).m_171506_(-0.5f, -2.0f, -0.5f, 1.0f, 2.0f, 1.0f, false), PartPose.m_171423_((float)1.0f, (float)-4.5f, (float)-1.8f, (float)0.5403539f, (float)0.13508847f, (float)0.31520647f));
        PartDefinition rightEye = head.m_171599_("rightEye", CubeListBuilder.m_171558_().m_171514_(49, 0).m_171506_(-1.0f, -1.0f, -1.0f, 1.0f, 2.0f, 2.0f, false), PartPose.m_171423_((float)-2.0f, (float)-3.3f, (float)-2.3f, (float)0.34906584f, (float)0.0f, (float)0.0f));
        PartDefinition rightHorn = head.m_171599_("rightHorn", CubeListBuilder.m_171558_().m_171514_(0, 2).m_171506_(-0.5f, -2.0f, -0.5f, 1.0f, 2.0f, 1.0f, false), PartPose.m_171423_((float)-1.0f, (float)-4.5f, (float)-1.8f, (float)0.5403539f, (float)-0.13508847f, (float)-0.31520647f));
        PartDefinition rightEar = head.m_171599_("rightEar", CubeListBuilder.m_171558_().m_171514_(53, 4).m_171506_(-1.0f, -3.0f, -1.0f, 2.0f, 3.0f, 1.0f, false), PartPose.m_171423_((float)-1.3f, (float)-4.7f, (float)0.8f, (float)0.2565634f, (float)-0.16231562f, (float)-0.2925172f));
        PartDefinition leftHornBig1 = head.m_171599_("leftHornBig1", CubeListBuilder.m_171558_().m_171514_(0, 29).m_171506_(-0.5f, -2.0f, -0.5f, 1.0f, 2.0f, 1.0f, false), PartPose.m_171423_((float)1.0f, (float)-4.8f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.312763f));
        PartDefinition rightHornBig1 = head.m_171599_("rightHornBig1", CubeListBuilder.m_171558_().m_171514_(0, 29).m_171506_(-0.5f, -2.0f, -0.5f, 1.0f, 2.0f, 1.0f, false), PartPose.m_171423_((float)-1.0f, (float)-4.8f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)-0.312763f));
        PartDefinition nose = upperJaw.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(0, 54).m_171506_(-1.5f, 0.0f, 0.0f, 3.0f, 1.0f, 2.0f, false), PartPose.m_171423_((float)0.0f, (float)-2.2f, (float)-4.6f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition tooth = upperJaw.m_171599_("tooth", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171506_(-1.0f, 0.0f, 0.0f, 2.0f, 1.0f, 1.0f, false), PartPose.m_171423_((float)0.0f, (float)1.0f, (float)-4.7f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition jawHorn1 = upperJaw.m_171599_("jawHorn1", CubeListBuilder.m_171558_().m_171514_(0, 24).m_171506_(-0.5f, -3.0f, -1.0f, 1.0f, 3.0f, 2.0f, false), PartPose.m_171423_((float)0.0f, (float)-1.2f, (float)-3.6f, (float)-0.1563815f, (float)0.0f, (float)0.0f));
        PartDefinition jawHorn2 = jawHorn1.m_171599_("jawHorn2", CubeListBuilder.m_171558_().m_171514_(0, 29).m_171506_(-0.5f, -2.0f, -0.5f, 1.0f, 2.0f, 1.0f, false), PartPose.m_171423_((float)0.0f, (float)-2.7f, (float)0.0f, (float)-0.1563815f, (float)0.0f, (float)0.0f));
        PartDefinition leftHornBig2 = leftHornBig1.m_171599_("leftHornBig2", CubeListBuilder.m_171558_().m_171514_(0, 29).m_171506_(-0.5f, -2.0f, -0.5f, 1.0f, 2.0f, 1.0f, false), PartPose.m_171423_((float)0.3f, (float)-1.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.134464f));
        PartDefinition leftHornBig3 = leftHornBig1.m_171599_("leftHornBig3", CubeListBuilder.m_171558_().m_171514_(0, 29).m_171506_(-0.5f, -2.0f, -0.5f, 1.0f, 2.0f, 1.0f, false), PartPose.m_171423_((float)0.0f, (float)-1.7f, (float)0.0f, (float)0.5864306f, (float)0.0f, (float)0.0f));
        PartDefinition rightHornBig2 = rightHornBig1.m_171599_("rightHornBig2", CubeListBuilder.m_171558_().m_171514_(0, 29).m_171506_(-0.5f, -2.0f, -0.5f, 1.0f, 2.0f, 1.0f, false), PartPose.m_171423_((float)-0.3f, (float)-1.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.134464f));
        PartDefinition rightHornBig3 = rightHornBig1.m_171599_("rightHornBig3", CubeListBuilder.m_171558_().m_171514_(0, 29).m_171506_(-0.5f, -2.0f, -0.5f, 1.0f, 2.0f, 1.0f, false), PartPose.m_171423_((float)0.0f, (float)-1.7f, (float)0.0f, (float)0.5864306f, (float)0.0f, (float)0.0f));
        PartDefinition lollipop = rightArm.m_171599_("lollipop", CubeListBuilder.m_171558_().m_171514_(0, 13).m_171506_(0.0f, -6.0f, -2.5f, 0.0f, 6.0f, 5.0f, false), PartPose.m_171423_((float)0.0f, (float)-1.5f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)64);
    }

    public void m_7695_(PoseStack pPoseStack, VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, float red, float green, float blue, float alpha) {
        this.egg.m_104306_(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, red, green, blue, alpha);
    }

    public void setupAnim(DevilFamiliarEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.showModels(entityIn);
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180) * 0.7f;
        this.head.f_104203_ = 0.03f + headPitch * ((float)Math.PI / 180) * 0.7f;
        this.egg.f_104204_ = 0.0f;
        this.egg.f_104205_ = 0.0f;
        if (entityIn.isPartying()) {
            this.egg.f_104204_ = ageInTicks / 4.0f;
            this.egg.f_104205_ = Mth.m_14089_((float)(ageInTicks / 4.0f)) * this.toRads(10.0f);
            this.leftLeg.f_104203_ = this.toRads(30.0f) + Mth.m_14089_((float)(limbSwing * 0.5f + (float)Math.PI)) * limbSwingAmount * 0.4f;
            this.rightLeg.f_104203_ = this.toRads(30.0f) + Mth.m_14089_((float)(limbSwing * 0.5f)) * limbSwingAmount * 0.4f;
            this.leftArm.f_104203_ = Mth.m_14089_((float)(ageInTicks / 4.0f)) * this.toRads(10.0f);
            this.rightArm.f_104203_ = Mth.m_14089_((float)(ageInTicks / 4.0f + (float)Math.PI)) * this.toRads(10.0f);
        } else if (entityIn.isSitting()) {
            this.leftLeg.f_104203_ = 0.0f;
            this.rightLeg.f_104203_ = 0.0f;
        } else {
            this.leftLeg.f_104203_ = this.toRads(30.0f) + Mth.m_14089_((float)(limbSwing * 0.5f)) * limbSwingAmount * 0.4f;
        }
        if (ageInTicks % 300.0f < 60.0f) {
            float progress = ageInTicks % 300.0f % 60.0f;
            float armHeight = Mth.m_14031_((float)(progress * (float)Math.PI / 60.0f)) * 0.4f;
            this.leftArm.f_104203_ = 0.35f - armHeight + Mth.m_14031_((float)(progress * (float)Math.PI / 10.0f)) * 0.45f;
            this.rightArm.f_104203_ = 0.35f - armHeight + Mth.m_14031_((float)(progress * (float)Math.PI / 10.0f + (float)Math.PI)) * 0.45f;
        } else {
            this.leftArm.f_104203_ = 0.35f;
            this.rightArm.f_104203_ = 0.35f;
        }
    }

    public void prepareMobModel(DevilFamiliarEntity entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        float animationHeight = entityIn.getAnimationHeight(partialTick);
        this.leftWing.f_104204_ = animationHeight * this.toRads(20.0f) - 0.43f;
        this.rightWing.f_104204_ = -animationHeight * this.toRads(20.0f) + 0.43f;
        if (entityIn.isSitting() && !entityIn.isPartying()) {
            this.leftWing.f_104204_ = -0.43f;
            this.rightWing.f_104204_ = 0.43f;
        }
    }

    private float toRads(float deg) {
        return (float)Math.PI / 180 * deg;
    }

    private void showModels(DevilFamiliarEntity entityIn) {
        boolean hasNose = entityIn.hasNose();
        boolean hasEars = entityIn.hasEars();
        this.lollipop.f_104207_ = entityIn.hasLollipop();
        this.nose.f_104207_ = hasNose;
        this.jawHorn1.f_104207_ = !hasNose;
        this.leftEar.f_104207_ = hasEars;
        this.rightEar.f_104207_ = hasEars;
        this.leftHorn.f_104207_ = hasEars;
        this.rightHorn.f_104207_ = hasEars;
        this.leftHornBig1.f_104207_ = !hasEars;
        this.rightHornBig1.f_104207_ = !hasEars;
    }
}

