/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity;

import com.github.klikli_dev.occultism.common.advancement.FamiliarTrigger;
import com.github.klikli_dev.occultism.common.entity.FamiliarEntity;
import com.github.klikli_dev.occultism.registry.OccultismAdvancements;
import com.github.klikli_dev.occultism.util.FamiliarUtil;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class DevilFamiliarEntity
extends FamiliarEntity {
    private final float heightOffset = this.m_21187_().nextFloat() * 5.0f;

    public DevilFamiliarEntity(EntityType<? extends DevilFamiliarEntity> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return FamiliarEntity.m_21552_().m_22268_(Attributes.f_22279_, 1.0);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.setLollipop(this.m_21187_().nextDouble() < 0.1);
        this.setNose(this.m_21187_().nextDouble() < 0.5);
        this.setEars(this.m_21187_().nextDouble() < 0.5);
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FamiliarEntity.SitGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(3, (Goal)new FamiliarEntity.FollowOwnerGoal(this, 1.0, 3.0f, 1.0f));
        this.f_21345_.m_25352_(4, (Goal)new AttackGoal(this, 5.0f));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new FollowMobGoal((Mob)this, 1.0, 3.0f, 7.0f));
    }

    @Override
    public void setFamiliarOwner(LivingEntity owner) {
        if (this.hasLollipop()) {
            OccultismAdvancements.FAMILIAR.trigger(owner, FamiliarTrigger.Type.RARE_VARIANT);
        }
        super.setFamiliarOwner(owner);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.f_19853_.f_46443_ && this.f_20911_) {
            Vec3 direction = Vec3.m_82503_((Vec2)this.m_20155_()).m_82490_(0.6);
            for (int i = 0; i < 5; ++i) {
                Vec3 pos = this.m_20182_().m_82520_(direction.f_82479_ + (double)(this.m_21187_().nextFloat() - 0.5f) * 0.7, 1.5 + (double)(this.m_21187_().nextFloat() - 0.5f) * 0.7, direction.f_82481_ + (double)(this.m_21187_().nextFloat() - 0.5f) * 0.7);
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, pos.f_82479_, pos.f_82480_, pos.f_82481_, direction.f_82479_ * 0.25, 0.0, direction.f_82481_ * 0.25);
            }
        }
    }

    public float getAnimationHeight(float partialTicks) {
        return Mth.m_14089_((float)(((float)this.f_19797_ + this.heightOffset + partialTicks) / 3.5f));
    }

    public boolean hasLollipop() {
        return this.hasVariant(0);
    }

    private void setLollipop(boolean b) {
        this.setVariant(0, b);
    }

    public boolean hasNose() {
        return this.hasVariant(1);
    }

    private void setNose(boolean b) {
        this.setVariant(1, b);
    }

    public boolean hasEars() {
        return this.hasVariant(2);
    }

    private void setEars(boolean b) {
        this.setVariant(2, b);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (!compound.m_128441_("variants")) {
            this.setLollipop(compound.m_128471_("hasLollipop"));
            this.setNose(compound.m_128471_("hasNose"));
            this.setEars(compound.m_128471_("hasEars"));
        }
    }

    @Override
    public Iterable<MobEffectInstance> getFamiliarEffects() {
        return ImmutableList.of((Object)new MobEffectInstance(MobEffects.f_19607_, 300, 0, false, false));
    }

    public static class AttackGoal
    extends Goal {
        private static final int MAX_COOLDOWN = 100;
        protected final FamiliarEntity entity;
        private final float range;
        private int cooldown = 100;

        public AttackGoal(FamiliarEntity entity, float range) {
            this.entity = entity;
            this.range = range;
        }

        public boolean m_8036_() {
            return this.cooldown-- < 0 && this.entity.getFamiliarOwner() instanceof Player && !this.getNearbyEnemies().isEmpty();
        }

        private List<LivingEntity> getNearbyEnemies() {
            return FamiliarUtil.getOwnerEnemies(this.entity.getFamiliarOwner(), (LivingEntity)this.entity, this.range);
        }

        public void m_8056_() {
            List<LivingEntity> enemies = this.getNearbyEnemies();
            if (!enemies.isEmpty() && this.entity instanceof DevilFamiliarEntity) {
                OccultismAdvancements.FAMILIAR.trigger(this.entity.getFamiliarOwner(), FamiliarTrigger.Type.DEVIL_FIRE);
            }
            this.attack(enemies);
            this.entity.m_6674_(InteractionHand.MAIN_HAND);
            this.cooldown = 100;
        }

        protected void attack(List<LivingEntity> enemies) {
            for (Entity entity : enemies) {
                entity.m_6469_(DamageSource.m_19344_((Player)((Player)this.entity.getFamiliarOwner())), 4.0f);
            }
        }

        public void m_8041_() {
            this.cooldown = 100;
        }
    }
}

