/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity;

import com.github.klikli_dev.occultism.common.entity.IFamiliar;
import com.github.klikli_dev.occultism.registry.OccultismItems;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public abstract class FamiliarEntity
extends PathfinderMob
implements IFamiliar {
    private static final float MAX_BOOST_DISTANCE = 8.0f;
    private static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.m_135353_(FamiliarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> BLACKSMITH_UPGRADE = SynchedEntityData.m_135353_(FamiliarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Byte> VARIANTS = SynchedEntityData.m_135353_(FamiliarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Optional<UUID>> OWNER_UNIQUE_ID = SynchedEntityData.m_135353_(FamiliarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private boolean partying;
    private BlockPos jukeboxPos;

    public FamiliarEntity(EntityType<? extends FamiliarEntity> type, Level level) {
        super(type, level);
        this.m_21530_();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22279_, 0.3);
    }

    public void m_6818_(BlockPos jukeboxPos, boolean partying) {
        this.jukeboxPos = jukeboxPos;
        this.partying = partying;
    }

    public boolean isPartying() {
        return this.partying;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SITTING, (Object)false);
        this.f_19804_.m_135372_(BLACKSMITH_UPGRADE, (Object)false);
        this.f_19804_.m_135372_(OWNER_UNIQUE_ID, Optional.empty());
        this.f_19804_.m_135372_(VARIANTS, (Object)0);
    }

    public boolean hasBlacksmithUpgrade() {
        return (Boolean)this.f_19804_.m_135370_(BLACKSMITH_UPGRADE);
    }

    private void setBlacksmithUpgrade(boolean b) {
        this.f_19804_.m_135381_(BLACKSMITH_UPGRADE, (Object)b);
    }

    @Override
    public void blacksmithUpgrade() {
        this.setBlacksmithUpgrade(true);
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public void m_8107_() {
        LivingEntity owner;
        this.m_21203_();
        if (this.jukeboxPos == null || !this.jukeboxPos.m_123306_((Position)this.m_20182_(), 3.5) || !this.f_19853_.m_8055_(this.jukeboxPos).m_60713_(Blocks.f_50131_)) {
            this.partying = false;
            this.jukeboxPos = null;
        }
        if (!this.f_19853_.f_46443_ && this.f_19853_.m_46467_() % 10L == 0L && (owner = this.getFamiliarOwner()) != null && this.m_20270_((Entity)owner) < 8.0f) {
            for (MobEffectInstance effect : this.getFamiliarEffects()) {
                owner.m_7292_(effect);
            }
        }
        super.m_8107_();
    }

    public LivingEntity getOwner() {
        UUID uuid = this.getOwnerId();
        return uuid == null ? null : this.f_19853_.m_46003_(uuid);
    }

    protected InteractionResult m_6071_(Player playerIn, InteractionHand hand) {
        ItemStack stack = playerIn.m_21120_(hand);
        if (stack.m_41720_() == OccultismItems.FAMILIAR_RING.get()) {
            return stack.m_41647_(playerIn, (LivingEntity)this, hand);
        }
        if (stack.m_41720_() == OccultismItems.DEBUG_WAND.get()) {
            this.setOwnerId(playerIn.m_142081_());
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        if (!this.f_19853_.f_46443_ && this.getFamiliarOwner() == playerIn) {
            this.setSitting(!this.isSitting());
        }
        return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
    }

    @Override
    public LivingEntity getFamiliarOwner() {
        return this.getOwner();
    }

    @Override
    public void setFamiliarOwner(LivingEntity owner) {
        this.setOwnerId(owner.m_142081_());
    }

    public UUID getOwnerId() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UNIQUE_ID)).orElse(null);
    }

    private void setOwnerId(UUID id) {
        this.f_19804_.m_135381_(OWNER_UNIQUE_ID, Optional.ofNullable(id));
    }

    @Override
    public Entity getFamiliarEntity() {
        return this;
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128403_("owner")) {
            this.setOwnerId(compound.m_128342_("owner"));
        }
        if (compound.m_128441_("isSitting")) {
            this.setSitting(compound.m_128471_("isSitting"));
        }
        this.setBlacksmithUpgrade(compound.m_128471_("hasBlacksmithUpgrade"));
        this.f_19804_.m_135381_(VARIANTS, (Object)compound.m_128445_("variants"));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.getOwnerId() != null) {
            compound.m_128362_("owner", this.getOwnerId());
        }
        compound.m_128379_("isSitting", this.isSitting());
        compound.m_128379_("hasBlacksmithUpgrade", this.hasBlacksmithUpgrade());
        compound.m_128344_("variants", ((Byte)this.f_19804_.m_135370_(VARIANTS)).byteValue());
    }

    public boolean isSitting() {
        return (Boolean)this.f_19804_.m_135370_(SITTING);
    }

    protected void setSitting(boolean b) {
        this.f_19804_.m_135381_(SITTING, (Object)b);
    }

    protected void setVariant(int offset, boolean b) {
        if (b) {
            this.f_19804_.m_135381_(VARIANTS, (Object)((byte)((Byte)this.f_19804_.m_135370_(VARIANTS) | 1 << offset)));
        } else {
            this.f_19804_.m_135381_(VARIANTS, (Object)((byte)((Byte)this.f_19804_.m_135370_(VARIANTS) & ~(1 << offset))));
        }
    }

    protected boolean hasVariant(int offset) {
        return ((Byte)this.f_19804_.m_135370_(VARIANTS) >> offset & 1) == 1;
    }

    protected class SitGoal
    extends Goal {
        private final FamiliarEntity entity;

        public SitGoal(FamiliarEntity entity) {
            this.entity = entity;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return !this.entity.m_20072_() && this.entity.getFamiliarOwner() != null && this.entity.isSitting();
        }

        public void m_8056_() {
            this.entity.m_21573_().m_26573_();
        }

        public void m_8041_() {
            this.entity.setSitting(false);
        }
    }

    protected static class FollowOwnerGoal
    extends Goal {
        private static final int TELEPORT_ATTEMPTS = 10;
        private final double speed;
        private final float maxDist;
        private final float minDist;
        protected FamiliarEntity entity;
        private int cooldown;
        private LivingEntity owner;

        public FollowOwnerGoal(FamiliarEntity entity, double speed, float minDist, float maxDist) {
            this.entity = entity;
            this.speed = speed;
            this.minDist = minDist * minDist;
            this.maxDist = maxDist * maxDist;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        private boolean shouldFollow(double distance) {
            return this.owner != null && !this.owner.m_5833_() && this.entity.m_20280_((Entity)this.owner) > distance;
        }

        public boolean m_8036_() {
            this.owner = this.entity.getFamiliarOwner();
            return this.shouldFollow(this.minDist);
        }

        public boolean m_8045_() {
            return this.shouldFollow(this.maxDist);
        }

        public void m_8056_() {
            this.cooldown = 0;
        }

        public void m_8041_() {
            this.owner = null;
            this.entity.m_21573_().m_26573_();
        }

        public void m_8037_() {
            this.entity.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.entity.m_8132_());
            if (--this.cooldown < 0) {
                this.cooldown = 10;
                if (!this.entity.m_21523_() && !this.entity.m_20159_()) {
                    if (this.entity.m_20280_((Entity)this.owner) >= 150.0 || this.shouldTeleport(this.owner)) {
                        this.tryTeleport();
                    } else {
                        this.entity.m_21573_().m_5624_((Entity)this.owner, this.speed);
                    }
                }
            }
        }

        protected boolean shouldTeleport(LivingEntity owner) {
            return false;
        }

        private void tryTeleport() {
            for (int i = 0; i < 10; ++i) {
                if (!this.tryTeleport(this.randomNearby(this.owner.m_142538_()))) continue;
                return;
            }
        }

        private boolean tryTeleport(BlockPos pos) {
            boolean walkable = BlockPathTypes.WALKABLE == WalkNodeEvaluator.m_77604_((BlockGetter)this.entity.f_19853_, (BlockPos.MutableBlockPos)pos.m_122032_());
            boolean noCollision = this.entity.f_19853_.m_45756_((Entity)this.entity, this.entity.m_142469_().m_82338_(pos.m_141950_((Vec3i)this.entity.m_142538_())));
            if (walkable && noCollision) {
                this.entity.m_7678_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5, this.entity.f_19859_, this.entity.f_19860_);
                this.entity.f_21344_.m_26573_();
                return true;
            }
            return false;
        }

        private BlockPos randomNearby(BlockPos pos) {
            Random rand = this.entity.m_21187_();
            return pos.m_142022_(Mth.m_14064_((Random)rand, (double)-3.0, (double)3.0), Mth.m_14064_((Random)rand, (double)-1.0, (double)1.0), Mth.m_14064_((Random)rand, (double)-3.0, (double)3.0));
        }
    }
}

