/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity;

import com.github.klikli_dev.occultism.common.advancement.FamiliarTrigger;
import com.github.klikli_dev.occultism.common.entity.DevilFamiliarEntity;
import com.github.klikli_dev.occultism.common.entity.FamiliarEntity;
import com.github.klikli_dev.occultism.network.MessageHeadlessDie;
import com.github.klikli_dev.occultism.network.OccultismPackets;
import com.github.klikli_dev.occultism.registry.OccultismAdvancements;
import com.github.klikli_dev.occultism.registry.OccultismEntities;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.mojang.math.Vector3f;
import javax.annotation.Nullable;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;

public class HeadlessFamiliarEntity
extends FamiliarEntity {
    private static final int HEAD_TIME = 1200;
    private static final byte NO_HEAD = 0;
    private static final EntityDataAccessor<Byte> HEAD = SynchedEntityData.m_135353_(HeadlessFamiliarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Byte> WEAPON = SynchedEntityData.m_135353_(HeadlessFamiliarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Byte> REBUILT = SynchedEntityData.m_135353_(HeadlessFamiliarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static ImmutableBiMap<Byte, EntityType<? extends LivingEntity>> typesLookup;
    private int headTimer;
    private int headlessDieTimer;

    public HeadlessFamiliarEntity(EntityType<? extends HeadlessFamiliarEntity> type, Level level) {
        super(type, level);
    }

    private static ImmutableBiMap<Byte, EntityType<? extends LivingEntity>> getTypesLookup() {
        if (typesLookup == null) {
            ImmutableBiMap.Builder builder = new ImmutableBiMap.Builder();
            builder.put((Object)1, (Object)EntityType.f_20532_);
            builder.put((Object)2, (Object)EntityType.f_20501_);
            builder.put((Object)3, (Object)EntityType.f_20524_);
            builder.put((Object)4, (Object)EntityType.f_20497_);
            builder.put((Object)5, (Object)EntityType.f_20558_);
            builder.put((Object)6, (Object)EntityType.f_20479_);
            builder.put((Object)7, (Object)((EntityType)OccultismEntities.CTHULHU_FAMILIAR.get()));
            typesLookup = builder.build();
        }
        return typesLookup;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return FamiliarEntity.createAttributes().m_22268_(Attributes.f_22276_, 40.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new FamiliarEntity.SitGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(5, (Goal)new FamiliarEntity.FollowOwnerGoal(this, 1.0, 3.0f, 1.0f));
        this.f_21345_.m_25352_(6, (Goal)new DevilFamiliarEntity.AttackGoal(this, 5.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && !HeadlessFamiliarEntity.this.isHeadlessDead();
            }
        });
        this.f_21345_.m_25352_(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new FollowMobGoal((Mob)this, 1.0, 3.0f, 7.0f));
    }

    public void m_8119_() {
        block7: {
            block6: {
                super.m_8119_();
                if (this.f_19853_.f_46443_) break block6;
                if (this.headTimer-- == 0) {
                    this.setHead((byte)0);
                }
                if (!this.hasBlacksmithUpgrade() || this.isHeadlessDead() || this.f_19797_ % 10 != 0 || this.getHeadType() == null) break block7;
                for (LivingEntity e2 : this.f_19853_.m_142425_(this.getHeadType(), this.m_142469_().m_82400_(5.0), e -> e != this.getFamiliarOwner())) {
                    e2.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 60));
                }
                break block7;
            }
            if (this.hasBlacksmithUpgrade() && !this.isHeadlessDead() && this.f_19797_ % 10 == 0) {
                Vec3 forward = Vec3.m_82498_((float)0.0f, (float)this.m_146908_());
                Vec3 pos = this.m_20182_().m_82549_(forward.m_82548_().m_82490_(0.15)).m_82520_(this.randPos(0.08), this.randPos(0.08), this.randPos(0.08));
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123745_, pos.f_82479_, pos.f_82480_ + 1.1, pos.f_82481_, 0.0, 0.0, 0.0);
            }
            if (this.headlessDieTimer == 1) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123746_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 0.0, 0.0, 0.0);
            }
            if (this.headlessDieTimer-- > 7) {
                for (int i = 0; i < 2; ++i) {
                    this.f_19853_.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(0.5f, 0.0f, 0.0f), 1.0f), this.m_20185_() + this.randPos(0.3), this.m_20186_() + 1.0 + this.randPos(0.3), this.m_20189_() + this.randPos(0.3), 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.setWeapon((byte)this.m_21187_().nextInt(3));
        this.setHairy(this.m_21187_().nextBoolean());
        this.setGlasses(this.m_21187_().nextDouble() < 0.1);
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    @Override
    public Iterable<MobEffectInstance> getFamiliarEffects() {
        return ImmutableList.of();
    }

    @Override
    public boolean canBlacksmithUpgrade() {
        return !this.hasBlacksmithUpgrade();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HEAD, (Object)0);
        this.f_19804_.m_135372_(WEAPON, (Object)0);
        this.f_19804_.m_135372_(REBUILT, (Object)0);
    }

    @Override
    protected InteractionResult m_6071_(Player playerIn, InteractionHand hand) {
        if (this.isHeadlessDead()) {
            ItemStack stack = playerIn.m_21120_(hand);
            Item item = stack.m_41720_();
            boolean success = false;
            if (Tags.Items.CROPS_WHEAT.m_8110_((Object)item) && !this.isRebuilt(Rebuilt.LeftLeg)) {
                this.setRebuilt(Rebuilt.LeftLeg);
                success = true;
            } else if (Tags.Items.CROPS_WHEAT.m_8110_((Object)item) && !this.isRebuilt(Rebuilt.RightLeg)) {
                this.setRebuilt(Rebuilt.RightLeg);
                success = true;
            } else if (item == Items.f_42129_ && !this.isRebuilt(Rebuilt.Body)) {
                this.setRebuilt(Rebuilt.Body);
                success = true;
            } else if (Tags.Items.RODS_WOODEN.m_8110_((Object)item) && this.isRebuilt(Rebuilt.Body) && !this.isRebuilt(Rebuilt.LeftArm)) {
                this.setRebuilt(Rebuilt.LeftArm);
                success = true;
            } else if (Tags.Items.RODS_WOODEN.m_8110_((Object)item) && this.isRebuilt(Rebuilt.Body) && !this.isRebuilt(Rebuilt.RightArm)) {
                this.setRebuilt(Rebuilt.RightArm);
                success = true;
            } else if (item == Items.f_42047_ && this.isRebuilt(Rebuilt.Body) && !this.isRebuilt(Rebuilt.Head)) {
                this.setRebuilt(Rebuilt.Head);
                success = true;
            }
            if (success) {
                stack.m_41774_(1);
                if (this.isFullyRebuilt()) {
                    OccultismAdvancements.FAMILIAR.trigger((LivingEntity)playerIn, FamiliarTrigger.Type.HEADLESS_REBUILT);
                }
                return InteractionResult.m_19078_((!this.f_19853_.f_46443_ ? 1 : 0) != 0);
            }
        }
        return super.m_6071_(playerIn, hand);
    }

    @Override
    public void setFamiliarOwner(LivingEntity owner) {
        if (this.hasGlasses()) {
            OccultismAdvancements.FAMILIAR.trigger(owner, FamiliarTrigger.Type.RARE_VARIANT);
        }
        super.setFamiliarOwner(owner);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setHead(compound.m_128445_("head"));
        this.headTimer = compound.m_128451_("headTimer");
        if (!compound.m_128441_("variants")) {
            this.setHairy(compound.m_128471_("isHairy"));
            this.setGlasses(compound.m_128471_("hasGlasses"));
            this.setHeadlessDead(compound.m_128471_("isHeadlessDead"));
        }
        this.setWeapon(compound.m_128445_("getWeapon"));
        this.setRebuilt(compound.m_128445_("getRebuilt"));
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128344_("head", this.getHead());
        compound.m_128405_("headTimer", this.headTimer);
        compound.m_128344_("getWeapon", this.getWeapon());
        compound.m_128344_("getRebuilt", this.getRebuilt());
    }

    protected void m_6475_(DamageSource pDamageSrc, float pDamageAmount) {
        super.m_6475_(pDamageSrc, pDamageAmount);
        if ((double)(this.m_21223_() / this.m_21233_()) < 0.5 && !this.isHeadlessDead()) {
            this.setHeadlessDead(true);
            OccultismPackets.sendToTracking((Entity)this, new MessageHeadlessDie(this.m_142049_()));
        }
    }

    private double randPos(double scale) {
        return ((double)this.m_21187_().nextFloat() - 0.5) * scale;
    }

    public boolean isHairy() {
        return this.hasVariant(0);
    }

    private void setHairy(boolean b) {
        this.setVariant(0, b);
    }

    private void setGlasses(boolean b) {
        this.setVariant(1, b);
    }

    public boolean hasGlasses() {
        return this.hasVariant(1);
    }

    private byte getWeapon() {
        return (Byte)this.f_19804_.m_135370_(WEAPON);
    }

    private void setWeapon(byte b) {
        this.f_19804_.m_135381_(WEAPON, (Object)b);
    }

    public ItemStack getWeaponItem() {
        Item weapon = Items.f_42383_;
        switch (this.getWeapon()) {
            case 1: {
                weapon = Items.f_42386_;
                break;
            }
            case 2: {
                weapon = Items.f_42387_;
            }
        }
        return new ItemStack((ItemLike)weapon);
    }

    private byte getHead() {
        return (Byte)this.f_19804_.m_135370_(HEAD);
    }

    private void setHead(byte head) {
        this.f_19804_.m_135381_(HEAD, (Object)head);
        if (head != 0) {
            this.headTimer = 1200;
        }
    }

    public boolean hasHead() {
        return this.getHead() != 0;
    }

    public EntityType<? extends LivingEntity> getHeadType() {
        return (EntityType)HeadlessFamiliarEntity.getTypesLookup().getOrDefault((Object)this.getHead(), null);
    }

    public void setHeadType(EntityType<?> type) {
        if (type == null || !HeadlessFamiliarEntity.getTypesLookup().inverse().containsKey(type)) {
            return;
        }
        this.setHead((Byte)HeadlessFamiliarEntity.getTypesLookup().inverse().get(type));
    }

    public boolean isHeadlessDead() {
        return this.hasVariant(2);
    }

    private void setHeadlessDead(boolean b) {
        this.setVariant(2, b);
    }

    private byte getRebuilt() {
        return (Byte)this.f_19804_.m_135370_(REBUILT);
    }

    private void setRebuilt(byte b) {
        this.f_19804_.m_135381_(REBUILT, (Object)b);
    }

    private void setRebuilt(Rebuilt r) {
        this.setRebuilt((byte)(this.getRebuilt() | 1 << r.getValue()));
    }

    public boolean isRebuilt(Rebuilt r) {
        return (this.getRebuilt() >> r.getValue() & 1) == 1;
    }

    private boolean isFullyRebuilt() {
        return this.getRebuilt() == 63;
    }

    public void killHeadless() {
        this.headlessDieTimer = 20;
    }

    public static enum Rebuilt {
        LeftLeg(0),
        RightLeg(1),
        Body(2),
        LeftArm(3),
        RightArm(4),
        Head(5);

        private final int value;

        private Rebuilt(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

