/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity.ai;

import com.github.klikli_dev.occultism.common.entity.ai.BlockSorter;
import com.github.klikli_dev.occultism.common.entity.ai.PausableGoal;
import com.github.klikli_dev.occultism.common.entity.ai.target.BlockPosMoveTarget;
import com.github.klikli_dev.occultism.common.entity.ai.target.EntityMoveTarget;
import com.github.klikli_dev.occultism.common.entity.ai.target.IMoveTarget;
import com.github.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.github.klikli_dev.occultism.exceptions.ItemHandlerMissingException;
import com.github.klikli_dev.occultism.util.Math3DUtil;
import java.util.EnumSet;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class DepositItemsGoal
extends PausableGoal {
    protected final SpiritEntity entity;
    protected final BlockSorter targetSorter;
    protected IMoveTarget moveTarget = null;

    public DepositItemsGoal(SpiritEntity entity) {
        this.entity = entity;
        this.targetSorter = new BlockSorter((Entity)entity);
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
    }

    private BlockPos getMoveTarget() {
        double angle = Math3DUtil.yaw(this.entity.m_20182_(), Math3DUtil.center(this.moveTarget.getBlockPos()));
        return this.moveTarget.getBlockPos().m_142300_(Direction.m_122364_((double)angle).m_122424_());
    }

    @Override
    public boolean m_8036_() {
        if (this.entity.m_5448_() != null) {
            return false;
        }
        if (this.entity.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
            return false;
        }
        this.resetTarget();
        return !this.isPaused() && this.moveTarget != null;
    }

    @Override
    public boolean m_8045_() {
        return !this.isPaused() && this.moveTarget != null && !this.entity.m_21120_(InteractionHand.MAIN_HAND).m_41619_();
    }

    public void m_8041_() {
        this.entity.m_21573_().m_26573_();
        this.resetTarget();
    }

    public void m_8037_() {
        if (this.moveTarget != null) {
            if (this.moveTarget.isValid()) {
                float accessDistance = 1.86f;
                double distance = this.entity.m_20182_().m_82554_(Math3DUtil.center(this.moveTarget.getBlockPos()));
                if (distance < 2.5 && distance >= (double)accessDistance && this.canSeeTarget() && this.moveTarget.isChest()) {
                    this.toggleChest(this.moveTarget, true);
                }
                if (distance < (double)accessDistance) {
                    this.entity.m_21573_().m_26573_();
                } else {
                    BlockPos moveTarget = this.getMoveTarget();
                    this.entity.m_21573_().m_26536_(this.entity.m_21573_().m_7864_(moveTarget, 0), 1.0);
                }
                if (distance < 1.86 && this.canSeeTarget()) {
                    ItemStack duplicate;
                    LazyOptional handlerCapability = this.moveTarget.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.entity.getDepositFacing());
                    if (!handlerCapability.isPresent()) {
                        this.resetTarget();
                        return;
                    }
                    IItemHandler handler = (IItemHandler)handlerCapability.orElseThrow(ItemHandlerMissingException::new);
                    ItemStack toInsert = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)(duplicate = this.entity.m_21120_(InteractionHand.MAIN_HAND).m_41777_()), (boolean)true);
                    if (toInsert.m_41613_() != duplicate.m_41613_()) {
                        ItemStack leftover = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)duplicate, (boolean)false);
                        this.entity.m_21008_(InteractionHand.MAIN_HAND, leftover);
                        if (toInsert.m_41619_()) {
                            this.moveTarget = null;
                            this.m_8041_();
                        } else {
                            this.pause(2000L);
                        }
                    }
                    if (this.moveTarget != null && this.moveTarget.isChest()) {
                        this.toggleChest(this.moveTarget, false);
                    }
                }
            } else {
                this.resetTarget();
            }
        }
    }

    public boolean canSeeTarget() {
        ClipContext context = new ClipContext(this.entity.m_20182_(), Math3DUtil.center(this.moveTarget.getBlockPos()), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.entity);
        BlockHitResult result = this.entity.f_19853_.m_45547_(context);
        if (result.m_6662_() != HitResult.Type.MISS) {
            BlockPos sidePos = result.m_82425_();
            BlockPos pos = new BlockPos(result.m_82450_());
            return this.entity.f_19853_.m_46859_(sidePos) || this.entity.f_19853_.m_46859_(pos) || this.entity.f_19853_.m_7702_(pos) == this.entity.f_19853_.m_7702_(this.moveTarget.getBlockPos());
        }
        return true;
    }

    public void toggleChest(IMoveTarget target, boolean open) {
        BlockEntity blockEntity;
        if (target instanceof BlockPosMoveTarget && (blockEntity = this.entity.f_19853_.m_7702_(target.getBlockPos())) instanceof ChestBlockEntity) {
            ChestBlockEntity chest = (ChestBlockEntity)blockEntity;
            if (open) {
                this.entity.f_19853_.m_7696_(this.moveTarget.getBlockPos(), chest.m_58900_().m_60734_(), 1, 1);
            } else {
                this.entity.f_19853_.m_7696_(this.moveTarget.getBlockPos(), chest.m_58900_().m_60734_(), 1, 0);
            }
        }
    }

    private void resetTarget() {
        Optional<BlockPos> targetPos = this.entity.getDepositPosition();
        targetPos.ifPresent(pos -> {
            this.moveTarget = new BlockPosMoveTarget(this.entity.f_19853_, (BlockPos)pos);
            if (!this.moveTarget.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.entity.getDepositFacing()).isPresent()) {
                this.entity.setDepositPosition(null);
            }
        });
        Optional<UUID> targetUUID = this.entity.getDepositEntityUUID();
        targetUUID.ifPresent(uuid -> {
            Entity targetEntity = ((ServerLevel)this.entity.f_19853_).m_8791_(uuid);
            if (targetEntity != null) {
                this.moveTarget = new EntityMoveTarget(targetEntity);
            } else {
                this.entity.setDepositEntityUUID(null);
            }
        });
    }
}

