/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity.ai;

import com.github.klikli_dev.occultism.common.entity.ai.BlockSorter;
import com.github.klikli_dev.occultism.common.entity.ai.PausableGoal;
import com.github.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.github.klikli_dev.occultism.exceptions.ItemHandlerMissingException;
import com.github.klikli_dev.occultism.util.Math3DUtil;
import com.github.klikli_dev.occultism.util.StorageUtil;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ExtractItemsGoal
extends PausableGoal {
    protected final SpiritEntity entity;
    protected final BlockSorter targetSorter;
    protected BlockPos targetBlock = null;

    public ExtractItemsGoal(SpiritEntity entity) {
        this.entity = entity;
        this.targetSorter = new BlockSorter((Entity)entity);
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
    }

    private BlockPos getMoveTarget() {
        double angle = Math3DUtil.yaw(this.entity.m_20182_(), Math3DUtil.center(this.targetBlock));
        return this.targetBlock.m_142300_(Direction.m_122364_((double)angle).m_122424_());
    }

    @Override
    public boolean m_8036_() {
        if (this.entity.m_5448_() != null) {
            return false;
        }
        if (!this.entity.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
            return false;
        }
        this.resetTarget();
        return !this.isPaused() && this.targetBlock != null;
    }

    @Override
    public boolean m_8045_() {
        return !this.isPaused() && this.targetBlock != null && !this.entity.m_21120_(InteractionHand.MAIN_HAND).m_41619_();
    }

    public void m_8041_() {
        this.entity.m_21573_().m_26573_();
        this.resetTarget();
    }

    public void m_8037_() {
        if (this.targetBlock != null) {
            if (this.entity.f_19853_.m_7702_(this.targetBlock) != null) {
                BlockEntity blockEntity = this.entity.f_19853_.m_7702_(this.targetBlock);
                float accessDistance = 1.86f;
                double distance = this.entity.m_20182_().m_82554_(Math3DUtil.center(this.targetBlock));
                if (distance < 2.5 && distance >= (double)accessDistance && this.canSeeTarget() && blockEntity instanceof Container) {
                    Container container = (Container)blockEntity;
                    this.toggleChest(container, true);
                }
                if (distance < (double)accessDistance) {
                    this.entity.m_21573_().m_26573_();
                } else {
                    BlockPos moveTarget = this.getMoveTarget();
                    this.entity.m_21573_().m_26536_(this.entity.m_21573_().m_7864_(moveTarget, 0), 1.0);
                }
                if (distance < 1.86 && this.canSeeTarget()) {
                    ItemStack remaining;
                    ItemStack toExtract;
                    LazyOptional handlerCapability = blockEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.entity.getExtractFacing());
                    if (!handlerCapability.isPresent()) {
                        this.resetTarget();
                        return;
                    }
                    IItemHandler blockEntityHandler = (IItemHandler)handlerCapability.orElseThrow(ItemHandlerMissingException::new);
                    IItemHandler entityHandler = (IItemHandler)this.entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.DOWN).orElseThrow(ItemHandlerMissingException::new);
                    int slot = StorageUtil.getFirstMatchingSlot(blockEntityHandler, (IItemHandler)this.entity.getFilterItems().orElseThrow(ItemHandlerMissingException::new), this.entity.getTagFilter(), this.entity.isFilterBlacklist());
                    if (slot >= 0 && !(toExtract = blockEntityHandler.extractItem(slot, Integer.MAX_VALUE, true).m_41777_()).m_41619_() && (remaining = ItemHandlerHelper.insertItem((IItemHandler)entityHandler, (ItemStack)toExtract, (boolean)true)).m_41613_() < toExtract.m_41613_()) {
                        ItemStack extracted = blockEntityHandler.extractItem(slot, toExtract.m_41613_() - remaining.m_41613_(), false);
                        ItemHandlerHelper.insertItem((IItemHandler)entityHandler, (ItemStack)extracted, (boolean)false);
                    }
                    if (blockEntity instanceof Container) {
                        Container container = (Container)blockEntity;
                        this.toggleChest(container, false);
                    }
                }
            } else {
                this.resetTarget();
            }
        }
    }

    public boolean canSeeTarget() {
        ClipContext context = new ClipContext(this.entity.m_20182_(), Math3DUtil.center(this.targetBlock), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.entity);
        BlockHitResult result = this.entity.f_19853_.m_45547_(context);
        if (result.m_6662_() != HitResult.Type.MISS) {
            BlockPos sidePos = result.m_82425_();
            BlockPos pos = new BlockPos(result.m_82450_());
            return this.entity.f_19853_.m_46859_(sidePos) || this.entity.f_19853_.m_46859_(pos) || this.entity.f_19853_.m_7702_(pos) == this.entity.f_19853_.m_7702_(this.targetBlock);
        }
        return true;
    }

    public void toggleChest(Container blockEntity, boolean open) {
        if (blockEntity instanceof ChestBlockEntity) {
            ChestBlockEntity chest = (ChestBlockEntity)blockEntity;
            if (open) {
                this.entity.f_19853_.m_7696_(this.targetBlock, chest.m_58900_().m_60734_(), 1, 1);
            } else {
                this.entity.f_19853_.m_7696_(this.targetBlock, chest.m_58900_().m_60734_(), 1, 0);
            }
        }
    }

    private void resetTarget() {
        Optional<BlockPos> targetPos = this.entity.getExtractPosition();
        targetPos.ifPresent(pos -> {
            this.targetBlock = pos;
            BlockEntity blockEntity = this.entity.f_19853_.m_7702_(this.targetBlock);
            if (blockEntity == null || !blockEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.entity.getExtractFacing()).isPresent()) {
                this.entity.setExtractPosition(null);
            }
        });
    }
}

