/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity.ai;

import com.github.klikli_dev.occultism.common.entity.ai.BlockSorter;
import com.github.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.github.klikli_dev.occultism.common.job.LumberjackJob;
import com.github.klikli_dev.occultism.util.Math3DUtil;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ReplantSaplingGoal
extends Goal {
    protected final SpiritEntity entity;
    protected final BlockSorter targetSorter;
    protected BlockPos moveTarget = null;

    public ReplantSaplingGoal(SpiritEntity entity) {
        this.entity = entity;
        this.targetSorter = new BlockSorter((Entity)entity);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    private BlockPos getMoveTarget() {
        double angle = Math3DUtil.yaw(this.entity.m_20182_(), Math3DUtil.center(this.moveTarget));
        return this.moveTarget.m_142300_(Direction.m_122364_((double)angle).m_122424_());
    }

    public boolean m_8036_() {
        if (!ItemTags.f_13180_.m_8110_((Object)this.entity.m_21120_(InteractionHand.MAIN_HAND).m_41720_())) {
            return false;
        }
        if (!this.entity.getJob().map(j -> (LumberjackJob)j).map(j -> j.getLastFelledTree() != null).orElse(false).booleanValue()) {
            return false;
        }
        this.resetTarget();
        return this.moveTarget != null;
    }

    public boolean m_8045_() {
        return this.moveTarget != null && !ItemTags.f_13180_.m_8110_((Object)this.entity.m_21120_(InteractionHand.MAIN_HAND).m_41720_()) && this.entity.getJob().map(j -> (LumberjackJob)j).map(j -> j.getLastFelledTree() != null).orElse(false) == false;
    }

    public void m_8041_() {
        this.entity.m_21573_().m_26573_();
        this.resetTarget();
    }

    public void m_8037_() {
        if (this.moveTarget != null) {
            float accessDistance = 4.5f;
            double distance = this.entity.m_20182_().m_82554_(Math3DUtil.center(this.moveTarget));
            if (distance < (double)accessDistance) {
                this.entity.m_21573_().m_26573_();
                this.entity.getJob().map(j -> (LumberjackJob)j).map(LumberjackJob::getLastFelledTree).ifPresent(lastFelledTree -> {
                    ItemStack sapling;
                    Item patt3952$temp;
                    if (this.entity.f_19853_.m_46859_(lastFelledTree) && (patt3952$temp = (sapling = this.entity.m_21120_(InteractionHand.MAIN_HAND)).m_41720_()) instanceof BlockItem) {
                        BlockItem saplingBlockItem = (BlockItem)patt3952$temp;
                        this.entity.f_19853_.m_46597_(lastFelledTree, saplingBlockItem.m_40614_().m_49966_());
                        sapling.m_41774_(1);
                    }
                });
                this.entity.getJob().map(j -> (LumberjackJob)j).ifPresent(j -> j.setLastFelledTree(null));
            } else {
                BlockPos moveTarget = this.getMoveTarget();
                this.entity.m_21573_().m_26536_(this.entity.m_21573_().m_7864_(moveTarget, 0), 1.0);
            }
        } else {
            this.resetTarget();
        }
    }

    private void resetTarget() {
        this.moveTarget = null;
        this.entity.getJob().map(j -> (LumberjackJob)j).map(LumberjackJob::getLastFelledTree).ifPresent(t -> {
            this.moveTarget = t;
        });
    }
}

