/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.item.spirit;

import com.github.klikli_dev.occultism.common.blockentity.DimensionalMineshaftBlockEntity;
import com.github.klikli_dev.occultism.util.ItemNBTUtil;
import com.github.klikli_dev.occultism.util.TextUtil;
import java.lang.reflect.Field;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public class MinerSpiritItem
extends Item {
    protected static Field maxDamageField = ObfuscationReflectionHelper.findField(Item.class, (String)"f_41371_");
    private final Supplier<Integer> maxMiningTime;
    private final Supplier<Integer> rollsPerOperation;
    private final Supplier<Integer> maxDamage;
    private boolean hasInitializedMaxDamage;

    public MinerSpiritItem(Item.Properties properties, Supplier<Integer> maxMiningTime, Supplier<Integer> rollsPerOperation, Supplier<Integer> maxDamage) {
        super(properties);
        this.maxMiningTime = maxMiningTime;
        this.rollsPerOperation = rollsPerOperation;
        this.maxDamage = maxDamage;
        this.hasInitializedMaxDamage = false;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)new TranslatableComponent(this.m_5524_() + ".tooltip", new Object[]{TextUtil.formatDemonName(ItemNBTUtil.getBoundSpiritName(stack))}));
    }

    public int m_142158_(ItemStack stack) {
        if (!this.hasInitializedMaxDamage) {
            this.hasInitializedMaxDamage = true;
            try {
                maxDamageField.setInt((Object)this, this.maxDamage.get());
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return super.m_142158_(stack);
    }

    public void m_7836_(ItemStack stack, Level worldIn, Player playerIn) {
        super.m_7836_(stack, worldIn, playerIn);
        if (!this.hasInitializedMaxDamage) {
            this.hasInitializedMaxDamage = true;
            try {
                maxDamageField.setInt((Object)this, this.maxDamage.get());
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        stack.m_41784_().m_128405_("maxMiningTime", this.maxMiningTime.get().intValue());
        stack.m_41784_().m_128405_(DimensionalMineshaftBlockEntity.ROLLS_PER_OPERATION_TAG, this.rollsPerOperation.get().intValue());
    }
}

