/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.job;

import com.github.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.github.klikli_dev.occultism.common.job.SpiritJobFactory;
import com.github.klikli_dev.occultism.registry.OccultismSpiritJobs;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraftforge.common.util.INBTSerializable;

public abstract class SpiritJob
implements INBTSerializable<CompoundTag> {
    public SpiritEntity entity;
    public ResourceLocation factoryId;

    public SpiritJob(SpiritEntity entity) {
        this.entity = entity;
    }

    public static SpiritJob from(SpiritEntity entity, CompoundTag nbt) {
        SpiritJobFactory factory = (SpiritJobFactory)OccultismSpiritJobs.REGISTRY.getValue(new ResourceLocation(nbt.m_128461_("factoryId")));
        SpiritJob job = factory.create(entity);
        job.deserializeNBT(nbt);
        return job;
    }

    public ResourceLocation getFactoryID() {
        return this.factoryId;
    }

    public void setFactoryId(ResourceLocation factoryId) {
        this.factoryId = factoryId;
    }

    public CompoundTag serializeNBT() {
        return this.writeJobToNBT(new CompoundTag());
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.readJobFromNBT(nbt);
    }

    public abstract void init();

    public abstract void cleanup();

    public void update() {
    }

    public CompoundTag writeJobToNBT(CompoundTag compound) {
        compound.m_128359_("factoryId", this.getFactoryID().toString());
        return compound;
    }

    public void readJobFromNBT(CompoundTag compound) {
    }

    public boolean canPickupItem(ItemEntity entity) {
        return false;
    }

    public EntityDimensions getDimensions(Pose pPose, EntityDimensions original) {
        return original;
    }
}

