/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.level.cave;

import com.github.klikli_dev.occultism.Occultism;
import com.github.klikli_dev.occultism.common.block.otherworld.OtherstoneNaturalBlock;
import com.github.klikli_dev.occultism.common.level.OccultismPlacements;
import com.github.klikli_dev.occultism.common.level.cave.CaveDecorator;
import com.github.klikli_dev.occultism.registry.OccultismBlocks;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;

public class UndergroundGroveDecorator
extends CaveDecorator {
    public UndergroundGroveDecorator() {
        super(Blocks.f_50440_.m_49966_(), null, ((OtherstoneNaturalBlock)OccultismBlocks.OTHERSTONE_NATURAL.get()).m_49966_());
    }

    @Override
    public void finalFloorPass(WorldGenLevel seedReader, ChunkGenerator generator, Random rand, BlockPos pos) {
        if (seedReader.m_8055_(pos).m_60734_() == Blocks.f_50440_ && (double)rand.nextFloat() < (Double)Occultism.COMMON_CONFIG.worldGen.undergroundGroveGen.grassChance.get()) {
            seedReader.m_7731_(pos.m_7494_(), Blocks.f_50034_.m_49966_(), 2);
        }
        if ((double)rand.nextFloat() < (Double)Occultism.COMMON_CONFIG.worldGen.undergroundGroveGen.treeChance.get()) {
            OccultismPlacements.OTHERWORLD_TREE_NATURAL.m_191782_(seedReader, generator, rand, pos.m_7494_());
        }
    }

    @Override
    public void finalCeilingPass(WorldGenLevel seedReader, ChunkGenerator generator, Random rand, BlockPos pos) {
        if ((double)rand.nextFloat() < (Double)Occultism.COMMON_CONFIG.worldGen.undergroundGroveGen.ceilingLightChance.get()) {
            seedReader.m_7731_(pos, Blocks.f_50141_.m_49966_(), 2);
        }
        super.finalCeilingPass(seedReader, generator, rand, pos);
    }

    @Override
    public void finalWallPass(WorldGenLevel seedReader, ChunkGenerator generator, Random rand, BlockPos pos) {
        for (Direction facing : Direction.Plane.HORIZONTAL) {
            BlockPos offset = pos.m_142300_(facing);
            BlockPos up = offset.m_7494_();
            if (!this.isCeiling(seedReader, up, seedReader.m_8055_(up)) || !((double)rand.nextFloat() < (Double)Occultism.COMMON_CONFIG.worldGen.undergroundGroveGen.vineChance.get())) continue;
            BlockState stateAt = seedReader.m_8055_(offset);
            boolean spawnedVine = false;
            while (stateAt.m_60795_() && offset.m_123342_() > 0) {
                seedReader.m_7731_(offset, (BlockState)Blocks.f_50191_.m_49966_().m_61124_((Property)VineBlock.m_57883_((Direction)facing.m_122424_()), (Comparable)Boolean.valueOf(true)), 2);
                offset = offset.m_7495_();
                stateAt = seedReader.m_8055_(offset);
                spawnedVine = true;
            }
            if (!spawnedVine) continue;
            return;
        }
    }
}

