/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.ritual.pentacle;

import com.github.klikli_dev.occultism.Occultism;
import com.github.klikli_dev.occultism.common.block.ChalkGlyphBlock;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.SerializationTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.IStateMatcher;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.api.TriPredicate;

public class Pentacle {
    private final ResourceLocation rl;
    private final List<String> pattern;
    private final Map<Character, JsonElement> mappings;
    private final IMultiblock matcher;

    public Pentacle(ResourceLocation rl, List<String> pattern, Map<Character, JsonElement> mappings) {
        this.rl = rl;
        this.pattern = pattern;
        this.mappings = mappings;
        for (String r1 : pattern) {
            for (String r2 : pattern) {
                if (r1.length() == r2.length()) continue;
                throw new IllegalArgumentException("Pentacle pattern can not have rows with different lengths");
            }
        }
        for (String row : pattern) {
            for (Object c : (Object)row.toCharArray()) {
                if (c == 32 || mappings.containsKey(Character.valueOf((char)c))) continue;
                throw new IllegalArgumentException("Pentacle mappings is missing " + (char)c);
            }
        }
        PatchouliAPI.IPatchouliAPI api = PatchouliAPI.get();
        String[][] multiPattern = new String[1][pattern.size()];
        for (int i = 0; i < pattern.size(); ++i) {
            multiPattern[0][i] = pattern.get(pattern.size() - 1 - i);
        }
        ArrayList<Character> multiMappings = new ArrayList<Character>();
        for (Map.Entry<Character, JsonElement> entry : mappings.entrySet()) {
            multiMappings.add(entry.getKey());
            multiMappings.add((Character)Pentacle.parseStateMatcher(entry.getValue()));
        }
        multiMappings.add(Character.valueOf(' '));
        multiMappings.add((Character)api.anyMatcher());
        ResourceLocation multiRL = new ResourceLocation(rl.m_135827_(), "pentacle." + rl.m_135815_());
        this.matcher = api.makeMultiblock(multiPattern, multiMappings.toArray());
        this.matcher.setId(multiRL);
        try {
            if (PatchouliAPI.get().getMultiblock(multiRL) == null) {
                PatchouliAPI.get().registerMultiblock(multiRL, this.matcher);
            }
        }
        catch (IllegalArgumentException e) {
            Occultism.LOGGER.warn((Object)e);
        }
    }

    public static Pentacle fromJson(ResourceLocation rl, JsonObject json) {
        JsonArray jsonPattern = GsonHelper.m_13933_((JsonObject)json, (String)"pattern");
        JsonObject jsonMapping = GsonHelper.m_13930_((JsonObject)json, (String)"mapping");
        ArrayList<String> pattern = new ArrayList<String>();
        HashMap<Character, JsonElement> mappings = new HashMap<Character, JsonElement>();
        for (int i = 0; i < jsonPattern.size(); ++i) {
            pattern.add(GsonHelper.m_13805_((JsonElement)jsonPattern.get(i), (String)"row"));
        }
        for (Map.Entry entry : jsonMapping.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Mapping key needs to be only 1 character");
            }
            char key = ((String)entry.getKey()).charAt(0);
            mappings.put(Character.valueOf(key), (JsonElement)entry.getValue());
        }
        return new Pentacle(rl, pattern, mappings);
    }

    public static Pentacle fromNetwork(ResourceLocation key, FriendlyByteBuf buffer) {
        ArrayList<String> pattern = new ArrayList<String>();
        HashMap<Character, JsonElement> mappings = new HashMap<Character, JsonElement>();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            pattern.add(buffer.m_130277_());
        }
        size = buffer.readInt();
        JsonParser parser = new JsonParser();
        for (int i = 0; i < size; ++i) {
            mappings.put(Character.valueOf(buffer.readChar()), parser.parse(buffer.m_130277_()));
        }
        return new Pentacle(key, pattern, mappings);
    }

    public static IStateMatcher parseStateMatcher(JsonElement matcher) {
        ResourceLocation blockRL;
        Block block;
        if (matcher.isJsonObject()) {
            ResourceLocation displayRL;
            JsonObject jsonObject = matcher.getAsJsonObject();
            Block display = null;
            if (jsonObject.has("display") && (display = (Block)ForgeRegistries.BLOCKS.getValue(displayRL = new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"display")))) == null) {
                throw new JsonSyntaxException("Invalid display" + displayRL);
            }
            if (jsonObject.has("block")) {
                ResourceLocation blockRL2 = new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"block"));
                Block block2 = (Block)ForgeRegistries.BLOCKS.getValue(blockRL2);
                if (block2 == null) {
                    throw new JsonSyntaxException("Invalid block " + blockRL2);
                }
                if (display != null) {
                    return Pentacle.OM(PatchouliAPI.get().predicateMatcher(display, s -> s.m_60734_() == block2), block2);
                }
                return Pentacle.OM(PatchouliAPI.get().looseBlockMatcher(block2), block2);
            }
            if (jsonObject.has("tag")) {
                ResourceLocation tagRL = new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"tag"));
                try {
                    Tag tag = SerializationTags.m_13199_().m_144458_(Registry.f_122901_, tagRL, rl -> new JsonSyntaxException("Unknown block tag '" + rl + "'"));
                    if (display == null) {
                        throw new JsonSyntaxException("No display set for tag " + tagRL);
                    }
                    return Pentacle.OM(PatchouliAPI.get().predicateMatcher(display, s -> tag.m_8110_((Object)s.m_60734_())));
                }
                catch (JsonSyntaxException jsonSyntaxException) {
                    return Pentacle.OM(PatchouliAPI.get().predicateMatcher(display, s -> BlockTags.m_13115_().m_7689_(tagRL).m_8110_((Object)s.m_60734_())));
                }
            }
            if (display != null) {
                return Pentacle.OM(PatchouliAPI.get().displayOnlyMatcher(display));
            }
        }
        if ((block = (Block)ForgeRegistries.BLOCKS.getValue(blockRL = new ResourceLocation(matcher.getAsString()))) == null) {
            throw new JsonSyntaxException("Invalid block " + blockRL);
        }
        return Pentacle.OM(PatchouliAPI.get().looseBlockMatcher(block), block);
    }

    private static OccultismMatcher OM(IStateMatcher matcher) {
        return new OccultismMatcher(matcher);
    }

    private static OccultismMatcher OM(IStateMatcher matcher, Block block) {
        return new OccultismMatcher(matcher, block);
    }

    public String getDescriptionId() {
        return Util.m_137492_((String)"pentacle", (ResourceLocation)this.rl);
    }

    public boolean validate(Level level, BlockPos pos) {
        return this.matcher.validate(level, pos) != null;
    }

    public Map<BlockPos, Block> getDifference(Level level, BlockPos pos) {
        HashMap<BlockPos, Block> minDifference = new HashMap<BlockPos, Block>();
        int minDiffSize = Integer.MAX_VALUE;
        for (Rotation rot : Rotation.values()) {
            HashMap<BlockPos, Block> difference = new HashMap<BlockPos, Block>();
            Pair sim = this.matcher.simulate(level, pos, rot, false);
            for (IMultiblock.SimulateResult result : (Collection)sim.getSecond()) {
                if (result.test(level, rot)) continue;
                difference.put(result.getWorldPosition(), result.getStateMatcher().getDisplayedState(0).m_60734_());
            }
            if (difference.size() >= minDiffSize) continue;
            minDifference = difference;
            minDiffSize = difference.size();
        }
        return minDifference;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        JsonArray jsonPattern = new JsonArray();
        for (String row : this.pattern) {
            jsonPattern.add(row);
        }
        json.add("pattern", (JsonElement)jsonPattern);
        JsonObject jsonMapping = new JsonObject();
        for (Map.Entry<Character, JsonElement> entry : this.mappings.entrySet()) {
            jsonMapping.add(String.valueOf(entry.getKey()), entry.getValue());
        }
        json.add("mapping", (JsonElement)jsonMapping);
        return json;
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.writeInt(this.pattern.size());
        for (String string : this.pattern) {
            buffer.m_130070_(string);
        }
        buffer.writeInt(this.mappings.size());
        for (Map.Entry entry : this.mappings.entrySet()) {
            buffer.writeChar((int)((Character)entry.getKey()).charValue());
            buffer.m_130070_(((JsonElement)entry.getValue()).toString());
        }
    }

    private static class OccultismMatcher
    implements IStateMatcher {
        private final IStateMatcher matcher;
        private final Block block;

        private OccultismMatcher(IStateMatcher matcher, Block block) {
            this.matcher = matcher;
            this.block = block;
        }

        private OccultismMatcher(IStateMatcher matcher) {
            this(matcher, null);
        }

        public BlockState getDisplayedState(int ticks) {
            if (this.block instanceof ChalkGlyphBlock) {
                return (BlockState)this.block.m_49966_().m_61124_((Property)ChalkGlyphBlock.SIGN, (Comparable)Integer.valueOf(ticks / 20 % 12));
            }
            return this.matcher.getDisplayedState(ticks);
        }

        public TriPredicate<BlockGetter, BlockPos, BlockState> getStatePredicate() {
            return this.matcher.getStatePredicate();
        }
    }
}

