/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.handlers;

import com.github.klikli_dev.occultism.Occultism;
import com.github.klikli_dev.occultism.common.block.otherworld.OtherworldLeavesNaturalBlock;
import com.github.klikli_dev.occultism.common.block.otherworld.OtherworldSaplingBlock;
import com.github.klikli_dev.occultism.common.block.otherworld.OtherworldSaplingNaturalBlock;
import com.github.klikli_dev.occultism.common.job.SpiritJobFactory;
import com.github.klikli_dev.occultism.common.ritual.RitualFactory;
import com.github.klikli_dev.occultism.loot.AddItemModifier;
import com.github.klikli_dev.occultism.registry.OccultismBlocks;
import com.github.klikli_dev.occultism.registry.OccultismEntities;
import com.github.klikli_dev.occultism.registry.OccultismItems;
import com.github.klikli_dev.occultism.registry.OccultismRituals;
import com.github.klikli_dev.occultism.registry.OccultismSpiritJobs;
import com.github.klikli_dev.occultism.util.StaticUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="occultism", bus=Mod.EventBusSubscriber.Bus.MOD)
public class RegistryEventHandler {
    @SubscribeEvent
    public static void registerRegistries(RegistryEvent.NewRegistry event) {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        new RegistryBuilder().setName(new ResourceLocation("occultism", "ritual_factory")).setType(RitualFactory.class).create();
        new RegistryBuilder().setName(new ResourceLocation("occultism", "spirit_job_factory")).setType(SpiritJobFactory.class).create();
        OccultismSpiritJobs.JOBS.register(modEventBus);
        OccultismRituals.RITUAL_FACTORIES.register(modEventBus);
    }

    @SubscribeEvent
    public static void onRegisterItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        OccultismBlocks.BLOCKS.getEntries().stream().map(RegistryObject::get).filter(block -> OccultismBlocks.BLOCK_DATA_GEN_SETTINGS.get((Object)block.getRegistryName()).generateDefaultBlockItem).forEach(block -> {
            BlockItem blockItem = new BlockItem(block, new Item.Properties().m_41491_(Occultism.ITEM_GROUP));
            blockItem.setRegistryName(block.getRegistryName());
            registry.register((IForgeRegistryEntry)blockItem);
        });
        Occultism.LOGGER.info("Registered BlockItems");
        RegistryEventHandler.registerSpawnEgg((IForgeRegistry<Item>)registry, (EntityType<? extends Mob>)((EntityType)OccultismEntities.FOLIOT_TYPE.get()), "foliot", 11170445, 3613228);
        RegistryEventHandler.registerSpawnEgg((IForgeRegistry<Item>)registry, (EntityType<? extends Mob>)((EntityType)OccultismEntities.DJINNI_TYPE.get()), "djinni", 11170445, 3613228);
        RegistryEventHandler.registerSpawnEgg((IForgeRegistry<Item>)registry, (EntityType<? extends Mob>)((EntityType)OccultismEntities.AFRIT_TYPE.get()), "afrit", 11170445, 3613228);
        RegistryEventHandler.registerSpawnEgg((IForgeRegistry<Item>)registry, (EntityType<? extends Mob>)((EntityType)OccultismEntities.AFRIT_WILD_TYPE.get()), "afrit_wild", 11170445, 3613228);
        RegistryEventHandler.registerSpawnEgg((IForgeRegistry<Item>)registry, (EntityType<? extends Mob>)((EntityType)OccultismEntities.MARID_TYPE.get()), "marid", 0x4D4D4D, 1444049);
        RegistryEventHandler.registerSpawnEgg((IForgeRegistry<Item>)registry, (EntityType<? extends Mob>)((EntityType)OccultismEntities.POSSESSED_ENDERMITE_TYPE.get()), "possessed_endermite", 0x161616, 0x6E6E6E);
        RegistryEventHandler.registerSpawnEgg((IForgeRegistry<Item>)registry, (EntityType<? extends Mob>)((EntityType)OccultismEntities.POSSESSED_SKELETON_TYPE.get()), "possessed_skeleton", 0xC1C1C1, 0x494949);
        RegistryEventHandler.registerSpawnEgg((IForgeRegistry<Item>)registry, (EntityType<? extends Mob>)((EntityType)OccultismEntities.POSSESSED_ENDERMAN_TYPE.get()), "possessed_enderman", 0x161616, 0);
        RegistryEventHandler.registerSpawnEgg((IForgeRegistry<Item>)registry, (EntityType<? extends Mob>)((EntityType)OccultismEntities.WILD_HUNT_SKELETON_TYPE.get()), "wild_hunt_skeleton", 0xC1C1C1, 0x494949);
        RegistryEventHandler.registerSpawnEgg((IForgeRegistry<Item>)registry, (EntityType<? extends Mob>)((EntityType)OccultismEntities.WILD_HUNT_WITHER_SKELETON_TYPE.get()), "wild_hunt_wither_skeleton", 0x141414, 0x474D4D);
        RegistryEventHandler.registerSpawnEgg((IForgeRegistry<Item>)registry, (EntityType<? extends Mob>)((EntityType)OccultismEntities.OTHERWORLD_BIRD_TYPE.get()), "otherworld_bird", 2232937, 7034564);
        RegistryEventHandler.registerSpawnEgg((IForgeRegistry<Item>)registry, (EntityType<? extends Mob>)((EntityType)OccultismEntities.GREEDY_FAMILIAR_TYPE.get()), "familiar_greedy", 5544207, 7491621);
        RegistryEventHandler.registerSpawnEgg((IForgeRegistry<Item>)registry, (EntityType<? extends Mob>)((EntityType)OccultismEntities.BAT_FAMILIAR_TYPE.get()), "familiar_bat", 0x434343, 14325214);
        RegistryEventHandler.registerSpawnEgg((IForgeRegistry<Item>)registry, (EntityType<? extends Mob>)((EntityType)OccultismEntities.DEER_FAMILIAR_TYPE.get()), "familiar_deer", 13206334, 0xFFFDF2);
        RegistryEventHandler.registerSpawnEgg((IForgeRegistry<Item>)registry, (EntityType<? extends Mob>)((EntityType)OccultismEntities.CTHULHU_FAMILIAR_TYPE.get()), "familiar_cthulhu", 52674, 4908992);
        RegistryEventHandler.registerSpawnEgg((IForgeRegistry<Item>)registry, (EntityType<? extends Mob>)((EntityType)OccultismEntities.DEVIL_FAMILIAR_TYPE.get()), "familiar_devil", 15921367, 10493213);
        RegistryEventHandler.registerSpawnEgg((IForgeRegistry<Item>)registry, (EntityType<? extends Mob>)((EntityType)OccultismEntities.DRAGON_FAMILIAR_TYPE.get()), "familiar_dragon", 1603599, 7783547);
        RegistryEventHandler.registerSpawnEgg((IForgeRegistry<Item>)registry, (EntityType<? extends Mob>)((EntityType)OccultismEntities.BLACKSMITH_FAMILIAR_TYPE.get()), "familiar_blacksmith", 441444, 0x2B2B2B);
        RegistryEventHandler.registerSpawnEgg((IForgeRegistry<Item>)registry, (EntityType<? extends Mob>)((EntityType)OccultismEntities.GUARDIAN_FAMILIAR_TYPE.get()), "familiar_guardian", 0x787878, 0x515151);
        RegistryEventHandler.registerSpawnEgg((IForgeRegistry<Item>)registry, (EntityType<? extends Mob>)((EntityType)OccultismEntities.HEADLESS_FAMILIAR_TYPE.get()), "familiar_headless", 787974, 14579968);
        RegistryEventHandler.registerSpawnEgg((IForgeRegistry<Item>)registry, (EntityType<? extends Mob>)((EntityType)OccultismEntities.CHIMERA_FAMILIAR_TYPE.get()), "familiar_chimera", 13599809, 4094242);
        RegistryEventHandler.registerSpawnEgg((IForgeRegistry<Item>)registry, (EntityType<? extends Mob>)((EntityType)OccultismEntities.GOAT_FAMILIAR_TYPE.get()), "familiar_goat", 0xE2E2E2, 986894);
        RegistryEventHandler.registerSpawnEgg((IForgeRegistry<Item>)registry, (EntityType<? extends Mob>)((EntityType)OccultismEntities.SHUB_NIGGURATH_FAMILIAR_TYPE.get()), "familiar_shub_niggurath", 3549238, 5851706);
        RegistryEventHandler.registerSpawnEgg((IForgeRegistry<Item>)registry, (EntityType<? extends Mob>)((EntityType)OccultismEntities.BEHOLDER_FAMILIAR_TYPE.get()), "familiar_beholder", 3410441, 0xFFFBFF);
        RegistryEventHandler.registerSpawnEgg((IForgeRegistry<Item>)registry, (EntityType<? extends Mob>)((EntityType)OccultismEntities.FAIRY_FAMILIAR_TYPE.get()), "familiar_fairy", 12412748, 13412502);
        RegistryEventHandler.registerSpawnEgg((IForgeRegistry<Item>)registry, (EntityType<? extends Mob>)((EntityType)OccultismEntities.MUMMY_FAMILIAR_TYPE.get()), "familiar_mummy", 13350762, 14734499);
        RegistryEventHandler.registerSpawnEgg((IForgeRegistry<Item>)registry, (EntityType<? extends Mob>)((EntityType)OccultismEntities.BEAVER_FAMILIAR_TYPE.get()), "familiar_beaver", 8538667, 14522739);
        Occultism.LOGGER.info("Registered SpawnEggItems");
        ComposterBlock.f_51914_.put((Object)((ItemLike)OccultismItems.DATURA_SEEDS.get()), 0.3f);
        ComposterBlock.f_51914_.put((Object)((LeavesBlock)OccultismBlocks.OTHERWORLD_LEAVES.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((OtherworldLeavesNaturalBlock)OccultismBlocks.OTHERWORLD_LEAVES_NATURAL.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((OtherworldSaplingBlock)OccultismBlocks.OTHERWORLD_SAPLING.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((OtherworldSaplingNaturalBlock)OccultismBlocks.OTHERWORLD_SAPLING_NATURAL.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)OccultismItems.DATURA.get()), 0.65f);
        Occultism.LOGGER.info("Registered compostable Items");
    }

    public static void registerSpawnEgg(IForgeRegistry<Item> registry, EntityType<? extends Mob> entityType, String name, int primaryColor, int secondaryColor) {
        SpawnEggItem spawnEggItem = new SpawnEggItem(entityType, primaryColor, secondaryColor, new Item.Properties().m_41491_(Occultism.ITEM_GROUP));
        spawnEggItem.setRegistryName(StaticUtil.modLoc("spawn_egg/" + name));
        registry.register((IForgeRegistryEntry)spawnEggItem);
    }

    @SubscribeEvent
    public static void onRegisterGlobalLootModifierSerializer(RegistryEvent.Register<GlobalLootModifierSerializer<?>> event) {
        event.getRegistry().register((IForgeRegistryEntry)new AddItemModifier.Serializer().setRegistryName(StaticUtil.modLoc("add_item")));
    }
}

