/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.integration.jei.recipes;

import com.github.klikli_dev.occultism.common.ritual.pentacle.Pentacle;
import com.github.klikli_dev.occultism.common.ritual.pentacle.PentacleManager;
import com.github.klikli_dev.occultism.crafting.recipe.RitualRecipe;
import com.github.klikli_dev.occultism.registry.OccultismBlocks;
import com.github.klikli_dev.occultism.registry.OccultismItems;
import com.github.klikli_dev.occultism.registry.OccultismRecipes;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class RitualRecipeCategory
implements IRecipeCategory<RitualRecipe> {
    private final IDrawable background;
    private final IDrawable arrow;
    private final Component localizedName;
    private final String pentacle;
    private final ItemStack goldenSacrificialBowl = new ItemStack((ItemLike)OccultismBlocks.GOLDEN_SACRIFICIAL_BOWL.get());
    private final ItemStack sacrificialBowl = new ItemStack((ItemLike)OccultismBlocks.SACRIFICIAL_BOWL.get());
    private final int iconWidth = 16;
    private final int ritualCenterX;
    private final int ritualCenterY;
    private int recipeOutputOffsetX = 50;

    public RitualRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(168, 120);
        this.ritualCenterX = this.background.getWidth() / 2 - this.iconWidth / 2 - 30;
        this.ritualCenterY = this.background.getHeight() / 2 - this.iconWidth / 2 + 20;
        this.localizedName = new TranslatableComponent("occultism.jei.ritual");
        this.pentacle = I18n.m_118938_((String)"occultism.jei.pentacle", (Object[])new Object[0]);
        this.goldenSacrificialBowl.m_41784_().m_128379_("RenderFull", true);
        this.sacrificialBowl.m_41784_().m_128379_("RenderFull", true);
        this.arrow = guiHelper.createDrawable(new ResourceLocation("occultism", "textures/gui/jei/arrow.png"), 0, 0, 64, 46);
    }

    public ResourceLocation getUid() {
        return OccultismRecipes.RITUAL.getId();
    }

    public Class<? extends RitualRecipe> getRecipeClass() {
        return RitualRecipe.class;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return null;
    }

    public void setIngredients(RitualRecipe recipe, IIngredients ingredients) {
        Stream<Ingredient> ingredientStream = Stream.concat(Stream.of(recipe.getActivationItem()), recipe.m_7527_().stream());
        if (recipe.requiresItemUse()) {
            ingredientStream = Stream.concat(Stream.of(recipe.getItemToUse()), ingredientStream);
        }
        ingredients.setInputIngredients(ingredientStream.collect(Collectors.toList()));
        ingredients.setOutputs(VanillaTypes.ITEM, Stream.of(recipe.m_8043_(), recipe.getRitualDummy()).collect(Collectors.toList()));
    }

    public void setRecipe(IRecipeLayout recipeLayout, RitualRecipe recipe, IIngredients ingredients) {
        int index = 0;
        this.recipeOutputOffsetX = 75;
        int currentIngredient = 0;
        List itemToUse = new ArrayList();
        if (recipe.requiresItemUse()) {
            itemToUse = (List)ingredients.getInputs(VanillaTypes.ITEM).get(currentIngredient++);
        }
        List activationItem = (List)ingredients.getInputs(VanillaTypes.ITEM).get(currentIngredient++);
        List inputItems = ingredients.getInputs(VanillaTypes.ITEM).stream().skip(currentIngredient).collect(Collectors.toList());
        recipeLayout.getItemStacks().init(index, true, this.ritualCenterX, this.ritualCenterY - 5);
        recipeLayout.getItemStacks().set(index, activationItem);
        recipeLayout.getItemStacks().init(++index, false, this.ritualCenterX, this.ritualCenterY);
        recipeLayout.getItemStacks().set(index, this.goldenSacrificialBowl);
        ++index;
        int sacrificialCircleRadius = 30;
        int sacricialBowlPaddingVertical = 20;
        int sacricialBowlPaddingHorizontal = 15;
        List sacrificialBowlPosition = Stream.of(new Vec3i(this.ritualCenterX, this.ritualCenterY - sacrificialCircleRadius, 0), new Vec3i(this.ritualCenterX + sacrificialCircleRadius, this.ritualCenterY, 0), new Vec3i(this.ritualCenterX, this.ritualCenterY + sacrificialCircleRadius, 0), new Vec3i(this.ritualCenterX - sacrificialCircleRadius, this.ritualCenterY, 0), new Vec3i(this.ritualCenterX + sacricialBowlPaddingHorizontal, this.ritualCenterY - sacrificialCircleRadius, 0), new Vec3i(this.ritualCenterX + sacrificialCircleRadius, this.ritualCenterY - sacricialBowlPaddingVertical, 0), new Vec3i(this.ritualCenterX - sacricialBowlPaddingHorizontal, this.ritualCenterY + sacrificialCircleRadius, 0), new Vec3i(this.ritualCenterX - sacrificialCircleRadius, this.ritualCenterY + sacricialBowlPaddingVertical, 0), new Vec3i(this.ritualCenterX - sacricialBowlPaddingHorizontal, this.ritualCenterY - sacrificialCircleRadius, 0), new Vec3i(this.ritualCenterX + sacrificialCircleRadius, this.ritualCenterY + sacricialBowlPaddingVertical, 0), new Vec3i(this.ritualCenterX + sacricialBowlPaddingHorizontal, this.ritualCenterY + sacrificialCircleRadius, 0), new Vec3i(this.ritualCenterX - sacrificialCircleRadius, this.ritualCenterY - sacricialBowlPaddingVertical, 0)).collect(Collectors.toList());
        for (int i = 0; i < inputItems.size(); ++i) {
            Vec3i pos = (Vec3i)sacrificialBowlPosition.get(i);
            recipeLayout.getItemStacks().init(index, true, pos.m_123341_(), pos.m_123342_() - 5);
            recipeLayout.getItemStacks().set(index, (List)inputItems.get(i));
            recipeLayout.getItemStacks().init(++index, false, pos.m_123341_(), pos.m_123342_());
            recipeLayout.getItemStacks().set(index, this.sacrificialBowl);
            ++index;
        }
        if (recipe.m_8043_().m_41720_() != OccultismItems.JEI_DUMMY_NONE.get()) {
            recipeLayout.getItemStacks().init(index, false, this.ritualCenterX + this.recipeOutputOffsetX, this.ritualCenterY - 5);
            recipeLayout.getItemStacks().set(index, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
            ++index;
        } else {
            recipeLayout.getItemStacks().init(index, false, this.ritualCenterX + this.recipeOutputOffsetX, this.ritualCenterY - 5);
            recipeLayout.getItemStacks().set(index, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(1));
            ++index;
        }
        recipeLayout.getItemStacks().init(index, false, this.ritualCenterX + this.recipeOutputOffsetX, this.ritualCenterY);
        recipeLayout.getItemStacks().set(index, this.goldenSacrificialBowl);
        recipeLayout.getItemStacks().init(++index, false, 0, 0);
        recipeLayout.getItemStacks().set(index, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(1));
        ++index;
        if (recipe.requiresItemUse()) {
            int infotextY = 0;
            if (recipe.requiresSacrifice()) {
                infotextY += 10;
            }
            int itemToUseY = (infotextY += 10) - 5;
            int itemToUseX = this.getStringCenteredMaxX(Minecraft.m_91087_().f_91062_, (Component)new TranslatableComponent("jei.occultism.item_to_use"), 84, infotextY);
            recipeLayout.getItemStacks().init(index, false, itemToUseX, itemToUseY);
            recipeLayout.getItemStacks().set(index, itemToUse);
            ++index;
        }
    }

    public void draw(RitualRecipe recipe, PoseStack poseStack, double mouseX, double mouseY) {
        RenderSystem.m_69478_();
        this.arrow.draw(poseStack, this.ritualCenterX + this.recipeOutputOffsetX - 20, this.ritualCenterY);
        RenderSystem.m_69461_();
        Pentacle pentacle = PentacleManager.get(recipe.getPentacleId());
        if (pentacle != null) {
            this.drawStringCentered(poseStack, Minecraft.m_91087_().f_91062_, (Component)new TranslatableComponent(pentacle.getDescriptionId()), 84, 0);
        } else {
            this.drawStringCentered(poseStack, Minecraft.m_91087_().f_91062_, (Component)new TranslatableComponent("jei.occultism.error.pentacle_not_loaded"), 84, 0);
        }
        int infotextY = 0;
        if (recipe.requiresSacrifice()) {
            this.drawStringCentered(poseStack, Minecraft.m_91087_().f_91062_, (Component)new TranslatableComponent("jei.occultism.sacrifice", new Object[]{new TranslatableComponent(recipe.getEntityToSacrificeDisplayName())}), 84, infotextY += 10);
        }
        if (recipe.requiresItemUse()) {
            this.drawStringCentered(poseStack, Minecraft.m_91087_().f_91062_, (Component)new TranslatableComponent("jei.occultism.item_to_use"), 84, infotextY += 10);
        }
        if (recipe.getEntityToSummon() != null) {
            this.drawStringCentered(poseStack, Minecraft.m_91087_().f_91062_, (Component)new TranslatableComponent("jei.occultism.summon", new Object[]{new TranslatableComponent(recipe.getEntityToSummon().m_20675_())}), 84, infotextY += 10);
        }
        if (recipe.getSpiritJobType() != null) {
            this.drawStringCentered(poseStack, Minecraft.m_91087_().f_91062_, (Component)new TranslatableComponent("jei.occultism.job", new Object[]{new TranslatableComponent("job." + recipe.getSpiritJobType().toString().replace(":", "."))}), 84, infotextY += 10);
        }
    }

    protected int getStringCenteredMaxX(Font font, Component text, int x, int y) {
        int width = font.m_92852_((FormattedText)text);
        int actualX = (int)((float)x - (float)width / 2.0f);
        return actualX + width;
    }

    protected void drawStringCentered(PoseStack poseStack, Font font, Component text, int x, int y) {
        font.m_92889_(poseStack, text, (float)x - (float)font.m_92852_((FormattedText)text) / 2.0f, (float)y, 0);
    }
}

