/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.registry;

import com.github.klikli_dev.occultism.common.block.CandleBlock;
import com.github.klikli_dev.occultism.common.block.ChalkGlyphBlock;
import com.github.klikli_dev.occultism.common.block.DimensionalMineshaftBlock;
import com.github.klikli_dev.occultism.common.block.GoldenSacrificialBowlBlock;
import com.github.klikli_dev.occultism.common.block.NonPathfindableBlock;
import com.github.klikli_dev.occultism.common.block.SacrificialBowlBlock;
import com.github.klikli_dev.occultism.common.block.SpiritAttunedCrystalBlock;
import com.github.klikli_dev.occultism.common.block.SpiritFireBlock;
import com.github.klikli_dev.occultism.common.block.SpiritTorchBlock;
import com.github.klikli_dev.occultism.common.block.SpiritWallTorchBlock;
import com.github.klikli_dev.occultism.common.block.crops.ReplantableCropsBlock;
import com.github.klikli_dev.occultism.common.block.otherworld.IesniumOreNaturalBlock;
import com.github.klikli_dev.occultism.common.block.otherworld.OtherstoneNaturalBlock;
import com.github.klikli_dev.occultism.common.block.otherworld.OtherworldLeavesNaturalBlock;
import com.github.klikli_dev.occultism.common.block.otherworld.OtherworldLogNaturalBlock;
import com.github.klikli_dev.occultism.common.block.otherworld.OtherworldSaplingBlock;
import com.github.klikli_dev.occultism.common.block.otherworld.OtherworldSaplingNaturalBlock;
import com.github.klikli_dev.occultism.common.block.storage.StableWormholeBlock;
import com.github.klikli_dev.occultism.common.block.storage.StorageControllerBlock;
import com.github.klikli_dev.occultism.common.block.storage.StorageStabilizerBlock;
import com.github.klikli_dev.occultism.common.entity.CthulhuFamiliarEntity;
import com.github.klikli_dev.occultism.common.entity.FamiliarEntity;
import com.github.klikli_dev.occultism.common.level.tree.OtherworldNaturalTreeGrower;
import com.github.klikli_dev.occultism.common.level.tree.OtherworldTreeGrower;
import com.github.klikli_dev.occultism.registry.OccultismItems;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class OccultismBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"occultism");
    public static final Map<ResourceLocation, BlockDataGenSettings> BLOCK_DATA_GEN_SETTINGS = new HashMap<ResourceLocation, BlockDataGenSettings>();
    public static final RegistryObject<SpiritFireBlock> SPIRIT_FIRE = OccultismBlocks.register("spirit_fire", () -> new SpiritFireBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76309_, (MaterialColor)MaterialColor.f_76402_).m_60910_().m_60977_().m_60913_(0.0f, 0.0f).m_60953_(state -> 12).m_60918_(SoundType.f_56745_)), false, LootTableType.EMPTY);
    public static final RegistryObject<Block> LIGHTED_AIR = OccultismBlocks.register("lighted_air", () -> new AirBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76296_).m_60910_().m_60996_().m_60993_().m_60953_(s -> 15).m_60977_()){

        public void m_7458_(BlockState pState, ServerLevel pLevel, BlockPos pPos, Random pRandom) {
            if (pLevel.m_6443_(CthulhuFamiliarEntity.class, new AABB(pPos), FamiliarEntity::hasBlacksmithUpgrade).isEmpty()) {
                pLevel.m_46597_(pPos, Blocks.f_50016_.m_49966_());
            }
        }
    });
    public static final Material GLYPH_MATERIAL = new Material(MaterialColor.f_76398_, false, false, false, true, false, true, PushReaction.DESTROY);
    public static final BlockBehaviour.Properties GLYPH_PROPERTIES = BlockBehaviour.Properties.m_60939_((Material)GLYPH_MATERIAL).m_60918_(SoundType.f_56745_).m_60910_().m_60913_(5.0f, 30.0f);
    public static final RegistryObject<ChalkGlyphBlock> CHALK_GLYPH_WHITE = OccultismBlocks.register("chalk_glyph_white", () -> new ChalkGlyphBlock(GLYPH_PROPERTIES, 0xFFFFFF, () -> (Item)OccultismItems.CHALK_WHITE.get()), false, LootTableType.EMPTY);
    public static final RegistryObject<ChalkGlyphBlock> CHALK_GLYPH_GOLD = OccultismBlocks.register("chalk_glyph_gold", () -> new ChalkGlyphBlock(GLYPH_PROPERTIES, 15783680, () -> (Item)OccultismItems.CHALK_GOLD.get()), false, LootTableType.EMPTY);
    public static final RegistryObject<ChalkGlyphBlock> CHALK_GLYPH_PURPLE = OccultismBlocks.register("chalk_glyph_purple", () -> new ChalkGlyphBlock(GLYPH_PROPERTIES, 10224531, () -> (Item)OccultismItems.CHALK_PURPLE.get()), false, LootTableType.EMPTY);
    public static final RegistryObject<ChalkGlyphBlock> CHALK_GLYPH_RED = OccultismBlocks.register("chalk_glyph_red", () -> new ChalkGlyphBlock(GLYPH_PROPERTIES, 0xCC0101, () -> (Item)OccultismItems.CHALK_RED.get()), false, LootTableType.EMPTY);
    public static final RegistryObject<Block> OTHERSTONE = OccultismBlocks.register("otherstone", () -> new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60918_(SoundType.f_56742_).m_60913_(1.5f, 30.0f)));
    public static final RegistryObject<SlabBlock> OTHERSTONE_SLAB = OccultismBlocks.register("otherstone_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)OTHERSTONE.get()))));
    public static final RegistryObject<Block> OTHERSTONE_PEDESTAL = OccultismBlocks.register("otherstone_pedestal", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)OTHERSTONE.get()))));
    public static final RegistryObject<Block> STORAGE_CONTROLLER_BASE = OccultismBlocks.register("storage_controller_base", () -> new NonPathfindableBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)OTHERSTONE.get())).m_60955_()));
    public static final RegistryObject<OtherstoneNaturalBlock> OTHERSTONE_NATURAL = OccultismBlocks.register("otherstone_natural", () -> new OtherstoneNaturalBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60918_(SoundType.f_56742_).m_60913_(1.5f, 30.0f)), true, LootTableType.OTHERWORLD_BLOCK);
    public static final RegistryObject<Block> OTHERWORLD_LOG = OccultismBlocks.register("otherworld_log", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60947_((Material)Material.f_76320_, state -> state.m_61143_((Property)RotatedPillarBlock.f_55923_) == Direction.Axis.Y ? MaterialColor.f_76411_ : MaterialColor.f_76422_).m_60978_(2.0f).m_60918_(SoundType.f_56736_).m_60978_(2.0f)));
    public static final RegistryObject<Block> OTHERWORLD_LOG_NATURAL = OccultismBlocks.register("otherworld_log_natural", () -> new OtherworldLogNaturalBlock(BlockBehaviour.Properties.m_60947_((Material)Material.f_76320_, state -> state.m_61143_((Property)RotatedPillarBlock.f_55923_) == Direction.Axis.Y ? MaterialColor.f_76411_ : MaterialColor.f_76422_).m_60978_(2.0f)), true, LootTableType.OTHERWORLD_BLOCK);
    public static final RegistryObject<LeavesBlock> OTHERWORLD_LEAVES = OccultismBlocks.register("otherworld_leaves", () -> new LeavesBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76274_).m_60918_(SoundType.f_56740_).m_60978_(0.2f).m_60977_().m_60955_()), true, LootTableType.CUSTOM);
    public static final RegistryObject<OtherworldLeavesNaturalBlock> OTHERWORLD_LEAVES_NATURAL = OccultismBlocks.register("otherworld_leaves_natural", () -> new OtherworldLeavesNaturalBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76274_).m_60918_(SoundType.f_56740_).m_60978_(0.2f).m_60977_().m_60955_()), true, LootTableType.CUSTOM);
    public static final RegistryObject<OtherworldSaplingBlock> OTHERWORLD_SAPLING = OccultismBlocks.register("otherworld_sapling", () -> new OtherworldSaplingBlock(new OtherworldTreeGrower(), BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60918_(SoundType.f_56740_).m_60978_(0.0f).m_60977_().m_60910_()));
    public static final RegistryObject<OtherworldSaplingNaturalBlock> OTHERWORLD_SAPLING_NATURAL = OccultismBlocks.register("otherworld_sapling_natural", () -> new OtherworldSaplingNaturalBlock(new OtherworldNaturalTreeGrower(), BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60918_(SoundType.f_56740_).m_60978_(0.0f).m_60977_().m_60910_()), false, LootTableType.OTHERWORLD_BLOCK);
    public static final RegistryObject<Block> SILVER_ORE = OccultismBlocks.register("silver_ore", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49996_)), true, LootTableType.CUSTOM);
    public static final RegistryObject<Block> SILVER_ORE_DEEPSLATE = OccultismBlocks.register("silver_ore_deepslate", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49996_)), true, LootTableType.CUSTOM);
    public static final RegistryObject<Block> IESNIUM_ORE = OccultismBlocks.register("iesnium_ore", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49996_)), true, LootTableType.CUSTOM);
    public static final RegistryObject<IesniumOreNaturalBlock> IESNIUM_ORE_NATURAL = OccultismBlocks.register("iesnium_ore_natural", () -> new IesniumOreNaturalBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49996_)), true, LootTableType.OTHERWORLD_BLOCK);
    public static final RegistryObject<Block> SILVER_BLOCK = OccultismBlocks.register("silver_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_)));
    public static final RegistryObject<Block> IESNIUM_BLOCK = OccultismBlocks.register("iesnium_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_)));
    public static final RegistryObject<CandleBlock> CANDLE_WHITE = OccultismBlocks.register("candle_white", () -> new CandleBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60918_(SoundType.f_56745_).m_60910_().m_60913_(0.1f, 0.0f).m_60953_(state -> 12)));
    public static final RegistryObject<SpiritAttunedCrystalBlock> SPIRIT_ATTUNED_CRYSTAL = OccultismBlocks.register("spirit_attuned_crystal", () -> new SpiritAttunedCrystalBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60918_(SoundType.f_56742_).m_60955_().m_60913_(1.5f, 30.0f).m_60953_(state -> 8)));
    public static final RegistryObject<SacrificialBowlBlock> SACRIFICIAL_BOWL = OccultismBlocks.register("sacrificial_bowl", () -> new SacrificialBowlBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60918_(SoundType.f_56742_).m_60913_(1.5f, 30.0f).m_60955_()));
    public static final RegistryObject<GoldenSacrificialBowlBlock> GOLDEN_SACRIFICIAL_BOWL = OccultismBlocks.register("golden_sacrificial_bowl", () -> new GoldenSacrificialBowlBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60918_(SoundType.f_56742_).m_60913_(1.5f, 30.0f).m_60955_()));
    public static final RegistryObject<StorageControllerBlock> STORAGE_CONTROLLER = OccultismBlocks.register("storage_controller", () -> new StorageControllerBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60918_(SoundType.f_56742_).m_60913_(5.0f, 100.0f).m_60955_()), true, LootTableType.EMPTY);
    public static final RegistryObject<StorageStabilizerBlock> STORAGE_STABILIZER_TIER1 = OccultismBlocks.register("storage_stabilizer_tier1", () -> new StorageStabilizerBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60918_(SoundType.f_56742_).m_60913_(1.5f, 30.0f).m_60955_()));
    public static final RegistryObject<StorageStabilizerBlock> STORAGE_STABILIZER_TIER2 = OccultismBlocks.register("storage_stabilizer_tier2", () -> new StorageStabilizerBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60918_(SoundType.f_56742_).m_60913_(1.5f, 30.0f).m_60955_()));
    public static final RegistryObject<StorageStabilizerBlock> STORAGE_STABILIZER_TIER3 = OccultismBlocks.register("storage_stabilizer_tier3", () -> new StorageStabilizerBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60918_(SoundType.f_56742_).m_60913_(1.5f, 30.0f).m_60955_()));
    public static final RegistryObject<StorageStabilizerBlock> STORAGE_STABILIZER_TIER4 = OccultismBlocks.register("storage_stabilizer_tier4", () -> new StorageStabilizerBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60918_(SoundType.f_56742_).m_60913_(1.5f, 30.0f).m_60955_()));
    public static final RegistryObject<StableWormholeBlock> STABLE_WORMHOLE = OccultismBlocks.register("stable_wormhole", () -> new StableWormholeBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60918_(SoundType.f_56742_).m_60910_().m_60913_(2.0f, 2.0f).m_60955_()), false, LootTableType.EMPTY);
    public static final RegistryObject<DimensionalMineshaftBlock> DIMENSIONAL_MINESHAFT = OccultismBlocks.register("dimensional_mineshaft", () -> new DimensionalMineshaftBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60918_(SoundType.f_56742_).m_60913_(1.5f, 30.0f).m_60955_()));
    public static final RegistryObject<ReplantableCropsBlock> DATURA = OccultismBlocks.register("datura", () -> new ReplantableCropsBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60918_(SoundType.f_56758_).m_60910_().m_60977_().m_60913_(0.0f, 0.0f), () -> (Item)OccultismItems.DATURA_SEEDS.get(), () -> (Item)OccultismItems.DATURA.get()), false, LootTableType.REPLANTABLE_CROP);
    public static final RegistryObject<Block> SKELETON_SKULL_DUMMY = OccultismBlocks.register("skeleton_skull_dummy", () -> new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60978_(1.0f)), false);
    public static final RegistryObject<Block> WITHER_SKELETON_SKULL_DUMMY = OccultismBlocks.register("wither_skeleton_skull_dummy", () -> new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60978_(1.0f)), false);
    public static final RegistryObject<Block> SPIRIT_LANTERN = OccultismBlocks.register("spirit_lantern", () -> new LanternBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60999_().m_60978_(3.5f).m_60918_(SoundType.f_56762_).m_60953_(state -> 10).m_60955_()));
    public static final RegistryObject<Block> SPIRIT_CAMPFIRE = OccultismBlocks.register("spirit_campfire", () -> new CampfireBlock(false, 2, BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76370_).m_60978_(2.0f).m_60918_(SoundType.f_56736_).m_60953_(state -> 10).m_60955_()));
    public static final RegistryObject<Block> SPIRIT_TORCH = OccultismBlocks.register("spirit_torch", () -> new SpiritTorchBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60910_().m_60966_().m_60953_(state -> 10).m_60918_(SoundType.f_56736_)), false);
    public static final RegistryObject<Block> SPIRIT_WALL_TORCH = OccultismBlocks.register("spirit_wall_torch", () -> new SpiritWallTorchBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60910_().m_60966_().m_60953_(state -> 10).m_60918_(SoundType.f_56736_).lootFrom(SPIRIT_TORCH)), false);

    public static <I extends Block> RegistryObject<I> register(String name, Supplier<? extends I> sup) {
        return OccultismBlocks.register(name, sup, true);
    }

    public static <I extends Block> RegistryObject<I> register(String name, Supplier<? extends I> sup, boolean generateDefaultBlockItem) {
        return OccultismBlocks.register(name, sup, generateDefaultBlockItem, LootTableType.DROP_SELF);
    }

    public static <I extends Block> RegistryObject<I> register(String name, Supplier<? extends I> sup, boolean generateDefaultBlockItem, LootTableType lootTableType) {
        RegistryObject object = BLOCKS.register(name, sup);
        BLOCK_DATA_GEN_SETTINGS.put(object.getId(), new BlockDataGenSettings(generateDefaultBlockItem, lootTableType));
        return object;
    }

    public static enum LootTableType {
        EMPTY,
        DROP_SELF,
        REPLANTABLE_CROP,
        OTHERWORLD_BLOCK,
        CUSTOM;

    }

    public static class BlockDataGenSettings {
        public boolean generateDefaultBlockItem;
        public LootTableType lootTableType;

        public BlockDataGenSettings(boolean generateDefaultBlockItem, LootTableType lootTableType) {
            this.generateDefaultBlockItem = generateDefaultBlockItem;
            this.lootTableType = lootTableType;
        }
    }
}

