/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.util;

import com.github.klikli_dev.occultism.common.capability.DoubleJumpCapability;
import com.github.klikli_dev.occultism.common.effect.DoubleJumpEffect;
import com.github.klikli_dev.occultism.registry.OccultismCapabilities;
import com.github.klikli_dev.occultism.registry.OccultismTags;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;

public class MovementUtil {
    public static boolean doubleJump(Player player) {
        if (!MovementUtil.allowDoubleJump(player)) {
            return false;
        }
        LazyOptional doubleJumpCapability = player.getCapability(OccultismCapabilities.DOUBLE_JUMP);
        int jumps = doubleJumpCapability.map(DoubleJumpCapability::getJumps).orElse(Integer.MAX_VALUE);
        if (jumps < DoubleJumpEffect.getMaxJumps(player)) {
            player.m_6135_();
            doubleJumpCapability.ifPresent(DoubleJumpCapability::addJump);
            return true;
        }
        return false;
    }

    public static boolean allowDoubleJump(Player player) {
        boolean swimming;
        boolean bl = swimming = player.m_20069_() || player.m_20077_();
        if (player.m_20096_() || player.m_20159_() || player.m_150110_().f_35935_ || swimming) {
            return false;
        }
        ItemStack itemstack = player.m_6844_(EquipmentSlot.CHEST);
        return !OccultismTags.ELYTRA.m_8110_((Object)itemstack.m_41720_()) || itemstack.m_41773_() > 0 && !ElytraItem.m_41140_((ItemStack)itemstack);
    }
}

