/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair.api;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import mod.crend.dynamiccrosshair.DynamicCrosshair;
import mod.crend.dynamiccrosshair.api.ApiList;
import mod.crend.dynamiccrosshair.api.DynamicCrosshairApi;
import mod.crend.dynamiccrosshair.component.Crosshair;
import mod.crend.dynamiccrosshair.component.InvalidContextState;
import mod.crend.dynamiccrosshair.config.CrosshairPolicy;
import mod.crend.dynamiccrosshair.mixin.IBlockItemMixin;
import mod.crend.dynamiccrosshair.mixin.IItemMixin;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3610;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.checkerframework.checker.nullness.qual.NonNull;

public class CrosshairContext {
    public final @NonNull class_638 world;
    public final @NonNull class_746 player;
    public @NonNull class_239 hitResult;
    private boolean withBlock = false;
    private class_2338 blockPos = null;
    private class_2680 blockState = null;
    private class_2586 blockEntity = null;
    private boolean withEntity = false;
    private class_1297 entity = null;
    private class_1268 hand;
    private class_1799 itemStackMainHand = null;
    private class_1799 itemStackOffHand = null;
    private ApiList apiList = null;

    public CrosshairContext() {
        assert (class_310.method_1551().field_1687 != null);
        assert (class_310.method_1551().field_1724 != null);
        assert (class_310.method_1551().field_1765 != null);
        this.world = class_310.method_1551().field_1687;
        this.player = class_310.method_1551().field_1724;
        this.hitResult = class_310.method_1551().field_1765;
        this.hand = class_1268.field_5808;
        this.invalidateHitResult();
    }

    public void invalidateHitResult() {
        assert (class_310.method_1551().field_1765 != null);
        this.hitResult = class_310.method_1551().field_1765;
        this.withBlock = false;
        this.blockPos = null;
        this.blockState = null;
        this.blockEntity = null;
        this.withEntity = false;
        this.entity = null;
        this.apiList = null;
        switch (this.hitResult.method_17783()) {
            case field_1332: {
                class_3965 blockHitResult = (class_3965)this.hitResult;
                this.withBlock = true;
                this.blockPos = blockHitResult.method_17777();
                break;
            }
            case field_1331: {
                class_3966 entityHitResult = (class_3966)this.hitResult;
                this.withEntity = true;
                this.entity = entityHitResult.method_17782();
            }
        }
    }

    public void invalidateItem(class_1268 hand) {
        switch (hand) {
            case field_5808: {
                this.itemStackMainHand = null;
                break;
            }
            case field_5810: {
                this.itemStackOffHand = null;
            }
        }
    }

    public boolean isTargeting() {
        return this.hitResult.method_17783() != class_239.class_240.field_1333;
    }

    public boolean isEmptyHanded() {
        return this.player.method_6047().method_7960() && this.player.method_6079().method_7960();
    }

    public boolean shouldInteract() {
        return !this.player.method_21823() || this.isEmptyHanded();
    }

    public boolean isWithBlock() {
        return this.withBlock;
    }

    public class_2338 getBlockPos() {
        return this.blockPos;
    }

    public class_2680 getBlockState() {
        if (!this.withBlock) {
            throw new InvalidContextState("Called getBlockState() without a targeted block!");
        }
        if (this.blockPos == null) {
            throw new InvalidContextState("In getBlockState(): blockPos is null despite targeted block!");
        }
        if (this.blockState == null) {
            this.blockState = this.world.method_8320(this.blockPos);
        }
        return this.blockState;
    }

    public class_2248 getBlock() {
        return this.getBlockState().method_26204();
    }

    public class_2586 getBlockEntity() {
        if (!this.withBlock) {
            throw new InvalidContextState("Called getBlockEntity() without a targeted block!");
        }
        if (this.blockPos == null) {
            throw new InvalidContextState("In getBlockEntity(): blockPos is null despite targeted block!");
        }
        if (this.blockEntity == null) {
            this.blockEntity = this.world.method_8321(this.blockPos);
        }
        return this.blockEntity;
    }

    public class_3610 getFluidState() {
        if (!this.withBlock) {
            throw new InvalidContextState("Called getFluidState() without a targeted block!");
        }
        if (this.blockPos == null) {
            throw new InvalidContextState("In getFluidState(): blockPos is null despite targeted block!");
        }
        return this.world.method_8316(this.blockPos);
    }

    public class_3965 raycastWithFluid(class_3959.class_242 fluidHandling) {
        return IItemMixin.invokeRaycast((class_1937)this.world, (class_1657)this.player, fluidHandling);
    }

    public class_3965 raycastWithFluid() {
        return this.raycastWithFluid(class_3959.class_242.field_1347);
    }

    public boolean isWithEntity() {
        return this.withEntity;
    }

    public class_1297 getEntity() {
        if (!this.withEntity) {
            throw new InvalidContextState("Called getEntity() without a targeted entity!");
        }
        if (this.entity == null) {
            throw new InvalidContextState("In getEntity(): entity is null despite targeted entity!");
        }
        return this.entity;
    }

    public class_1268 getHand() {
        return this.hand;
    }

    public void setHand(class_1268 hand) {
        this.invalidateItem(this.hand);
        this.hand = hand;
    }

    public boolean isMainHand() {
        return this.hand == class_1268.field_5808;
    }

    public boolean isOffHand() {
        return this.hand == class_1268.field_5810;
    }

    public class_1799 getItemStack() {
        class_1799 itemStack;
        switch (this.hand) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case field_5808: {
                class_1799 class_17992 = this.itemStackMainHand;
                break;
            }
            case field_5810: {
                class_1799 class_17992 = itemStack = this.itemStackOffHand;
            }
        }
        if (itemStack == null) {
            itemStack = this.player.method_5998(this.hand);
            switch (this.hand) {
                case field_5808: {
                    this.itemStackMainHand = itemStack;
                    break;
                }
                case field_5810: {
                    this.itemStackOffHand = itemStack;
                }
            }
        }
        return itemStack;
    }

    public class_1792 getItem() {
        return this.getItemStack().method_7909();
    }

    public boolean isActiveItem() {
        return this.player.method_6030().equals(this.getItemStack());
    }

    public boolean isCoolingDown() {
        return this.player.method_7357().method_7904(this.getItem());
    }

    public boolean canPlaceItemAsBlock() {
        class_1750 itemPlacementContext;
        if (!this.withBlock) {
            throw new InvalidContextState("Called canPlaceItemAsBlock() without a targeted block!");
        }
        IBlockItemMixin blockItem = (IBlockItemMixin)this.getItem();
        class_2680 blockState = blockItem.invokeGetPlacementState(itemPlacementContext = new class_1750((class_1657)this.player, this.hand, this.getItemStack(), (class_3965)this.hitResult));
        return blockState != null && blockItem.invokeCanPlace(itemPlacementContext, blockState);
    }

    public boolean canUseWeaponAsTool() {
        return this.isWithBlock() && DynamicCrosshair.config.dynamicCrosshairHoldingTool() != CrosshairPolicy.Disabled;
    }

    public Crosshair withItem(Function<class_1799, Crosshair> itemStackConsumer) {
        return itemStackConsumer.apply(this.getItemStack());
    }

    public Crosshair withBlock(BiFunction<class_1799, class_2680, Crosshair> blockConsumer) {
        if (this.withBlock) {
            return blockConsumer.apply(this.getItemStack(), this.getBlockState());
        }
        return null;
    }

    public Crosshair withBlock(Function<CrosshairContext, Crosshair> consumer) {
        if (this.withBlock) {
            return consumer.apply(this);
        }
        return null;
    }

    public void withBlock(Consumer<CrosshairContext> consumer) {
        if (this.withBlock) {
            consumer.accept(this);
        }
    }

    public Crosshair withEntity(BiFunction<class_1799, class_1297, Crosshair> entityConsumer) {
        if (this.withEntity) {
            return entityConsumer.apply(this.getItemStack(), this.getEntity());
        }
        return null;
    }

    public List<DynamicCrosshairApi> apis() {
        if (this.apiList == null) {
            this.apiList = new ApiList();
            this.apiList.add(this.getItemStack());
            if (this.isWithBlock()) {
                this.apiList.add(this.getBlockState());
            }
            if (this.isWithEntity()) {
                this.apiList.add(this.getEntity());
            }
        }
        return this.apiList.get();
    }
}

