/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair.component;

import java.util.LinkedList;
import java.util.List;
import mod.crend.dynamiccrosshair.DynamicCrosshair;
import mod.crend.dynamiccrosshair.component.CrosshairVariant;
import mod.crend.dynamiccrosshair.component.ModifierHit;
import mod.crend.dynamiccrosshair.component.ModifierUse;
import mod.crend.dynamiccrosshair.config.CrosshairModifier;
import mod.crend.dynamiccrosshair.config.CrosshairStyle;

public class Crosshair
implements Cloneable {
    public static final Crosshair NONE = new Crosshair();
    public static final Crosshair REGULAR = new Crosshair(CrosshairVariant.Regular);
    public static final Crosshair HOLDING_BLOCK = new Crosshair(CrosshairVariant.HoldingBlock).setFlag(Flag.FixedAll);
    public static final Crosshair MELEE_WEAPON = new Crosshair(CrosshairVariant.HoldingMeleeWeapon).setFlag(Flag.FixedStyle);
    public static final Crosshair RANGED_WEAPON = new Crosshair(CrosshairVariant.HoldingRangedWeapon).setFlag(Flag.FixedAll);
    public static final Crosshair THROWABLE = new Crosshair(CrosshairVariant.HoldingThrowable).setFlag(Flag.FixedAll);
    public static final Crosshair TOOL = new Crosshair(CrosshairVariant.HoldingTool).setFlag(Flag.FixedStyle);
    public static final Crosshair CORRECT_TOOL = new Crosshair(CrosshairVariant.HoldingTool, ModifierHit.CORRECT_TOOL).setFlag(Flag.FixedStyle, Flag.FixedModifierHit);
    public static final Crosshair INCORRECT_TOOL = new Crosshair(CrosshairVariant.HoldingTool, ModifierHit.INCORRECT_TOOL).setFlag(Flag.FixedStyle, Flag.FixedModifierHit);
    public static final Crosshair USE_ITEM = new Crosshair(ModifierUse.USE_ITEM).setFlag(Flag.FixedModifierUse);
    public static final Crosshair INTERACTABLE = new Crosshair(ModifierUse.INTERACTABLE).setFlag(Flag.FixedModifierUse);
    public static final Crosshair SHIELD = new Crosshair(ModifierUse.SHIELD).setFlag(Flag.FixedModifierUse);
    private CrosshairVariant variant = CrosshairVariant.NONE;
    private ModifierUse modifierUse = ModifierUse.NONE;
    private ModifierHit modifierHit = ModifierHit.NONE;
    private boolean lockStyle = false;
    private boolean lockModifierUse = false;
    private boolean lockModifierHit = false;
    boolean changed = false;

    public Crosshair() {
    }

    public Crosshair(CrosshairVariant variant) {
        this.setVariant(variant);
    }

    public Crosshair(ModifierUse modifierUse) {
        this.setModifierUse(modifierUse);
    }

    public Crosshair(ModifierHit modifierHit) {
        this.setModifierHit(modifierHit);
    }

    public Crosshair(CrosshairVariant holdingBlock, ModifierUse modifierUse) {
        this.setVariant(holdingBlock);
        this.setModifierUse(modifierUse);
    }

    public Crosshair(CrosshairVariant holdingBlock, ModifierHit modifierHit) {
        this.setVariant(holdingBlock);
        this.setModifierHit(modifierHit);
    }

    public boolean hasStyle() {
        return this.variant != CrosshairVariant.NONE;
    }

    public CrosshairStyle getCrosshairStyle() {
        return switch (this.variant) {
            default -> throw new IncompatibleClassChangeError();
            case CrosshairVariant.Regular, CrosshairVariant.NONE -> DynamicCrosshair.config.getCrosshairStyleRegular();
            case CrosshairVariant.OnBlock -> DynamicCrosshair.config.getCrosshairStyleOnBlock();
            case CrosshairVariant.OnEntity -> DynamicCrosshair.config.getCrosshairStyleOnEntity();
            case CrosshairVariant.HoldingBlock -> DynamicCrosshair.config.getCrosshairStyleHoldingBlock();
            case CrosshairVariant.HoldingTool -> DynamicCrosshair.config.getCrosshairStyleHoldingTool();
            case CrosshairVariant.HoldingMeleeWeapon -> DynamicCrosshair.config.getCrosshairStyleHoldingMeleeWeapon();
            case CrosshairVariant.HoldingRangedWeapon -> DynamicCrosshair.config.getCrosshairStyleHoldingRangedWeapon();
            case CrosshairVariant.HoldingThrowable -> DynamicCrosshair.config.getCrosshairStyleHoldingThrowable();
        };
    }

    public ModifierHit getModifierHit() {
        return this.modifierHit;
    }

    public ModifierUse getModifierUse() {
        return this.modifierUse;
    }

    public boolean isChanged() {
        return this.changed;
    }

    void setVariant(CrosshairVariant variant) {
        this.variant = variant;
        this.changed = true;
    }

    void setModifierHit(ModifierHit modifierHit) {
        this.modifierHit = modifierHit;
        this.changed = true;
    }

    void setModifierUse(ModifierUse modifierUse) {
        this.modifierUse = modifierUse;
        this.changed = true;
    }

    Crosshair setFlag(Flag flag) {
        switch (flag) {
            case FixedStyle: {
                this.lockStyle = true;
                break;
            }
            case FixedModifierUse: {
                this.lockModifierUse = true;
                break;
            }
            case FixedModifierHit: {
                this.lockModifierHit = true;
                break;
            }
            case FixedAll: {
                this.lockStyle = true;
                this.lockModifierUse = true;
                this.lockModifierHit = true;
            }
        }
        return this;
    }

    Crosshair setFlag(Flag ... flags) {
        for (Flag flag : flags) {
            this.setFlag(flag);
        }
        return this;
    }

    public Crosshair withFlag(Flag flag) {
        return this.clone().setFlag(flag);
    }

    public Crosshair withFlag(Flag ... flags) {
        return this.clone().setFlag(flags);
    }

    boolean updateFrom(Crosshair other) {
        if (other == null) {
            return false;
        }
        boolean ret = false;
        if (!this.lockStyle || other.variant == CrosshairVariant.HoldingTool) {
            if (other.variant != CrosshairVariant.NONE) {
                this.setVariant(other.variant);
                ret = true;
            }
            this.lockStyle = other.lockStyle;
        }
        if (!this.lockModifierHit) {
            if (other.modifierHit != ModifierHit.NONE) {
                this.setModifierHit(other.modifierHit);
                ret = true;
            }
            this.lockModifierHit = other.lockModifierHit;
        }
        if (!this.lockModifierUse) {
            if (other.modifierUse != ModifierUse.NONE) {
                this.setModifierUse(other.modifierUse);
                ret = true;
            }
            this.lockModifierUse = other.lockModifierUse;
        }
        return ret;
    }

    public static Crosshair combine(Crosshair one, Crosshair other) {
        if (one == null) {
            return other;
        }
        Crosshair combined = one.clone();
        combined.updateFrom(other);
        return combined;
    }

    public List<CrosshairModifier> getModifiers() {
        LinkedList<CrosshairModifier> modifiers = new LinkedList<CrosshairModifier>();
        switch (this.modifierHit) {
            case CORRECT_TOOL: {
                modifiers.add(DynamicCrosshair.config.getCrosshairModifierCorrectTool());
                break;
            }
            case INCORRECT_TOOL: {
                modifiers.add(DynamicCrosshair.config.getCrosshairModifierIncorrectTool());
            }
        }
        switch (this.modifierUse) {
            case USE_ITEM: {
                modifiers.add(DynamicCrosshair.config.getCrosshairModifierUsableItem());
                break;
            }
            case INTERACTABLE: {
                modifiers.add(DynamicCrosshair.config.getCrosshairModifierInteractable());
                break;
            }
            case SHIELD: {
                modifiers.add(DynamicCrosshair.config.getCrosshairModifierShield());
            }
        }
        return modifiers;
    }

    public Crosshair clone() {
        try {
            return (Crosshair)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public static enum Flag {
        FixedStyle,
        FixedModifierUse,
        FixedModifierHit,
        FixedAll;

    }
}

