/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair.component;

import java.util.Iterator;
import mod.crend.dynamiccrosshair.DynamicCrosshair;
import mod.crend.dynamiccrosshair.api.CrosshairContext;
import mod.crend.dynamiccrosshair.api.DynamicCrosshairApi;
import mod.crend.dynamiccrosshair.component.Crosshair;
import mod.crend.dynamiccrosshair.component.CrosshairVariant;
import mod.crend.dynamiccrosshair.component.InvalidContextState;
import mod.crend.dynamiccrosshair.component.State;
import mod.crend.dynamiccrosshair.config.BlockCrosshairPolicy;
import mod.crend.dynamiccrosshair.config.CrosshairPolicy;
import mod.crend.dynamiccrosshair.config.InteractableCrosshairPolicy;
import mod.crend.dynamiccrosshair.config.RangedCrosshairPolicy;
import net.minecraft.class_1268;
import net.minecraft.class_239;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrosshairHandler {
    public static final class_2960 crosshairTexture = new class_2960("dynamiccrosshair", "textures/gui/crosshairs.png");
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"dynamiccrosshair");
    private static Crosshair activeCrosshair = new Crosshair();
    private static boolean shouldShowCrosshair = true;
    private static Throwable lastError = new Throwable("");
    static State state = null;

    public static Crosshair getActiveCrosshair() {
        return activeCrosshair;
    }

    private static boolean policyMatches(CrosshairPolicy policy, boolean isTargeting) {
        return policy == CrosshairPolicy.Always || policy == CrosshairPolicy.IfTargeting && isTargeting;
    }

    private static boolean policyMatches(BlockCrosshairPolicy policy, boolean isTargeting) {
        return policy == BlockCrosshairPolicy.Always || policy != BlockCrosshairPolicy.Disabled && isTargeting;
    }

    private static Crosshair checkHandOnEntity(CrosshairContext context) {
        DynamicCrosshairApi api2;
        Crosshair crosshair = null;
        Iterator<DynamicCrosshairApi> iterator = context.apis().iterator();
        while (iterator.hasNext() && (crosshair = CrosshairHandler.checkHandUsableItem(api2 = iterator.next(), context)) == null) {
        }
        for (DynamicCrosshairApi api2 : context.apis()) {
            crosshair = Crosshair.combine(crosshair, api2.checkEntity(context));
        }
        return crosshair;
    }

    private static Crosshair checkHandsOnEntity(CrosshairContext context) {
        Crosshair crosshair = CrosshairHandler.checkHandOnEntity(context);
        if (crosshair == null) {
            context.setHand(class_1268.field_5810);
            crosshair = CrosshairHandler.checkHandOnEntity(context);
            context.setHand(class_1268.field_5808);
        }
        return crosshair;
    }

    private static Crosshair checkHandOnBlockOrMiss(CrosshairContext context) {
        DynamicCrosshairApi api;
        Crosshair crosshair = null;
        Iterator<DynamicCrosshairApi> iterator = context.apis().iterator();
        while (iterator.hasNext() && (crosshair = CrosshairHandler.checkHandCommon(api = iterator.next(), context)) == null) {
        }
        return crosshair;
    }

    private static Crosshair checkHandsOnBlockOrMiss(CrosshairContext context) {
        Crosshair crosshair = CrosshairHandler.checkHandOnBlockOrMiss(context);
        context.setHand(class_1268.field_5810);
        crosshair = Crosshair.combine(crosshair, CrosshairHandler.checkHandOnBlockOrMiss(context));
        context.setHand(class_1268.field_5808);
        return crosshair;
    }

    private static Crosshair checkHandUsableItem(DynamicCrosshairApi api, CrosshairContext context) {
        switch (DynamicCrosshair.config.dynamicCrosshairHoldingUsableItem()) {
            case Always: {
                if (!api.isAlwaysUsableItem(context.getItemStack()) && !api.isUsableItem(context.getItemStack())) break;
                return Crosshair.USE_ITEM;
            }
            case IfInteractable: {
                if (context.isCoolingDown()) {
                    return null;
                }
                if (api.isAlwaysUsableItem(context.getItemStack())) {
                    return Crosshair.USE_ITEM;
                }
                Crosshair crosshair = api.checkUsableItem(context);
                if (crosshair == null) break;
                return crosshair;
            }
            case IfTargeting: {
                if (!context.isTargeting()) break;
                if (api.isAlwaysUsableItem(context.getItemStack())) {
                    return Crosshair.USE_ITEM;
                }
                Crosshair crosshair = api.checkUsableItem(context);
                if (crosshair == null) break;
                return crosshair;
            }
        }
        return null;
    }

    private static Crosshair checkHandCommonCrosshair(DynamicCrosshairApi api, CrosshairContext context) {
        Crosshair crosshair = CrosshairHandler.checkHandUsableItem(api, context);
        if (crosshair != null) {
            return crosshair;
        }
        if (DynamicCrosshair.config.dynamicCrosshairHoldingRangedWeapon() != RangedCrosshairPolicy.Disabled && (crosshair = api.checkRangedWeapon(context)) != null) {
            return crosshair;
        }
        if (CrosshairHandler.policyMatches(DynamicCrosshair.config.dynamicCrosshairHoldingThrowable(), context.isTargeting()) && !context.isCoolingDown() && (crosshair = api.checkThrowable(context)) != null) {
            return crosshair;
        }
        if (DynamicCrosshair.config.dynamicCrosshairHoldingMeleeWeapon() && (crosshair = api.checkMeleeWeapon(context)) != null) {
            return crosshair;
        }
        if (CrosshairHandler.policyMatches(DynamicCrosshair.config.dynamicCrosshairHoldingTool(), context.isTargeting()) && (crosshair = api.checkTool(context)) != null) {
            return crosshair;
        }
        if (CrosshairHandler.policyMatches(DynamicCrosshair.config.dynamicCrosshairHoldingBlock(), context.isTargeting()) && (crosshair = api.checkBlockItem(context)) != null) {
            return crosshair;
        }
        return null;
    }

    private static Crosshair checkHandCommon(DynamicCrosshairApi api, CrosshairContext context) {
        Crosshair crosshair = CrosshairHandler.checkHandCommonCrosshair(api, context);
        if (DynamicCrosshair.config.dynamicCrosshairHoldingShield()) {
            crosshair = Crosshair.combine(crosshair, api.checkShield(context));
        }
        return crosshair;
    }

    private static void checkBreakable(CrosshairContext context) {
        if (DynamicCrosshair.config.dynamicCrosshairHoldingTool() == CrosshairPolicy.Disabled) {
            return;
        }
        for (DynamicCrosshairApi api : context.apis()) {
            activeCrosshair.updateFrom(api.checkBlockBreaking(context));
        }
    }

    private static boolean isBlockInteractable(CrosshairContext context) {
        block4: {
            if (DynamicCrosshair.config.dynamicCrosshairOnBlock() != InteractableCrosshairPolicy.Disabled && context.isWithBlock() && context.shouldInteract()) {
                try {
                    for (DynamicCrosshairApi api : context.apis()) {
                        if (!activeCrosshair.updateFrom(api.checkBlockInteractable(context))) continue;
                        return true;
                    }
                }
                catch (NoClassDefFoundError e) {
                    if (e.getMessage().equals(lastError.getMessage())) break block4;
                    LOGGER.error(e.fillInStackTrace().toString());
                    lastError = e;
                }
            }
        }
        return false;
    }

    private static boolean checkShowCrosshair() {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null || state != null && CrosshairHandler.state.context.player != player) {
            state = null;
            return false;
        }
        class_239 hitResult = class_310.method_1551().field_1765;
        if (hitResult == null) {
            state = null;
            return false;
        }
        if (DynamicCrosshair.config.isHideWithScreen() && class_310.method_1551().field_1755 != null) {
            state = null;
            return false;
        }
        if (state == null) {
            state = new State();
        }
        if (!state.changed(hitResult, player)) {
            return shouldShowCrosshair;
        }
        activeCrosshair = new Crosshair();
        try {
            if (!DynamicCrosshair.config.isDynamicCrosshairStyle()) {
                activeCrosshair.setVariant(CrosshairVariant.Regular);
                if (!DynamicCrosshair.config.isDynamicCrosshair()) {
                    return true;
                }
                return switch (hitResult.method_17783()) {
                    default -> throw new IncompatibleClassChangeError();
                    case class_239.class_240.field_1331 -> DynamicCrosshair.config.dynamicCrosshairOnEntity();
                    case class_239.class_240.field_1332 -> {
                        switch (DynamicCrosshair.config.dynamicCrosshairOnBlock()) {
                            default: {
                                throw new IncompatibleClassChangeError();
                            }
                            case IfTargeting: {
                                yield true;
                            }
                            case IfInteractable: {
                                yield CrosshairHandler.isBlockInteractable(CrosshairHandler.state.context);
                            }
                            case Disabled: 
                        }
                        yield false;
                    }
                    case class_239.class_240.field_1333 -> false;
                };
            }
            switch (hitResult.method_17783()) {
                case field_1331: {
                    if (DynamicCrosshair.config.dynamicCrosshairOnEntity()) {
                        activeCrosshair.setVariant(CrosshairVariant.OnEntity);
                    }
                    if (!activeCrosshair.updateFrom(CrosshairHandler.checkHandsOnEntity(CrosshairHandler.state.context))) break;
                    return true;
                }
                case field_1332: {
                    boolean isInteractable = CrosshairHandler.isBlockInteractable(CrosshairHandler.state.context);
                    switch (DynamicCrosshair.config.dynamicCrosshairOnBlock()) {
                        case IfTargeting: {
                            activeCrosshair.setVariant(CrosshairVariant.OnBlock);
                            break;
                        }
                        case IfInteractable: {
                            if (!isInteractable) break;
                            activeCrosshair.setVariant(CrosshairVariant.OnBlock);
                        }
                    }
                    CrosshairHandler.state.context.withBlock(CrosshairHandler::checkBreakable);
                    if (activeCrosshair.updateFrom(CrosshairHandler.state.context.withBlock(CrosshairHandler::checkHandsOnBlockOrMiss))) {
                        return true;
                    }
                    break;
                }
                case field_1333: {
                    if (!activeCrosshair.updateFrom(CrosshairHandler.checkHandsOnBlockOrMiss(CrosshairHandler.state.context))) break;
                    return true;
                }
            }
        }
        catch (InvalidContextState invalidContextState) {
            LOGGER.error("Encountered invalid context state: ", (Throwable)invalidContextState);
        }
        if (activeCrosshair.isChanged()) {
            return true;
        }
        if (DynamicCrosshair.config.isDynamicCrosshair()) {
            return false;
        }
        activeCrosshair.setVariant(CrosshairVariant.Regular);
        return true;
    }

    public static boolean shouldShowCrosshair() {
        return shouldShowCrosshair;
    }

    public static void tick() {
        shouldShowCrosshair = CrosshairHandler.checkShowCrosshair();
    }
}

