/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fml.loading.FMLEnvironment;
import xfacthd.framedblocks.api.FramedBlocksAPI;
import xfacthd.framedblocks.api.util.client.ClientUtils;

public class Utils {
    public static final Tag.Named<Block> FRAMEABLE = BlockTags.m_13116_((String)(FramedBlocksAPI.getInstance().modid() + ":frameable"));
    public static final Tag.Named<Block> BLACKLIST = BlockTags.m_13116_((String)(FramedBlocksAPI.getInstance().modid() + ":blacklisted"));
    public static final Tag.Named<Item> WRENCH = ItemTags.m_13194_((String)"forge:tools/wrench");

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        if (from.m_122434_() == Direction.Axis.Y || to.m_122434_() == Direction.Axis.Y) {
            throw new IllegalArgumentException("Invalid Direction!");
        }
        if (from == to) {
            return shape;
        }
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = (to.m_122416_() - from.m_122416_() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83110_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }

    public static Vec3 fraction(Vec3 vec) {
        return new Vec3(vec.m_7096_() - Math.floor(vec.m_7096_()), vec.m_7098_() - Math.floor(vec.m_7098_()), vec.m_7094_() - Math.floor(vec.m_7094_()));
    }

    public static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createBlockEntityTicker(BlockEntityType<A> type, BlockEntityType<E> actualType, BlockEntityTicker<? super E> ticker) {
        return actualType == type ? ticker : null;
    }

    public static TranslatableComponent translate(String prefix, String postfix) {
        return new TranslatableComponent(prefix + "." + FramedBlocksAPI.getInstance().modid() + "." + postfix);
    }

    public static BlockEntity getBlockEntitySafe(BlockGetter blockGetter, BlockPos pos) {
        BlockGetter blockGetter2 = blockGetter;
        if (blockGetter2 instanceof Level) {
            Level level = (Level)blockGetter2;
            return level.m_46745_(pos).m_5685_(pos, LevelChunk.EntityCreationType.CHECK);
        }
        blockGetter2 = blockGetter;
        if (blockGetter2 instanceof LevelChunk) {
            LevelChunk chunk = (LevelChunk)blockGetter2;
            return chunk.m_5685_(pos, LevelChunk.EntityCreationType.CHECK);
        }
        if (FMLEnvironment.dist.isClient()) {
            return ClientUtils.getBlockEntitySafe(blockGetter, pos);
        }
        return null;
    }
}

