/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.util.client;

import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.chunk.RenderChunkRegion;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.fmllegacy.RegistryObject;

public class ClientUtils {
    public static void replaceModels(RegistryObject<Block> block, Map<ResourceLocation, BakedModel> models, BiFunction<BlockState, BakedModel, BakedModel> blockModelGen) {
        ClientUtils.replaceModels(block, models, blockModelGen, model -> model);
    }

    public static void replaceModels(RegistryObject<Block> block, Map<ResourceLocation, BakedModel> models, BiFunction<BlockState, BakedModel, BakedModel> blockModelGen, Function<BakedModel, BakedModel> itemModelGen) {
        for (BlockState state : ((Block)block.get()).m_49965_().m_61056_()) {
            ModelResourceLocation location = BlockModelShaper.m_110895_((BlockState)state);
            BakedModel baseModel = models.get(location);
            BakedModel replacement = blockModelGen.apply(state, baseModel);
            models.put((ResourceLocation)location, replacement);
        }
        ModelResourceLocation location = new ModelResourceLocation(((Block)block.get()).getRegistryName(), "inventory");
        BakedModel replacement = itemModelGen.apply(models.get(location));
        models.put((ResourceLocation)location, replacement);
    }

    public static BlockEntity getBlockEntitySafe(BlockGetter blockGetter, BlockPos pos) {
        BlockGetter blockGetter2 = blockGetter;
        if (blockGetter2 instanceof RenderChunkRegion) {
            RenderChunkRegion renderChunk = (RenderChunkRegion)blockGetter2;
            return renderChunk.m_112927_(pos, LevelChunk.EntityCreationType.CHECK);
        }
        return null;
    }
}

