/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client;

import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fmllegacy.RegistryObject;
import xfacthd.framedblocks.api.FramedBlocksClientAPI;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.client.ClientUtils;
import xfacthd.framedblocks.client.model.FramedBarsModel;
import xfacthd.framedblocks.client.model.FramedButtonModel;
import xfacthd.framedblocks.client.model.FramedChestModel;
import xfacthd.framedblocks.client.model.FramedCollapsibleBlockModel;
import xfacthd.framedblocks.client.model.FramedCornerPillarModel;
import xfacthd.framedblocks.client.model.FramedCornerSlopeModel;
import xfacthd.framedblocks.client.model.FramedCubeModel;
import xfacthd.framedblocks.client.model.FramedDoorModel;
import xfacthd.framedblocks.client.model.FramedDoubleCornerModel;
import xfacthd.framedblocks.client.model.FramedDoublePanelModel;
import xfacthd.framedblocks.client.model.FramedDoublePrismCornerModel;
import xfacthd.framedblocks.client.model.FramedDoubleSlabModel;
import xfacthd.framedblocks.client.model.FramedDoubleSlopeModel;
import xfacthd.framedblocks.client.model.FramedDoubleThreewayCornerModel;
import xfacthd.framedblocks.client.model.FramedFenceGateModel;
import xfacthd.framedblocks.client.model.FramedFenceModel;
import xfacthd.framedblocks.client.model.FramedFloorModel;
import xfacthd.framedblocks.client.model.FramedFlowerPotModel;
import xfacthd.framedblocks.client.model.FramedHalfPillarModel;
import xfacthd.framedblocks.client.model.FramedInnerCornerSlopeModel;
import xfacthd.framedblocks.client.model.FramedInnerPrismCornerModel;
import xfacthd.framedblocks.client.model.FramedInnerThreewayCornerModel;
import xfacthd.framedblocks.client.model.FramedLadderModel;
import xfacthd.framedblocks.client.model.FramedLatticeModel;
import xfacthd.framedblocks.client.model.FramedLeverModel;
import xfacthd.framedblocks.client.model.FramedPaneModel;
import xfacthd.framedblocks.client.model.FramedPanelModel;
import xfacthd.framedblocks.client.model.FramedPillarModel;
import xfacthd.framedblocks.client.model.FramedPressurePlateModel;
import xfacthd.framedblocks.client.model.FramedPrismCornerModel;
import xfacthd.framedblocks.client.model.FramedRailSlopeModel;
import xfacthd.framedblocks.client.model.FramedSignModel;
import xfacthd.framedblocks.client.model.FramedSlabCornerModel;
import xfacthd.framedblocks.client.model.FramedSlabEdgeModel;
import xfacthd.framedblocks.client.model.FramedSlabModel;
import xfacthd.framedblocks.client.model.FramedSlopeModel;
import xfacthd.framedblocks.client.model.FramedSoulTorchModel;
import xfacthd.framedblocks.client.model.FramedSoulWallTorchModel;
import xfacthd.framedblocks.client.model.FramedStairsModel;
import xfacthd.framedblocks.client.model.FramedThreewayCornerModel;
import xfacthd.framedblocks.client.model.FramedTorchModel;
import xfacthd.framedblocks.client.model.FramedTrapDoorModel;
import xfacthd.framedblocks.client.model.FramedVerticalStairsModel;
import xfacthd.framedblocks.client.model.FramedWallModel;
import xfacthd.framedblocks.client.model.FramedWallSignModel;
import xfacthd.framedblocks.client.model.FramedWallTorchModel;
import xfacthd.framedblocks.client.render.BlockOutlineRenderer;
import xfacthd.framedblocks.client.render.FramedChestRenderer;
import xfacthd.framedblocks.client.render.FramedSignRenderer;
import xfacthd.framedblocks.client.render.outline.CollapsibleBlockOutlineRenderer;
import xfacthd.framedblocks.client.render.outline.RailSlopeOutlineRenderer;
import xfacthd.framedblocks.client.screen.FramedChestScreen;
import xfacthd.framedblocks.client.screen.FramedSignScreen;
import xfacthd.framedblocks.client.util.BlueprintPropertyOverride;
import xfacthd.framedblocks.client.util.ClientApiImpl;
import xfacthd.framedblocks.client.util.FramedBlockColor;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.blockentity.FramedSignBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;

@Mod.EventBusSubscriber(modid="framedblocks", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class FBClient {
    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        FBContent.getRegisteredBlocks().stream().map(RegistryObject::get).filter(block -> block instanceof IFramedBlock).forEach(block -> ItemBlockRenderTypes.setRenderLayer((Block)block, type -> type == RenderType.m_110451_() || type == RenderType.m_110463_() || type == RenderType.m_110457_() || type == RenderType.m_110466_()));
        event.enqueueWork(() -> {
            MenuScreens.m_96206_((MenuType)((MenuType)FBContent.menuTypeFramedChest.get()), FramedChestScreen::new);
            BlueprintPropertyOverride.register();
        });
        BlockOutlineRenderer.registerOutlineRender(BlockType.FRAMED_SLOPE, BlockOutlineRenderer::drawSlopeBox);
        BlockOutlineRenderer.registerOutlineRender(BlockType.FRAMED_CORNER_SLOPE, BlockOutlineRenderer::drawCornerSlopeBox);
        BlockOutlineRenderer.registerOutlineRender(BlockType.FRAMED_INNER_CORNER_SLOPE, BlockOutlineRenderer::drawInnerCornerSlopeBox);
        BlockOutlineRenderer.registerOutlineRender(BlockType.FRAMED_PRISM_CORNER, BlockOutlineRenderer::drawPrismCornerBox);
        BlockOutlineRenderer.registerOutlineRender(BlockType.FRAMED_INNER_PRISM_CORNER, BlockOutlineRenderer::drawInnerPrismCornerBox);
        BlockOutlineRenderer.registerOutlineRender(BlockType.FRAMED_THREEWAY_CORNER, BlockOutlineRenderer::drawThreewayCornerBox);
        BlockOutlineRenderer.registerOutlineRender(BlockType.FRAMED_INNER_THREEWAY_CORNER, BlockOutlineRenderer::drawInnerThreewayCornerBox);
        BlockOutlineRenderer.registerOutlineRender(BlockType.FRAMED_RAIL_SLOPE, new RailSlopeOutlineRenderer());
        BlockOutlineRenderer.registerOutlineRender(BlockType.FRAMED_COLLAPSIBLE_BLOCK, new CollapsibleBlockOutlineRenderer());
    }

    @SubscribeEvent
    public static void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)FBContent.blockEntityTypeFramedSign.get(), FramedSignRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)FBContent.blockEntityTypeFramedChest.get(), FramedChestRenderer::new);
    }

    @SubscribeEvent
    public static void onBlockColors(ColorHandlerEvent.Block event) {
        Block[] blocks = (Block[])FBContent.getRegisteredBlocks().stream().map(RegistryObject::get).filter(block -> block instanceof IFramedBlock).toArray(Block[]::new);
        event.getBlockColors().m_92589_((BlockColor)FramedBlockColor.INSTANCE, blocks);
    }

    @SubscribeEvent
    public static void onModelsLoaded(ModelBakeEvent event) {
        Map registry = event.getModelRegistry();
        FramedChestRenderer.onModelsLoaded(registry);
        ClientUtils.replaceModels(FBContent.blockFramedCube, registry, FramedCubeModel::new);
        ClientUtils.replaceModels(FBContent.blockFramedSlope, registry, FramedSlopeModel::new, FramedSlopeModel::new);
        ClientUtils.replaceModels(FBContent.blockFramedCornerSlope, registry, FramedCornerSlopeModel::new, FramedCornerSlopeModel::new);
        ClientUtils.replaceModels(FBContent.blockFramedInnerCornerSlope, registry, FramedInnerCornerSlopeModel::new, FramedInnerCornerSlopeModel::new);
        ClientUtils.replaceModels(FBContent.blockFramedPrismCorner, registry, FramedPrismCornerModel::new, FramedPrismCornerModel::new);
        ClientUtils.replaceModels(FBContent.blockFramedInnerPrismCorner, registry, FramedInnerPrismCornerModel::new, FramedInnerPrismCornerModel::new);
        ClientUtils.replaceModels(FBContent.blockFramedThreewayCorner, registry, FramedThreewayCornerModel::new, FramedThreewayCornerModel::new);
        ClientUtils.replaceModels(FBContent.blockFramedInnerThreewayCorner, registry, FramedInnerThreewayCornerModel::new, FramedInnerThreewayCornerModel::new);
        ClientUtils.replaceModels(FBContent.blockFramedSlab, registry, FramedSlabModel::new);
        ClientUtils.replaceModels(FBContent.blockFramedSlabEdge, registry, FramedSlabEdgeModel::new);
        ClientUtils.replaceModels(FBContent.blockFramedSlabCorner, registry, FramedSlabCornerModel::new);
        ClientUtils.replaceModels(FBContent.blockFramedPanel, registry, FramedPanelModel::new);
        ClientUtils.replaceModels(FBContent.blockFramedCornerPillar, registry, FramedCornerPillarModel::new);
        ClientUtils.replaceModels(FBContent.blockFramedStairs, registry, FramedStairsModel::new);
        ClientUtils.replaceModels(FBContent.blockFramedWall, registry, FramedWallModel::new);
        ClientUtils.replaceModels(FBContent.blockFramedFence, registry, FramedFenceModel::createFenceModel);
        ClientUtils.replaceModels(FBContent.blockFramedGate, registry, FramedFenceGateModel::new);
        ClientUtils.replaceModels(FBContent.blockFramedDoor, registry, FramedDoorModel::new);
        ClientUtils.replaceModels(FBContent.blockFramedTrapDoor, registry, FramedTrapDoorModel::new);
        ClientUtils.replaceModels(FBContent.blockFramedPressurePlate, registry, FramedPressurePlateModel::new);
        ClientUtils.replaceModels(FBContent.blockFramedLadder, registry, FramedLadderModel::new, FramedLadderModel::new);
        ClientUtils.replaceModels(FBContent.blockFramedButton, registry, FramedButtonModel::new);
        ClientUtils.replaceModels(FBContent.blockFramedLever, registry, FramedLeverModel::new);
        ClientUtils.replaceModels(FBContent.blockFramedSign, registry, FramedSignModel::new);
        ClientUtils.replaceModels(FBContent.blockFramedWallSign, registry, FramedWallSignModel::new);
        ClientUtils.replaceModels(FBContent.blockFramedDoubleSlab, registry, FramedDoubleSlabModel::new);
        ClientUtils.replaceModels(FBContent.blockFramedDoublePanel, registry, FramedDoublePanelModel::new);
        ClientUtils.replaceModels(FBContent.blockFramedDoubleSlope, registry, FramedDoubleSlopeModel::new);
        ClientUtils.replaceModels(FBContent.blockFramedDoubleCorner, registry, FramedDoubleCornerModel::new, FramedDoubleCornerModel::new);
        ClientUtils.replaceModels(FBContent.blockFramedDoublePrismCorner, registry, FramedDoublePrismCornerModel::new, FramedDoublePrismCornerModel::new);
        ClientUtils.replaceModels(FBContent.blockFramedDoubleThreewayCorner, registry, FramedDoubleThreewayCornerModel::new, FramedDoubleThreewayCornerModel::new);
        ClientUtils.replaceModels(FBContent.blockFramedTorch, registry, FramedTorchModel::new);
        ClientUtils.replaceModels(FBContent.blockFramedWallTorch, registry, FramedWallTorchModel::new);
        ClientUtils.replaceModels(FBContent.blockFramedSoulTorch, registry, FramedSoulTorchModel::new);
        ClientUtils.replaceModels(FBContent.blockFramedSoulWallTorch, registry, FramedSoulWallTorchModel::new);
        ClientUtils.replaceModels(FBContent.blockFramedFloor, registry, FramedFloorModel::new);
        ClientUtils.replaceModels(FBContent.blockFramedLattice, registry, FramedLatticeModel::new);
        ClientUtils.replaceModels(FBContent.blockFramedVerticalStairs, registry, FramedVerticalStairsModel::new);
        ClientUtils.replaceModels(FBContent.blockFramedChest, registry, FramedChestModel::new, FramedChestModel::new);
        ClientUtils.replaceModels(FBContent.blockFramedBars, registry, FramedBarsModel::new);
        ClientUtils.replaceModels(FBContent.blockFramedPane, registry, FramedPaneModel::new);
        ClientUtils.replaceModels(FBContent.blockFramedRailSlope, registry, FramedRailSlopeModel::new, FramedRailSlopeModel::new);
        ClientUtils.replaceModels(FBContent.blockFramedFlowerPot, registry, FramedFlowerPotModel::new);
        ClientUtils.replaceModels(FBContent.blockFramedPillar, registry, FramedPillarModel::new);
        ClientUtils.replaceModels(FBContent.blockFramedHalfPillar, registry, FramedHalfPillarModel::new);
        ClientUtils.replaceModels(FBContent.blockFramedPost, registry, FramedPillarModel::new);
        ClientUtils.replaceModels(FBContent.blockFramedCollapsibleBlock, registry, FramedCollapsibleBlockModel::new);
    }

    public static void openSignScreen(BlockPos pos) {
        BlockEntity blockEntity = Minecraft.m_91087_().f_91073_.m_7702_(pos);
        if (blockEntity instanceof FramedSignBlockEntity) {
            FramedSignBlockEntity be = (FramedSignBlockEntity)blockEntity;
            Minecraft.m_91087_().m_91152_((Screen)new FramedSignScreen(be));
        }
    }

    static {
        FramedBlocksClientAPI.INSTANCE.accept(new ClientApiImpl());
    }
}

