/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.IModelData;
import xfacthd.framedblocks.api.model.BakedModelProxy;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.util.client.BakedQuadTransformer;
import xfacthd.framedblocks.api.util.client.ModelUtils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.blockentity.FramedCollapsibleBlockEntity;
import xfacthd.framedblocks.common.data.CollapseFace;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedCollapsibleBlockModel
extends BakedModelProxy {
    private final BlockState state;
    private final Int2ObjectMap<CollapsibleModel> MODEL_CACHE = new Int2ObjectOpenHashMap();

    public FramedCollapsibleBlockModel(BlockState state, BakedModel baseModel) {
        super(baseModel);
        this.state = state;
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        return this.getModel(extraData).getQuads(state, side, rand, extraData);
    }

    public TextureAtlasSprite getParticleIcon(@Nonnull IModelData data) {
        return this.getModel(data).getParticleIcon(data);
    }

    private CollapsibleModel getModel(IModelData extraData) {
        Integer offsets = (Integer)extraData.getData(FramedCollapsibleBlockEntity.OFFSETS);
        int packed = offsets == null ? 0 : offsets;
        return (CollapsibleModel)this.MODEL_CACHE.computeIfAbsent(packed, key -> new CollapsibleModel(this.state, this.baseModel, key));
    }

    @Nonnull
    public IModelData getModelData(@Nonnull BlockAndTintGetter world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof FramedCollapsibleBlockEntity) {
            FramedCollapsibleBlockEntity be = (FramedCollapsibleBlockEntity)blockEntity;
            return be.getModelData();
        }
        return tileData;
    }

    private static class CollapsibleModel
    extends FramedBlockModel {
        private final Direction collapsedFace;
        private final float[] vertexPos = new float[4];

        public CollapsibleModel(BlockState state, BakedModel baseModel, int packedOffsets) {
            super(state, baseModel);
            this.collapsedFace = ((CollapseFace)((Object)state.m_61143_(PropertyHolder.COLLAPSED_FACE))).toDirection();
            byte[] vertexOffsets = FramedCollapsibleBlockEntity.unpackOffsets(packedOffsets);
            for (int i = 0; i < 4; ++i) {
                this.vertexPos[i] = 1.0f - (float)vertexOffsets[i] / 16.0f;
            }
        }

        @Override
        protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
            if (this.collapsedFace == null || quad.m_111306_() == this.collapsedFace.m_122424_()) {
                quadMap.get(quad.m_111306_()).add(quad);
                return;
            }
            if (quad.m_111306_() == this.collapsedFace) {
                BakedQuad collapsedQuad = ModelUtils.duplicateQuad(quad);
                BakedQuadTransformer.setVertexPosInFacingDir(collapsedQuad, this.vertexPos);
                quadMap.get(null).add(collapsedQuad);
            } else {
                BakedQuad cutQuad = ModelUtils.duplicateQuad(quad);
                if (this.collapsedFace.m_122434_() == Direction.Axis.Y) {
                    float posTwo;
                    boolean top = this.collapsedFace == Direction.UP;
                    int idxOff = this.getYCollapsedIndexOffset(quad.m_111306_());
                    float posOne = this.vertexPos[idxOff];
                    if (top) {
                        posTwo = this.vertexPos[(idxOff + 1) % 4];
                    } else {
                        int idxTwo = idxOff - 1;
                        if (idxTwo < 0) {
                            idxTwo = 4 + idxTwo;
                        }
                        posTwo = this.vertexPos[idxTwo % 4];
                    }
                    if (BakedQuadTransformer.createHorizontalSideQuad(cutQuad, !top, posOne, posTwo)) {
                        quadMap.get(quad.m_111306_()).add(cutQuad);
                    }
                } else if (quad.m_111306_().m_122434_() == Direction.Axis.Y) {
                    boolean top = quad.m_111306_() == Direction.UP;
                    float posOne = this.vertexPos[top ? 0 : 1];
                    float posTwo = this.vertexPos[top ? 3 : 2];
                    if (this.collapsedFace == Direction.NORTH || top && this.collapsedFace == Direction.WEST || !top && this.collapsedFace == Direction.EAST) {
                        float temp = posOne;
                        posOne = posTwo;
                        posTwo = temp;
                    }
                    if (BakedQuadTransformer.createTopBottomQuad(cutQuad, this.collapsedFace, posOne, posTwo)) {
                        quadMap.get(quad.m_111306_()).add(cutQuad);
                    }
                } else {
                    float posBot;
                    boolean right = this.collapsedFace == cutQuad.m_111306_().m_122427_();
                    float posTop = this.vertexPos[right ? 3 : 0];
                    if (BakedQuadTransformer.createVerticalSideQuad(cutQuad, this.collapsedFace, posTop, posBot = this.vertexPos[right ? 2 : 1])) {
                        quadMap.get(quad.m_111306_()).add(cutQuad);
                    }
                }
            }
        }

        @Override
        protected BakedModel getCamoModel(BlockState camoState) {
            if (camoState == ((Block)FBContent.blockFramedCube.get()).m_49966_()) {
                return this.baseModel;
            }
            return super.getCamoModel(camoState);
        }

        private int getYCollapsedIndexOffset(Direction quadFace) {
            boolean top = this.collapsedFace == Direction.UP;
            return switch (quadFace) {
                case Direction.NORTH -> {
                    if (top) {
                        yield 3;
                    }
                    yield 2;
                }
                case Direction.EAST -> {
                    if (top) {
                        yield 2;
                    }
                    yield 3;
                }
                case Direction.SOUTH -> {
                    if (top) {
                        yield 1;
                    }
                    yield 0;
                }
                case Direction.WEST -> {
                    if (top) {
                        yield 0;
                    }
                    yield 1;
                }
                case Direction.DOWN, Direction.UP -> throw new IllegalArgumentException("Invalid facing for y face collapse!");
                default -> throw new IncompatibleClassChangeError();
            };
        }
    }
}

