/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import com.mojang.math.Vector3f;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import xfacthd.framedblocks.api.util.client.BakedQuadTransformer;
import xfacthd.framedblocks.api.util.client.ModelUtils;
import xfacthd.framedblocks.client.model.FramedFenceModel;

public class FramedDiagonalFenceModel
extends FramedFenceModel {
    private final boolean northEast;
    private final boolean southEast;
    private final boolean northWest;
    private final boolean southWest;

    public FramedDiagonalFenceModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.northEast = false;
        this.southEast = false;
        this.northWest = false;
        this.southWest = false;
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        super.transformQuad(quadMap, quad);
        FramedDiagonalFenceModel.createDiagonalFenceBars(quadMap, quad, Direction.NORTH, this.northEast);
        FramedDiagonalFenceModel.createDiagonalFenceBars(quadMap, quad, Direction.EAST, this.southEast);
        FramedDiagonalFenceModel.createDiagonalFenceBars(quadMap, quad, Direction.SOUTH, this.southWest);
        FramedDiagonalFenceModel.createDiagonalFenceBars(quadMap, quad, Direction.WEST, this.northWest);
    }

    private static void createDiagonalFenceBars(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad, Direction dir, boolean active) {
        if (active) {
            if (quad.m_111306_().m_122434_() == Direction.Axis.Y) {
                BakedQuad topBotQuad = ModelUtils.duplicateQuad(quad);
                if (BakedQuadTransformer.createTopBottomQuad(topBotQuad, dir.m_122424_(), 0.4375f) && BakedQuadTransformer.createTopBottomQuad(topBotQuad, dir.m_122427_(), 0.5625f) && BakedQuadTransformer.createTopBottomQuad(topBotQuad, dir.m_122428_(), 0.5625f)) {
                    BakedQuadTransformer.setQuadPosInFacingDir(topBotQuad, quad.m_111306_() == Direction.UP ? 0.9375f : 0.25f);
                    FramedDiagonalFenceModel.rotateQuad(topBotQuad, dir);
                    quadMap.get(null).add(topBotQuad);
                    topBotQuad = ModelUtils.duplicateQuad(topBotQuad);
                    BakedQuadTransformer.setQuadPosInFacingDir(topBotQuad, quad.m_111306_() == Direction.UP ? 0.5625f : 0.625f);
                    quadMap.get(null).add(topBotQuad);
                }
            } else if (quad.m_111306_() == dir.m_122427_() || quad.m_111306_() == dir.m_122428_()) {
                boolean neg = dir.m_122421_() == Direction.AxisDirection.NEGATIVE;
                BakedQuad sideQuad = ModelUtils.duplicateQuad(quad);
                if (BakedQuadTransformer.createSideQuad(sideQuad, neg ? 0.0f : 0.5625f, 0.375f, neg ? 0.4375f : 1.0f, 0.5625f)) {
                    BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, 0.5625f);
                    FramedDiagonalFenceModel.rotateQuad(sideQuad, dir);
                    quadMap.get(null).add(sideQuad);
                }
                if (BakedQuadTransformer.createSideQuad(sideQuad = ModelUtils.duplicateQuad(quad), neg ? 0.0f : 0.5625f, 0.75f, neg ? 0.4375f : 1.0f, 0.9375f)) {
                    BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, 0.5625f);
                    FramedDiagonalFenceModel.rotateQuad(sideQuad, dir);
                    quadMap.get(null).add(sideQuad);
                }
            } else if (quad.m_111306_() == dir) {
                BakedQuad frontQuad = ModelUtils.duplicateQuad(quad);
                if (BakedQuadTransformer.createSideQuad(frontQuad, 0.4375f, 0.375f, 0.5625f, 0.5625f)) {
                    FramedDiagonalFenceModel.rotateQuad(frontQuad, dir);
                    quadMap.get(null).add(frontQuad);
                }
                if (BakedQuadTransformer.createSideQuad(frontQuad = ModelUtils.duplicateQuad(quad), 0.4375f, 0.75f, 0.5625f, 0.9375f)) {
                    FramedDiagonalFenceModel.rotateQuad(frontQuad, dir);
                    quadMap.get(null).add(frontQuad);
                }
            }
        }
    }

    private static void rotateQuad(BakedQuad quad, Direction dir) {
        BakedQuadTransformer.rotateQuadAroundAxisCentered(quad, Direction.Axis.Y, -45.0f, true, new Vector3f((float)dir.m_122429_(), 1.0f, (float)dir.m_122431_()));
    }
}

