/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.type.IBlockType;
import xfacthd.framedblocks.api.util.client.BakedQuadTransformer;
import xfacthd.framedblocks.api.util.client.ModelUtils;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedPillarModel
extends FramedBlockModel {
    private final Direction.Axis axis;
    private final float capStart;
    private final float capEnd;
    private final float sideCut;

    public FramedPillarModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.axis = (Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61365_);
        IBlockType type = ((IFramedBlock)state.m_60734_()).getBlockType();
        this.capStart = type == BlockType.FRAMED_POST ? 0.375f : 0.25f;
        this.capEnd = type == BlockType.FRAMED_POST ? 0.625f : 0.75f;
        this.sideCut = type == BlockType.FRAMED_POST ? 0.625f : 0.75f;
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        BakedQuad copy = ModelUtils.duplicateQuad(quad);
        if (FramedPillarModel.createPillarQuad(copy, this.axis, this.capStart, this.capEnd, this.sideCut)) {
            if (quad.m_111306_().m_122434_() == this.axis) {
                quadMap.get(quad.m_111306_()).add(copy);
            } else {
                quadMap.get(null).add(copy);
            }
        }
    }

    public static boolean createPillarQuad(BakedQuad quad, Direction.Axis axis, float capStart, float capEnd, float sideCut) {
        if (quad.m_111306_().m_122434_() == axis) {
            if (axis == Direction.Axis.Y) {
                return BakedQuadTransformer.createTopBottomQuad(quad, capStart, capStart, capEnd, capEnd);
            }
            return BakedQuadTransformer.createSideQuad(quad, capStart, capStart, capEnd, capEnd);
        }
        if (axis == Direction.Axis.Y) {
            if (BakedQuadTransformer.createVerticalSideQuad(quad, quad.m_111306_().m_122427_(), sideCut) && BakedQuadTransformer.createVerticalSideQuad(quad, quad.m_111306_().m_122428_(), sideCut)) {
                BakedQuadTransformer.setQuadPosInFacingDir(quad, sideCut);
                return true;
            }
        } else if (quad.m_111306_().m_122434_() == Direction.Axis.Y) {
            if (BakedQuadTransformer.createTopBottomQuad(quad, FramedPillarModel.axisToDir(axis, true).m_122427_(), sideCut) && BakedQuadTransformer.createTopBottomQuad(quad, FramedPillarModel.axisToDir(axis, false).m_122427_(), sideCut)) {
                BakedQuadTransformer.setQuadPosInFacingDir(quad, sideCut);
                return true;
            }
        } else if (BakedQuadTransformer.createHorizontalSideQuad(quad, true, sideCut) && BakedQuadTransformer.createHorizontalSideQuad(quad, false, sideCut)) {
            BakedQuadTransformer.setQuadPosInFacingDir(quad, sideCut);
            return true;
        }
        return false;
    }

    private static Direction axisToDir(Direction.Axis axis, boolean positive) {
        return switch (axis) {
            case Direction.Axis.X -> {
                if (positive) {
                    yield Direction.EAST;
                }
                yield Direction.WEST;
            }
            case Direction.Axis.Y -> {
                if (positive) {
                    yield Direction.UP;
                }
                yield Direction.DOWN;
            }
            case Direction.Axis.Z -> {
                if (positive) {
                    yield Direction.SOUTH;
                }
                yield Direction.NORTH;
            }
            default -> throw new IncompatibleClassChangeError();
        };
    }
}

