/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.util.client.BakedQuadTransformer;
import xfacthd.framedblocks.api.util.client.ModelUtils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.SlopeType;

public class FramedSlopeModel
extends FramedBlockModel {
    private final Direction dir;
    private final SlopeType type;

    public FramedSlopeModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.dir = (Direction)state.m_61143_((Property)PropertyHolder.FACING_HOR);
        this.type = (SlopeType)((Object)state.m_61143_(PropertyHolder.SLOPE_TYPE));
    }

    public FramedSlopeModel(BakedModel baseModel) {
        this((BlockState)((Block)FBContent.blockFramedSlope.get()).m_49966_().m_61124_((Property)PropertyHolder.FACING_HOR, (Comparable)Direction.SOUTH), baseModel);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        BakedQuad triQuad;
        if (this.type == SlopeType.HORIZONTAL) {
            BakedQuad triQuad2;
            if (quad.m_111306_() == this.dir.m_122424_()) {
                BakedQuad slopeQuad = ModelUtils.duplicateQuad(quad);
                BakedQuadTransformer.createSideSlopeQuad(slopeQuad, true);
                quadMap.get(null).add(slopeQuad);
            } else if ((quad.m_111306_() == Direction.UP || quad.m_111306_() == Direction.DOWN) && BakedQuadTransformer.createTopBottomTriangleQuad(triQuad2 = ModelUtils.duplicateQuad(quad), this.dir)) {
                quadMap.get(quad.m_111306_()).add(triQuad2);
            }
        } else if (quad.m_111306_() == this.dir.m_122424_()) {
            BakedQuad slopeQuad = ModelUtils.duplicateQuad(quad);
            BakedQuadTransformer.createTopBottomSlopeQuad(slopeQuad, this.type == SlopeType.BOTTOM);
            quadMap.get(null).add(slopeQuad);
        } else if ((quad.m_111306_() == this.dir.m_122427_() || quad.m_111306_() == this.dir.m_122428_()) && BakedQuadTransformer.createSideTriangleQuad(triQuad = ModelUtils.duplicateQuad(quad), quad.m_111306_() == this.dir.m_122427_(), this.type == SlopeType.TOP)) {
            quadMap.get(quad.m_111306_()).add(triQuad);
        }
    }
}

