/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.DrawSelectionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.type.IBlockType;
import xfacthd.framedblocks.api.util.client.OutlineRender;
import xfacthd.framedblocks.client.util.ClientConfig;
import xfacthd.framedblocks.common.data.CornerType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.SlopeType;
import xfacthd.framedblocks.common.util.FramedUtils;

@Mod.EventBusSubscriber(modid="framedblocks", value={Dist.CLIENT})
public class BlockOutlineRenderer {
    private static final Map<IBlockType, OutlineRender> OUTLINE_RENDERERS = new HashMap<IBlockType, OutlineRender>();

    @SubscribeEvent
    public static void onRenderBlockHighlight(DrawSelectionEvent.HighlightBlock event) {
        if (!ClientConfig.fancyHitboxes) {
            return;
        }
        BlockHitResult result = event.getTarget();
        BlockState state = Minecraft.m_91087_().f_91073_.m_8055_(result.m_82425_());
        Block block = state.m_60734_();
        if (!(block instanceof IFramedBlock)) {
            return;
        }
        IFramedBlock block2 = (IFramedBlock)block;
        IBlockType type = block2.getBlockType();
        if (type.hasSpecialHitbox()) {
            PoseStack mstack = event.getMatrix();
            Vec3 offset = Vec3.m_82528_((Vec3i)result.m_82425_()).m_82546_(event.getInfo().m_90583_());
            VertexConsumer builder = event.getBuffers().m_6299_(RenderType.m_110504_());
            OutlineRender render = OUTLINE_RENDERERS.get(type);
            mstack.m_85836_();
            mstack.m_85837_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
            mstack.m_85837_(0.5, 0.5, 0.5);
            render.rotateMatrix(mstack, state);
            mstack.m_85837_(-0.5, -0.5, -0.5);
            render.draw(state, (Level)Minecraft.m_91087_().f_91073_, result.m_82425_(), mstack, builder);
            mstack.m_85849_();
            event.setCanceled(true);
        }
    }

    public static synchronized void registerOutlineRender(IBlockType type, OutlineRender render) {
        if (!type.hasSpecialHitbox()) {
            throw new IllegalArgumentException(String.format("Type %s doesn't return true from IBlockType#hasSpecialHitbox()", type));
        }
        OUTLINE_RENDERERS.put(type, render);
    }

    public static void drawSlopeBox(BlockState state, PoseStack mstack, VertexConsumer builder) {
        SlopeType type = FramedUtils.getSlopeType(state);
        if (type != SlopeType.HORIZONTAL) {
            if (type == SlopeType.TOP) {
                mstack.m_85837_(0.5, 0.5, 0.5);
                mstack.m_85841_(1.0f, -1.0f, 1.0f);
                mstack.m_85837_(-0.5, -0.5, -0.5);
            }
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0);
            OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        } else {
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 1.0, 1.0, 0.0, 1.0, 1.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0);
            OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 1.0, 1.0, 0.0, 0.0, 1.0, 1.0);
        }
    }

    public static void drawCornerSlopeBox(BlockState state, PoseStack mstack, VertexConsumer builder) {
        CornerType type = (CornerType)((Object)state.m_61143_(PropertyHolder.CORNER_TYPE));
        if (!type.isHorizontal()) {
            if (type.isTop()) {
                mstack.m_85837_(0.5, 0.5, 0.5);
                mstack.m_85841_(1.0f, -1.0f, 1.0f);
                mstack.m_85837_(-0.5, -0.5, -0.5);
            }
            OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0);
            OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0);
        } else {
            mstack.m_85837_(0.5, 0.5, 0.5);
            if (!type.isRight()) {
                mstack.m_85841_(-1.0f, 1.0f, 1.0f);
            }
            if (type.isTop()) {
                mstack.m_85841_(1.0f, -1.0f, 1.0f);
            }
            mstack.m_85837_(-0.5, -0.5, -0.5);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0);
        }
    }

    public static void drawInnerCornerSlopeBox(BlockState state, PoseStack mstack, VertexConsumer builder) {
        CornerType type = (CornerType)((Object)state.m_61143_(PropertyHolder.CORNER_TYPE));
        if (!type.isHorizontal()) {
            mstack.m_85837_(0.5, 0.5, 0.5);
            if (type.isTop()) {
                mstack.m_85841_(1.0f, -1.0f, 1.0f);
            }
            mstack.m_85837_(-0.5, -0.5, -0.5);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 1.0, 1.0, 0.0, 1.0, 1.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        } else {
            mstack.m_85837_(0.5, 0.5, 0.5);
            if (!type.isRight()) {
                mstack.m_85841_(-1.0f, 1.0f, 1.0f);
            }
            if (type.isTop()) {
                mstack.m_85841_(1.0f, -1.0f, 1.0f);
            }
            mstack.m_85837_(-0.5, -0.5, -0.5);
            OutlineRender.drawLine(builder, mstack, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 1.0, 0.0, 0.0, 1.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 1.0, 0.0, 1.0, 1.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        }
    }

    public static void drawPrismCornerBox(BlockState state, PoseStack mstack, VertexConsumer builder) {
        boolean top = (Boolean)state.m_61143_((Property)PropertyHolder.TOP);
        mstack.m_85837_(0.5, 0.5, 0.5);
        if (top) {
            mstack.m_85841_(1.0f, -1.0f, 1.0f);
        }
        mstack.m_85837_(-0.5, -0.5, -0.5);
        OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0);
    }

    public static void drawInnerPrismCornerBox(BlockState state, PoseStack mstack, VertexConsumer builder) {
        boolean top = (Boolean)state.m_61143_((Property)PropertyHolder.TOP);
        mstack.m_85837_(0.5, 0.5, 0.5);
        if (top) {
            mstack.m_85841_(1.0f, -1.0f, 1.0f);
        }
        mstack.m_85837_(-0.5, -0.5, -0.5);
        OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0);
        OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0);
        OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 1.0, 1.0, 0.0, 1.0, 1.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 1.0, 1.0, 0.0, 0.0, 1.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0);
        OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0);
    }

    public static void drawThreewayCornerBox(BlockState state, PoseStack mstack, VertexConsumer builder) {
        boolean top = (Boolean)state.m_61143_((Property)PropertyHolder.TOP);
        mstack.m_85837_(0.5, 0.5, 0.5);
        if (top) {
            mstack.m_85841_(1.0f, -1.0f, 1.0f);
        }
        mstack.m_85837_(-0.5, -0.5, -0.5);
        OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 0.0, 0.5, 0.5, 0.5);
        OutlineRender.drawLine(builder, mstack, 0.5, 0.5, 0.5, 1.0, 1.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 1.0, 0.5, 0.5, 0.5);
    }

    public static void drawInnerThreewayCornerBox(BlockState state, PoseStack mstack, VertexConsumer builder) {
        boolean top = (Boolean)state.m_61143_((Property)PropertyHolder.TOP);
        mstack.m_85837_(0.5, 0.5, 0.5);
        if (top) {
            mstack.m_85841_(1.0f, -1.0f, 1.0f);
        }
        mstack.m_85837_(-0.5, -0.5, -0.5);
        OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0);
        OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 1.0, 1.0, 0.0, 1.0, 1.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0);
        OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0);
        OutlineRender.drawLine(builder, mstack, 0.0, 1.0, 1.0, 1.0, 1.0, 0.0);
        OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.5, 0.5, 0.5);
        OutlineRender.drawLine(builder, mstack, 0.5, 0.5, 0.5, 0.0, 1.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 1.0, 1.0, 0.0, 0.5, 0.5, 0.5);
    }
}

