/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import xfacthd.framedblocks.client.model.FramedChestLidModel;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.blockentity.FramedChestBlockEntity;
import xfacthd.framedblocks.common.data.ChestState;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedChestRenderer
implements BlockEntityRenderer<FramedChestBlockEntity> {
    private static final RenderType[] RENDER_TYPES = new RenderType[]{RenderType.m_110451_(), RenderType.m_110463_(), RenderType.m_110457_(), RenderType.m_110466_()};
    private static final Map<Direction, BakedModel> LID_MODELS = new EnumMap<Direction, BakedModel>(Direction.class);

    public FramedChestRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(FramedChestBlockEntity be, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int light, int overlay) {
        float xOff;
        BlockState state = be.m_58900_();
        ChestState chestState = (ChestState)((Object)state.m_61143_(PropertyHolder.CHEST_STATE));
        Direction dir = (Direction)state.m_61143_((Property)PropertyHolder.FACING_HOR);
        long lastChange = be.getLastChangeTime(chestState);
        if (chestState == ChestState.CLOSED) {
            return;
        }
        BakedModel model = LID_MODELS.get(dir);
        IModelData data = model.getModelData((BlockAndTintGetter)be.m_58904_(), be.m_58899_(), state, (IModelData)EmptyModelData.INSTANCE);
        float angle = FramedChestRenderer.calculateAngle(be, chestState, dir, lastChange, partialTicks);
        float f = dir.m_122434_() == Direction.Axis.X ? (dir.m_122421_() == Direction.AxisDirection.POSITIVE ? 0.0625f : 0.9375f) : (xOff = 0.0f);
        float zOff = dir.m_122434_() == Direction.Axis.Z ? (dir.m_122421_() == Direction.AxisDirection.POSITIVE ? 0.0625f : 0.9375f) : 0.0f;
        matrix.m_85836_();
        matrix.m_85837_((double)xOff, 0.5625, (double)zOff);
        matrix.m_85845_(dir.m_122434_() == Direction.Axis.X ? Vector3f.f_122227_.m_122240_(angle) : Vector3f.f_122222_.m_122240_(angle));
        matrix.m_85837_((double)(-xOff), -0.5625, (double)(-zOff));
        FramedChestRenderer.renderLidModel(be, state, matrix, buffer, model, data);
        matrix.m_85849_();
    }

    private static void renderLidModel(FramedChestBlockEntity be, BlockState state, PoseStack matrix, MultiBufferSource buffer, BakedModel model, IModelData data) {
        ModelBlockRenderer renderer = Minecraft.m_91087_().m_91289_().m_110937_();
        for (RenderType type : RENDER_TYPES) {
            ForgeHooksClient.setRenderLayer((RenderType)type);
            renderer.tesselateWithAO((BlockAndTintGetter)be.m_58904_(), model, state, be.m_58899_(), matrix, buffer.m_6299_(type), false, be.m_58904_().m_5822_(), be.m_58899_().m_121878_(), OverlayTexture.f_118083_, data);
        }
        ForgeHooksClient.setRenderLayer(null);
    }

    private static float calculateAngle(FramedChestBlockEntity be, ChestState chestState, Direction dir, long lastChange, float partialTicks) {
        float diff = (float)(be.m_58904_().m_46467_() - lastChange) + partialTicks;
        float factor = Mth.m_14179_((float)(diff / 10.0f), (float)0.0f, (float)1.0f);
        if (chestState == ChestState.CLOSING) {
            factor = 1.0f - factor;
        }
        factor = 1.0f - factor;
        factor = 1.0f - factor * factor * factor;
        float angle = Mth.m_14036_((float)(factor * 90.0f), (float)0.0f, (float)90.0f);
        if (dir.m_122421_() == Direction.AxisDirection.NEGATIVE) {
            angle *= -1.0f;
        }
        return angle;
    }

    public static void onModelsLoaded(Map<ResourceLocation, BakedModel> registry) {
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockState state = (BlockState)((Block)FBContent.blockFramedChest.get()).m_49966_().m_61124_((Property)PropertyHolder.FACING_HOR, (Comparable)dir);
            ModelResourceLocation location = BlockModelShaper.m_110895_((BlockState)state);
            LID_MODELS.put(dir, new FramedChestLidModel(state, registry.get(location)));
        }
    }
}

