/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.fmllegacy.network.NetworkHooks;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.blockentity.FramedChestBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.ChestState;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedChestBlock
extends FramedBlock {
    public FramedChestBlock() {
        super(BlockType.FRAMED_CHEST);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PropertyHolder.FACING_HOR, PropertyHolder.CHEST_STATE, BlockStateProperties.f_61362_});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)PropertyHolder.FACING_HOR, (Comparable)context.m_8125_().m_122424_());
        return FramedChestBlock.withWater(state, (LevelReader)context.m_43725_(), context.m_8083_());
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity;
        InteractionResult result = super.m_6227_(state, level, pos, player, hand, hit);
        if (result != InteractionResult.PASS) {
            return result;
        }
        if (!level.m_5776_() && (blockEntity = level.m_7702_(pos)) instanceof FramedChestBlockEntity) {
            FramedChestBlockEntity be = (FramedChestBlockEntity)blockEntity;
            if (state.m_61143_(PropertyHolder.CHEST_STATE) != ChestState.OPENING) {
                level.m_46597_(pos, (BlockState)state.m_61124_(PropertyHolder.CHEST_STATE, (Comparable)((Object)ChestState.OPENING)));
                level.m_5594_(null, pos, SoundEvents.f_11749_, SoundSource.BLOCKS, 0.5f, level.f_46441_.nextFloat() * 0.1f + 0.9f);
            }
            be.open();
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)be, (BlockPos)pos);
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (newState.m_60734_() != state.m_60734_() && (blockEntity = level.m_7702_(pos)) instanceof FramedChestBlockEntity) {
            FramedChestBlockEntity be = (FramedChestBlockEntity)blockEntity;
            be.getDrops().forEach(stack -> FramedChestBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)stack));
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FramedChestBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.m_5776_() || state.m_61143_(PropertyHolder.CHEST_STATE) != ChestState.CLOSING) {
            return null;
        }
        return Utils.createBlockEntityTicker(type, (BlockEntityType)FBContent.blockEntityTypeFramedChest.get(), FramedChestBlockEntity::tick);
    }
}

