/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.util.CtmPredicate;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.CornerType;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedCornerSlopeBlock
extends FramedBlock {
    public static final CtmPredicate CTM_PREDICATE = (state, dir) -> {
        CornerType type = (CornerType)((Object)((Object)state.m_61143_(PropertyHolder.CORNER_TYPE)));
        if (type == CornerType.TOP) {
            return dir == Direction.UP;
        }
        if (type == CornerType.BOTTOM) {
            return dir == Direction.DOWN;
        }
        return state.m_61143_((Property)PropertyHolder.FACING_HOR) == dir;
    };
    public static final CtmPredicate CTM_PREDICATE_INNER = (state, dir) -> {
        CornerType type = (CornerType)((Object)((Object)state.m_61143_(PropertyHolder.CORNER_TYPE)));
        if ((type == CornerType.TOP || type.isHorizontal() && type.isTop()) && dir == Direction.UP) {
            return true;
        }
        if ((type == CornerType.BOTTOM || type.isHorizontal() && !type.isTop()) && dir == Direction.DOWN) {
            return true;
        }
        Direction facing = (Direction)state.m_61143_((Property)PropertyHolder.FACING_HOR);
        if (type.isHorizontal()) {
            return facing == dir || type.isRight() && facing.m_122427_() == dir || !type.isRight() && facing.m_122428_() == dir;
        }
        return facing == dir || facing.m_122428_() == dir;
    };

    public FramedCornerSlopeBlock(BlockType type) {
        super(type);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PropertyHolder.FACING_HOR, PropertyHolder.CORNER_TYPE, BlockStateProperties.f_61362_});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = this.m_49966_();
        Direction side = context.m_43719_();
        Vec3 hitPoint = Utils.fraction(context.m_43720_());
        if (side.m_122434_() != Direction.Axis.Y) {
            if (hitPoint.m_7098_() < 0.1875) {
                side = Direction.UP;
            } else if (hitPoint.m_7098_() > 0.8125) {
                side = Direction.DOWN;
            }
        }
        Direction facing = context.m_8125_();
        state = FramedCornerSlopeBlock.withCornerType(state, context, side, hitPoint, facing);
        return FramedCornerSlopeBlock.withWater(state, (LevelReader)context.m_43725_(), context.m_8083_());
    }

    public static ImmutableMap<BlockState, VoxelShape> generateCornerShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            CornerType type = (CornerType)((Object)state.m_61143_(PropertyHolder.CORNER_TYPE));
            Direction dir = (Direction)state.m_61143_((Property)PropertyHolder.FACING_HOR);
            if (type.isHorizontal()) {
                VoxelShape shapeBottomLeft = Shapes.m_83124_((VoxelShape)FramedCornerSlopeBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)4.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedCornerSlopeBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)12.0), FramedCornerSlopeBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)12.0, (double)12.0, (double)8.0), FramedCornerSlopeBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0)}).m_83296_();
                VoxelShape shapeBottomRight = Shapes.m_83124_((VoxelShape)FramedCornerSlopeBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), (VoxelShape[])new VoxelShape[]{FramedCornerSlopeBlock.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)8.0), FramedCornerSlopeBlock.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)12.0), FramedCornerSlopeBlock.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0)}).m_83296_();
                VoxelShape shapeTopLeft = Shapes.m_83124_((VoxelShape)FramedCornerSlopeBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), (VoxelShape[])new VoxelShape[]{FramedCornerSlopeBlock.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)12.0, (double)16.0, (double)8.0), FramedCornerSlopeBlock.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)12.0), FramedCornerSlopeBlock.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0)}).m_83296_();
                VoxelShape shapeTopRight = Shapes.m_83124_((VoxelShape)FramedCornerSlopeBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), (VoxelShape[])new VoxelShape[]{FramedCornerSlopeBlock.m_49796_((double)4.0, (double)4.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), FramedCornerSlopeBlock.m_49796_((double)8.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)12.0), FramedCornerSlopeBlock.m_49796_((double)12.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)}).m_83296_();
                VoxelShape shape = switch (type) {
                    case CornerType.HORIZONTAL_BOTTOM_LEFT -> shapeBottomLeft;
                    case CornerType.HORIZONTAL_BOTTOM_RIGHT -> shapeBottomRight;
                    case CornerType.HORIZONTAL_TOP_LEFT -> shapeTopLeft;
                    case CornerType.HORIZONTAL_TOP_RIGHT -> shapeTopRight;
                    default -> Shapes.m_83144_();
                };
                builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, dir, shape));
                continue;
            }
            if (type.isTop()) {
                VoxelShape shapeTop = Shapes.m_83124_((VoxelShape)FramedCornerSlopeBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)4.0, (double)4.0), (VoxelShape[])new VoxelShape[]{FramedCornerSlopeBlock.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0), FramedCornerSlopeBlock.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)12.0, (double)12.0, (double)12.0), FramedCornerSlopeBlock.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)}).m_83296_();
                builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, dir, shapeTop));
                continue;
            }
            VoxelShape shapeBottom = Shapes.m_83124_((VoxelShape)FramedCornerSlopeBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedCornerSlopeBlock.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)12.0, (double)8.0, (double)12.0), FramedCornerSlopeBlock.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)12.0, (double)8.0), FramedCornerSlopeBlock.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)4.0, (double)16.0, (double)4.0)}).m_83296_();
            builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, dir, shapeBottom));
        }
        return builder.build();
    }

    public static ImmutableMap<BlockState, VoxelShape> generateInnerCornerShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            CornerType type = (CornerType)((Object)state.m_61143_(PropertyHolder.CORNER_TYPE));
            Direction dir = (Direction)state.m_61143_((Property)PropertyHolder.FACING_HOR);
            if (type.isHorizontal()) {
                VoxelShape shapeBottomLeft = Shapes.m_83124_((VoxelShape)FramedCornerSlopeBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), (VoxelShape[])new VoxelShape[]{FramedCornerSlopeBlock.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)12.0, (double)8.0), FramedCornerSlopeBlock.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0, (double)12.0), FramedCornerSlopeBlock.m_49796_((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)4.0, (double)16.0), FramedCornerSlopeBlock.m_49796_((double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)12.0), FramedCornerSlopeBlock.m_49796_((double)0.0, (double)4.0, (double)12.0, (double)4.0, (double)16.0, (double)16.0), FramedCornerSlopeBlock.m_49796_((double)0.0, (double)12.0, (double)4.0, (double)12.0, (double)16.0, (double)8.0)}).m_83296_();
                VoxelShape shapeBottomRight = Shapes.m_83124_((VoxelShape)FramedCornerSlopeBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), (VoxelShape[])new VoxelShape[]{FramedCornerSlopeBlock.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)12.0, (double)8.0), FramedCornerSlopeBlock.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0, (double)12.0), FramedCornerSlopeBlock.m_49796_((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)4.0, (double)16.0), FramedCornerSlopeBlock.m_49796_((double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0, (double)12.0), FramedCornerSlopeBlock.m_49796_((double)12.0, (double)4.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0), FramedCornerSlopeBlock.m_49796_((double)4.0, (double)12.0, (double)4.0, (double)16.0, (double)16.0, (double)8.0)}).m_83296_();
                VoxelShape shapeTopLeft = Shapes.m_83124_((VoxelShape)FramedCornerSlopeBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), (VoxelShape[])new VoxelShape[]{FramedCornerSlopeBlock.m_49796_((double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)16.0, (double)8.0), FramedCornerSlopeBlock.m_49796_((double)0.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0, (double)12.0), FramedCornerSlopeBlock.m_49796_((double)0.0, (double)12.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0), FramedCornerSlopeBlock.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)12.0), FramedCornerSlopeBlock.m_49796_((double)0.0, (double)0.0, (double)12.0, (double)4.0, (double)12.0, (double)16.0), FramedCornerSlopeBlock.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0, (double)8.0)}).m_83296_();
                VoxelShape shapeTopRight = Shapes.m_83124_((VoxelShape)FramedCornerSlopeBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), (VoxelShape[])new VoxelShape[]{FramedCornerSlopeBlock.m_49796_((double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)16.0, (double)8.0), FramedCornerSlopeBlock.m_49796_((double)0.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0, (double)12.0), FramedCornerSlopeBlock.m_49796_((double)0.0, (double)12.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0), FramedCornerSlopeBlock.m_49796_((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0, (double)12.0), FramedCornerSlopeBlock.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)16.0, (double)12.0, (double)16.0), FramedCornerSlopeBlock.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)16.0, (double)4.0, (double)8.0)}).m_83296_();
                VoxelShape shape = switch (type) {
                    case CornerType.HORIZONTAL_BOTTOM_LEFT -> shapeBottomLeft;
                    case CornerType.HORIZONTAL_BOTTOM_RIGHT -> shapeBottomRight;
                    case CornerType.HORIZONTAL_TOP_LEFT -> shapeTopLeft;
                    case CornerType.HORIZONTAL_TOP_RIGHT -> shapeTopRight;
                    default -> Shapes.m_83144_();
                };
                builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, dir, shape));
                continue;
            }
            if (type.isTop()) {
                VoxelShape shapeTop = Shapes.m_83124_((VoxelShape)FramedCornerSlopeBlock.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedCornerSlopeBlock.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)12.0), FramedCornerSlopeBlock.m_49796_((double)0.0, (double)8.0, (double)12.0, (double)12.0, (double)12.0, (double)16.0), FramedCornerSlopeBlock.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0), FramedCornerSlopeBlock.m_49796_((double)0.0, (double)4.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0), FramedCornerSlopeBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)4.0), FramedCornerSlopeBlock.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)4.0, (double)4.0, (double)16.0)}).m_83296_();
                builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, dir, shapeTop));
                continue;
            }
            VoxelShape shapeBottom = Shapes.m_83124_((VoxelShape)FramedCornerSlopeBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedCornerSlopeBlock.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)12.0), FramedCornerSlopeBlock.m_49796_((double)0.0, (double)4.0, (double)12.0, (double)12.0, (double)8.0, (double)16.0), FramedCornerSlopeBlock.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)8.0), FramedCornerSlopeBlock.m_49796_((double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)12.0, (double)16.0), FramedCornerSlopeBlock.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), FramedCornerSlopeBlock.m_49796_((double)0.0, (double)12.0, (double)4.0, (double)4.0, (double)16.0, (double)16.0)}).m_83296_();
            builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, dir, shapeBottom));
        }
        return builder.build();
    }
}

