/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.BlockHitResult;
import xfacthd.framedblocks.api.block.FramedBlockEntity;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.CtmPredicate;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedDoorBlock
extends DoorBlock
implements IFramedBlock {
    public static final CtmPredicate CTM_PREDICATE = (state, dir) -> {
        Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61446_)).booleanValue()) {
            if (state.m_61143_((Property)BlockStateProperties.f_61394_) == DoorHingeSide.LEFT) {
                return facing.m_122428_() == dir;
            }
            return facing.m_122427_() == dir;
        }
        return facing.m_122424_() == dir;
    };

    public FramedDoorBlock() {
        super(IFramedBlock.createProperties());
    }

    public final InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        InteractionResult result = this.handleUse(level, pos, player, hand, hit);
        if (result.m_19077_()) {
            return result;
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        this.tryApplyCamoImmediately(level, pos, placer, stack);
        this.tryApplyCamoImmediately(level, pos.m_7494_(), placer, stack);
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getLight(level, pos);
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, Entity entity) {
        return this.getCamoSound(state, level, pos);
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return this.getCamoExplosionResistance(state, level, pos, explosion);
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        return this.getCamoDrops(super.m_7381_(state, builder), builder);
    }

    public float getFriction(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        return this.getCamoSlipperiness(state, level, pos, entity);
    }

    public final BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FramedBlockEntity(pos, state);
    }

    @Override
    public BlockType getBlockType() {
        return BlockType.FRAMED_DOOR;
    }
}

