/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedBlockEntity;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedPaneBlock
extends IronBarsBlock
implements IFramedBlock {
    private final BlockType type;

    public FramedPaneBlock(BlockType type) {
        super(IFramedBlock.createProperties());
        this.type = type;
    }

    public final InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return this.handleUse(level, pos, player, hand, hit);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        this.tryApplyCamoImmediately(level, pos, placer, stack);
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getLight(level, pos);
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, Entity entity) {
        return this.getCamoSound(state, level, pos);
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return this.getCamoExplosionResistance(state, level, pos, explosion);
    }

    public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        return this.isCamoFlammable(level, pos, face);
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        return this.getCamoFlammability(level, pos, face);
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        return this.getCamoDrops(super.m_7381_(state, builder), builder);
    }

    public float getFriction(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        return this.getCamoSlipperiness(state, level, pos, entity);
    }

    public boolean m_6104_(BlockState state, BlockState adjacentState, Direction side) {
        return this == FBContent.blockFramedBars.get() && super.m_6104_(state, adjacentState, side);
    }

    public final BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FramedBlockEntity(pos, state);
    }

    @Override
    public BlockType getBlockType() {
        return this.type;
    }

    public static ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape center = FramedPaneBlock.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
        VoxelShape wing = FramedPaneBlock.m_49796_((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)7.0);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            boolean north = (Boolean)state.m_61143_((Property)f_52309_);
            boolean east = (Boolean)state.m_61143_((Property)f_52310_);
            boolean south = (Boolean)state.m_61143_((Property)f_52311_);
            boolean west = (Boolean)state.m_61143_((Property)f_52312_);
            VoxelShape shape = center;
            if (north) {
                shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)wing, (BooleanOp)BooleanOp.f_82695_);
            }
            if (east) {
                shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Utils.rotateShape(Direction.NORTH, Direction.EAST, wing), (BooleanOp)BooleanOp.f_82695_);
            }
            if (south) {
                shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Utils.rotateShape(Direction.NORTH, Direction.SOUTH, wing), (BooleanOp)BooleanOp.f_82695_);
            }
            if (west) {
                shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Utils.rotateShape(Direction.NORTH, Direction.WEST, wing), (BooleanOp)BooleanOp.f_82695_);
            }
            builder.put((Object)state, (Object)shape.m_83296_());
        }
        return builder.build();
    }
}

