/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedPillarBlock
extends FramedBlock {
    public FramedPillarBlock(BlockType blockType) {
        super(blockType);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61365_, BlockStateProperties.f_61362_});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = this.m_49966_();
        state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)context.m_43719_().m_122434_());
        return FramedPillarBlock.withWater(state, (LevelReader)context.m_43725_(), context.m_8083_());
    }

    public static ImmutableMap<BlockState, VoxelShape> generatePillarShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape shapeX = FramedPillarBlock.m_49796_((double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
        VoxelShape shapeY = FramedPillarBlock.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
        VoxelShape shapeZ = FramedPillarBlock.m_49796_((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)16.0);
        for (BlockState state : states) {
            builder.put((Object)state, (Object)(switch ((Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61365_)) {
                case Direction.Axis.X -> shapeX;
                case Direction.Axis.Y -> shapeY;
                case Direction.Axis.Z -> shapeZ;
                default -> throw new IncompatibleClassChangeError();
            }));
        }
        return builder.build();
    }

    public static ImmutableMap<BlockState, VoxelShape> generatePostShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape shapeX = FramedPillarBlock.m_49796_((double)0.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
        VoxelShape shapeY = FramedPillarBlock.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
        VoxelShape shapeZ = FramedPillarBlock.m_49796_((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)16.0);
        for (BlockState state : states) {
            builder.put((Object)state, (Object)(switch ((Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61365_)) {
                case Direction.Axis.X -> shapeX;
                case Direction.Axis.Y -> shapeY;
                case Direction.Axis.Z -> shapeZ;
                default -> throw new IncompatibleClassChangeError();
            }));
        }
        return builder.build();
    }
}

