/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.blockentity;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import xfacthd.framedblocks.api.block.FramedBlockEntity;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.ChestState;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.menu.FramedChestMenu;

public class FramedChestBlockEntity
extends FramedBlockEntity
implements MenuProvider {
    public static final Component TITLE = new TranslatableComponent("title.framedblocks:framed_chest");
    private final ItemStackHandler itemHandler = new ItemStackHandler(36);
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private int openCount = 0;
    private long closeStart = 0L;
    private long lastChangeTime = 0L;
    private ChestState lastState = ChestState.CLOSED;

    public FramedChestBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FBContent.blockEntityTypeFramedChest.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, FramedChestBlockEntity tile) {
        if (!level.m_5776_() && level.m_46467_() - tile.closeStart >= 10L && state.m_61143_(PropertyHolder.CHEST_STATE) == ChestState.CLOSING) {
            tile.closeStart = 0L;
            level.m_46597_(pos, (BlockState)state.m_61124_(PropertyHolder.CHEST_STATE, (Comparable)((Object)ChestState.CLOSED)));
        }
    }

    public void open() {
        ++this.openCount;
    }

    public void close() {
        if (this.openCount > 0) {
            --this.openCount;
            if (this.openCount == 0) {
                this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11747_, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.nextFloat() * 0.1f + 0.9f);
                this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_(PropertyHolder.CHEST_STATE, (Comparable)((Object)ChestState.CLOSING)));
                this.closeStart = this.f_58857_.m_46467_();
            }
        }
    }

    public long getLastChangeTime(ChestState state) {
        if (this.lastChangeTime == 0L || state != this.lastState) {
            if (this.lastState == ChestState.CLOSING && state == ChestState.OPENING || this.lastState == ChestState.OPENING && state == ChestState.CLOSING) {
                long diff = this.f_58857_.m_46467_() - this.lastChangeTime;
                this.lastChangeTime = this.f_58857_.m_46467_() - (diff < 10L ? 10L - diff : 0L);
            } else {
                this.lastChangeTime = this.f_58857_.m_46467_();
            }
            this.lastState = state;
        }
        return this.lastChangeTime;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    public boolean isUsableByPlayer(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return !(player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) > 64.0);
    }

    public List<ItemStack> getDrops() {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            drops.add(stack);
        }
        return drops;
    }

    @Override
    public CompoundTag writeToBlueprint() {
        return super.m_6945_(new CompoundTag());
    }

    @Override
    public CompoundTag m_6945_(CompoundTag nbt) {
        nbt.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        return super.m_6945_(nbt);
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("inventory"));
    }

    public Component m_5446_() {
        return TITLE;
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new FramedChestMenu(windowId, inv, this);
    }
}

