/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.blockentity;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import xfacthd.framedblocks.api.block.FramedBlockEntity;
import xfacthd.framedblocks.api.util.FramedBlockData;

public abstract class FramedDoubleBlockEntity
extends FramedBlockEntity {
    public static final ModelProperty<IModelData> DATA_LEFT = new ModelProperty();
    public static final ModelProperty<IModelData> DATA_RIGHT = new ModelProperty();
    private final IModelData multiModelData = new ModelDataMap.Builder().build();
    private final FramedBlockData modelData = new FramedBlockData();
    private ItemStack camoStack = ItemStack.f_41583_;
    private BlockState camoState = Blocks.f_50016_.m_49966_();

    public FramedDoubleBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void setCamo(ItemStack camoStack, BlockState camoState, boolean secondary) {
        if (secondary) {
            int light = this.getLightValue();
            this.camoStack = camoStack;
            this.camoState = camoState;
            this.m_6596_();
            if (this.getLightValue() != light) {
                this.doLightUpdate();
            }
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        } else {
            super.setCamo(camoStack, camoState, false);
        }
    }

    @Override
    protected void applyCamo(ItemStack camoStack, BlockState camoState, BlockHitResult hit) {
        if (this.hitSecondary(hit)) {
            this.camoStack = camoStack;
            this.camoState = camoState;
        } else {
            super.applyCamo(camoStack, camoState, hit);
        }
    }

    public BlockState getCamoStateTwo() {
        return this.camoState;
    }

    public ItemStack getCamoStackTwo() {
        return this.camoStack;
    }

    @Override
    public int getLightValue() {
        return Math.max(this.camoState.m_60791_(), super.getLightValue());
    }

    @Override
    public void addCamoDrops(List<ItemStack> drops) {
        super.addCamoDrops(drops);
        if (!this.camoStack.m_41619_()) {
            drops.add(this.camoStack);
        }
    }

    @Override
    protected BlockState getCamoState(BlockHitResult hit) {
        return this.hitSecondary(hit) ? this.getCamoStateTwo() : this.getCamoState();
    }

    @Override
    protected ItemStack getCamoStack(BlockHitResult hit) {
        return this.hitSecondary(hit) ? this.getCamoStackTwo() : this.getCamoStack();
    }

    @Override
    public float getCamoExplosionResistance(Explosion explosion) {
        return Math.max(this.getCamoState().getExplosionResistance((BlockGetter)this.f_58857_, this.f_58858_, explosion), this.getCamoStateTwo().getExplosionResistance((BlockGetter)this.f_58857_, this.f_58858_, explosion));
    }

    @Override
    public boolean isCamoFlammable(Direction face) {
        BlockState camo = this.getCamoState(face);
        if (!(!camo.m_60795_() || this.getCamoState().m_60795_() && this.getCamoStateTwo().m_60795_())) {
            return !(!this.getCamoState().m_60795_() && !this.getCamoState().isFlammable((BlockGetter)this.f_58857_, this.f_58858_, face) || !this.getCamoStateTwo().m_60795_() && !this.getCamoStateTwo().isFlammable((BlockGetter)this.f_58857_, this.f_58858_, face));
        }
        if (!camo.m_60795_()) {
            return camo.isFlammable((BlockGetter)this.f_58857_, this.f_58858_, face);
        }
        return true;
    }

    @Override
    public int getCamoFlammability(Direction face) {
        int flammabilityTwo;
        int flammabilityOne = super.getCamoFlammability(face);
        int n = flammabilityTwo = this.getCamoStateTwo().m_60795_() ? -1 : this.getCamoStateTwo().getFlammability((BlockGetter)this.f_58857_, this.f_58858_, face);
        if (flammabilityOne == -1) {
            return flammabilityTwo;
        }
        if (flammabilityTwo == -1) {
            return flammabilityOne;
        }
        return Math.min(flammabilityOne, flammabilityTwo);
    }

    protected abstract boolean hitSecondary(BlockHitResult var1);

    @Override
    protected void writeToDataPacket(CompoundTag nbt) {
        super.writeToDataPacket(nbt);
        nbt.m_128365_("camo_stack_two", (Tag)this.camoStack.m_41739_(new CompoundTag()));
        nbt.m_128365_("camo_state_two", (Tag)NbtUtils.m_129202_((BlockState)this.camoState));
    }

    @Override
    protected boolean readFromDataPacket(CompoundTag nbt) {
        this.camoStack = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("camo_stack_two"));
        boolean needUpdate = false;
        BlockState newState = NbtUtils.m_129241_((CompoundTag)nbt.m_128469_("camo_state_two"));
        if (newState != this.camoState) {
            this.camoState = newState;
            this.modelData.setLevel(this.f_58857_);
            this.modelData.setPos(this.f_58858_);
            this.modelData.setCamoState(this.camoState);
            needUpdate = true;
        }
        return super.readFromDataPacket(nbt) || needUpdate;
    }

    @Override
    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        nbt.m_128365_("camo_stack_two", (Tag)this.camoStack.m_41739_(new CompoundTag()));
        nbt.m_128365_("camo_state_two", (Tag)NbtUtils.m_129202_((BlockState)this.camoState));
        return nbt;
    }

    @Override
    public void handleUpdateTag(CompoundTag nbt) {
        super.handleUpdateTag(nbt);
        this.camoStack = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("camo_stack_two"));
        BlockState newState = NbtUtils.m_129241_((CompoundTag)nbt.m_128469_("camo_state_two"));
        if (newState != this.camoState) {
            this.camoState = newState;
            this.modelData.setLevel(this.f_58857_);
            this.modelData.setPos(this.f_58858_);
            this.modelData.setCamoState(this.camoState);
        }
    }

    @Override
    public IModelData getModelData() {
        this.multiModelData.setData(DATA_LEFT, (Object)super.getModelData());
        this.multiModelData.setData(DATA_RIGHT, (Object)this.modelData);
        return this.multiModelData;
    }

    @Override
    public CompoundTag m_6945_(CompoundTag nbt) {
        nbt.m_128365_("camo_stack_two", (Tag)this.camoStack.m_41739_(new CompoundTag()));
        nbt.m_128365_("camo_state_two", (Tag)NbtUtils.m_129202_((BlockState)this.camoState));
        return super.m_6945_(nbt);
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.camoStack = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("camo_stack_two"));
        this.camoState = NbtUtils.m_129241_((CompoundTag)nbt.m_128469_("camo_state_two"));
    }
}

