/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.util.SideSkipPredicate;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.StairsType;

public class CornerPillarSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        Direction dir = (Direction)state.m_61143_((Property)PropertyHolder.FACING_HOR);
        if (adjState.m_60734_() == FBContent.blockFramedPanel.get()) {
            return CornerPillarSkipPredicate.testAgainstPanel(level, pos, dir, adjState, side);
        }
        if (adjState.m_60734_() == FBContent.blockFramedCornerPillar.get()) {
            return CornerPillarSkipPredicate.testAgainstPillar(level, pos, dir, adjState, side);
        }
        if (adjState.m_60734_() == FBContent.blockFramedSlabCorner.get()) {
            return CornerPillarSkipPredicate.testAgainstCorner(level, pos, dir, adjState, side);
        }
        if (adjState.m_60734_() == FBContent.blockFramedDoublePanel.get()) {
            return CornerPillarSkipPredicate.testAgainstDoublePanel(level, pos, dir, adjState, side);
        }
        if (adjState.m_60734_() == FBContent.blockFramedStairs.get() && side.m_122434_() == Direction.Axis.Y) {
            return CornerPillarSkipPredicate.testAgainstStairs(level, pos, dir, adjState, side);
        }
        if (adjState.m_60734_() == FBContent.blockFramedVerticalStairs.get()) {
            return CornerPillarSkipPredicate.testAgainstVerticalStairs(level, pos, dir, adjState, side);
        }
        return false;
    }

    private static boolean testAgainstPanel(BlockGetter level, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        if (side != dir && side != dir.m_122428_()) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        if (side == dir && adjDir == dir.m_122428_() || side == dir.m_122428_() && dir == adjDir) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstPillar(BlockGetter level, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        if (side == dir && adjDir == dir.m_122428_() || side == dir.m_122428_() && adjDir == dir.m_122427_()) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstCorner(BlockGetter level, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP);
        if (adjTop && side == Direction.DOWN || !adjTop && side == Direction.UP) {
            return dir == adjDir && SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstDoublePanel(BlockGetter level, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_NE);
        if (side == dir && (adjDir == dir.m_122427_() || adjDir == dir.m_122428_())) {
            return SideSkipPredicate.compareState(level, pos, side, dir.m_122428_());
        }
        if (side == dir.m_122428_() && (adjDir == dir || adjDir == dir.m_122424_())) {
            return SideSkipPredicate.compareState(level, pos, side, dir);
        }
        return false;
    }

    private static boolean testAgainstStairs(BlockGetter level, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        boolean adjTop;
        Direction adjDir = (Direction)adjState.m_61143_((Property)BlockStateProperties.f_61374_);
        StairsShape adjShape = (StairsShape)adjState.m_61143_((Property)BlockStateProperties.f_61398_);
        boolean bl = adjTop = adjState.m_61143_((Property)BlockStateProperties.f_61402_) == Half.TOP;
        if (adjTop && side == Direction.UP || !adjTop && side == Direction.DOWN) {
            if (adjShape == StairsShape.OUTER_LEFT) {
                return dir == adjDir && SideSkipPredicate.compareState(level, pos, side);
            }
            if (adjShape == StairsShape.OUTER_RIGHT) {
                return dir.m_122428_() == adjDir && SideSkipPredicate.compareState(level, pos, side);
            }
        }
        return false;
    }

    private static boolean testAgainstVerticalStairs(BlockGetter level, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.m_61143_(PropertyHolder.STAIRS_TYPE));
        if (adjType == StairsType.VERTICAL ? (side == dir.m_122428_() || side == dir) && adjDir == dir : side.m_122434_() == Direction.Axis.Y && side == Direction.DOWN == adjType.isTop() && adjDir == dir) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }
}

