/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.util.SideSkipPredicate;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.StairsType;

public class SlabCornerSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        Direction dir = (Direction)state.m_61143_((Property)PropertyHolder.FACING_HOR);
        boolean top = (Boolean)state.m_61143_((Property)PropertyHolder.TOP);
        if (adjState.m_60734_() == FBContent.blockFramedSlabCorner.get()) {
            return SlabCornerSkipPredicate.testAgainstCorner(level, pos, dir, top, adjState, side);
        }
        if (adjState.m_60734_() == FBContent.blockFramedSlabEdge.get()) {
            return SlabCornerSkipPredicate.testAgainstEdge(level, pos, dir, top, adjState, side);
        }
        if (adjState.m_60734_() == FBContent.blockFramedCornerPillar.get()) {
            return SlabCornerSkipPredicate.testAgainstPillar(level, pos, dir, top, adjState, side);
        }
        if (adjState.m_60734_() == FBContent.blockFramedStairs.get()) {
            return SlabCornerSkipPredicate.testAgainstStairs(level, pos, dir, top, adjState, side);
        }
        if (adjState.m_60734_() == FBContent.blockFramedVerticalStairs.get()) {
            return SlabCornerSkipPredicate.testAgainstVerticalStairs(level, pos, dir, top, adjState, side);
        }
        return false;
    }

    private static boolean testAgainstCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP);
        if (side == dir && adjDir == dir.m_122428_() || side == dir.m_122428_() && adjDir == dir.m_122427_()) {
            return top == adjTop && SideSkipPredicate.compareState(level, pos, side);
        }
        if (side == Direction.DOWN && !top && adjTop || side == Direction.UP && top && !adjTop) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstEdge(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP);
        if (side == dir && adjDir == dir.m_122428_() || side == dir.m_122428_() && adjDir == dir) {
            return top == adjTop && SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstPillar(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        if (top && side == Direction.UP || !top && side == Direction.DOWN) {
            return dir == adjDir && SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstStairs(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        boolean adjTop;
        if (side.m_122434_() != Direction.Axis.Y) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)BlockStateProperties.f_61374_);
        StairsShape adjShape = (StairsShape)adjState.m_61143_((Property)BlockStateProperties.f_61398_);
        boolean bl = adjTop = adjState.m_61143_((Property)BlockStateProperties.f_61402_) == Half.TOP;
        if (top != adjTop) {
            return false;
        }
        if (adjShape == StairsShape.OUTER_LEFT) {
            return dir == adjDir && SideSkipPredicate.compareState(level, pos, side);
        }
        if (adjShape == StairsShape.OUTER_RIGHT) {
            return dir.m_122428_() == adjDir && SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstVerticalStairs(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.m_61143_(PropertyHolder.STAIRS_TYPE));
        if (adjType.isTop() == top || dir != adjDir) {
            return false;
        }
        if (side.m_122434_() == Direction.Axis.Y || side == dir || side == dir.m_122428_()) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }
}

